/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityChunkLoader;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;

public class BlockChunkLoader
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    private static final VoxelShape SHAPE = BlockChunkLoader.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BlockChunkLoader() {
        super("chunk_loader", TileEntityChunkLoader::new, ModBlocks.prop(Material.field_151576_e).func_200943_b(3.0f).func_200947_a(SoundType.field_185851_d));
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        int range;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityChunkLoader && (range = ((TileEntityChunkLoader)tile).range()) > 0) {
            return new AxisAlignedBB((double)(pos.func_177958_n() - range >> 4 << 4), 0.0, (double)(pos.func_177952_p() - range >> 4 << 4), (double)((pos.func_177958_n() + range >> 4 << 4) + 16), (double)world.func_217301_I(), (double)((pos.func_177952_p() + range >> 4 << 4) + 16));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityChunkLoader) {
            int range = ((TileEntityChunkLoader)tile).range();
            for (int i = MathHelper.func_76123_f((float)((float)range / 8.0f)); i > 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((float)pos.func_177958_n() + worldIn.field_73012_v.nextFloat(), (float)pos.func_177956_o() + worldIn.field_73012_v.nextFloat(), (float)pos.func_177952_p() + worldIn.field_73012_v.nextFloat(), 0.0, 0.0, 0.0, 10563071, 1.0f + worldIn.field_73012_v.nextFloat(), 100, 0.0f, false, true);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 12671481;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

