/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityRFConverter
extends TileEntityImpl
implements ITickableTileEntity {
    public final RFStorage storage = new RFStorage();
    private int lastEnergy;

    public TileEntityRFConverter() {
        super(ModTileEntities.RF_CONVERTER);
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        compound.func_74768_a("energy", this.storage.getEnergyStored());
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        this.storage.setEnergy(compound.func_74762_e("energy"));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int emptyPart;
            if (this.lastEnergy != this.storage.getEnergyStored() && this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.sendToClients();
                this.lastEnergy = this.storage.getEnergyStored();
            }
            for (Direction facing : Direction.values()) {
                int extracted;
                int canStore;
                IEnergyStorage storage;
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || (storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()).orElse(null)) == null || (canStore = storage.receiveEnergy(Integer.MAX_VALUE, true)) <= 0 || (extracted = this.storage.extractEnergy(canStore, false)) <= 0) continue;
                storage.receiveEnergy(extracted, false);
                break;
            }
            if ((emptyPart = this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) <= 0) {
                return;
            }
            if (this.field_145850_b.func_82737_E() % 20L != 0L) {
                return;
            }
            if (!Multiblocks.RF_CONVERTER.isComplete(this.field_145850_b, this.field_174879_c)) {
                return;
            }
            int aura = IAuraChunk.getAuraInArea((IWorld)this.field_145850_b, this.field_174879_c, 45);
            if (aura <= 1000000) {
                return;
            }
            int amountToGen = Math.min(Math.min(10000, aura / 1000), emptyPart);
            int amountToUse = MathHelper.func_76143_f((double)((double)amountToGen / (Double)ModConfig.instance.auraToRFRatio.get()));
            this.storage.setEnergy(this.storage.getEnergyStored() + amountToGen);
            BlockPos pos = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 45, this.field_174879_c);
            IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, pos).drainAura(pos, amountToUse);
            PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), PacketParticles.Type.RF_CONVERTER, new int[0]));
        }
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.storage);
        }
        return super.getCapability(capability, facing);
    }

    public static class RFStorage
    extends EnergyStorage {
        public RFStorage() {
            super(50000, 0, 2000);
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }
    }
}

