/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.Tags;

public class NetherGrassEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "nether_grass");
    private int amount;
    private int dist;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea((IWorld)world, pos, 30);
        if (aura < 1500000) {
            return false;
        }
        this.amount = Math.min(20, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 100000.0f / (float)IAuraChunk.getSpotAmountInArea((IWorld)world, pos, 30))));
        if (this.amount <= 1) {
            return false;
        }
        this.dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 100000), (int)5, (int)35);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(PlayerEntity player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (NaturesAuraAPI.instance().isEffectPowderActive(player.field_70170_p, player.func_180425_c(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((IItemProvider)ModBlocks.NETHER_GRASS);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        block0: for (int i = this.amount / 2 + world.field_73012_v.nextInt(this.amount / 2); i >= 0; --i) {
            int x = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)this.dist));
            int y = MathHelper.func_76128_c((double)((double)pos.func_177956_o() + world.field_73012_v.nextGaussian() * (double)this.dist));
            int z = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)this.dist));
            for (int yOff = -5; yOff <= 5; ++yOff) {
                BlockState state;
                Block block;
                BlockPos up;
                BlockPos goalPos = new BlockPos(x, y + yOff, z);
                if (!(goalPos.func_177951_i((Vec3i)pos) <= (double)(this.dist * this.dist)) || !world.func_175667_e(goalPos) || NaturesAuraAPI.instance().isEffectPowderActive(world, goalPos, NAME) || world.func_180495_p(up = goalPos.func_177984_a()).func_224755_d((IBlockReader)world, up, Direction.DOWN) || !Tags.Blocks.NETHERRACK.func_199685_a_((Object)(block = (state = world.func_180495_p(goalPos)).func_177230_c()))) continue;
                world.func_175656_a(goalPos, ModBlocks.NETHER_GRASS.func_176223_P());
                BlockPos closestSpot = IAuraChunk.getHighestSpot((IWorld)world, goalPos, 25, pos);
                IAuraChunk.getAuraChunk((IWorld)world, closestSpot).drainAura(closestSpot, 500);
                PacketHandler.sendToAllAround((IWorld)world, goalPos, 32, new PacketParticles(goalPos.func_177958_n(), (float)goalPos.func_177956_o() + 0.5f, goalPos.func_177952_p(), PacketParticles.Type.PLANT_BOOST, new int[0]));
                continue block0;
            }
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.netherGrassEffect.get() != false && type.isSimilar(NaturesAuraAPI.TYPE_NETHER);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

