/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class PlantBoostEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "plant_boost");
    private int amount;
    private int dist;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea((IWorld)world, pos, 30);
        if (aura < 1500000) {
            return false;
        }
        this.amount = Math.min(45, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 100000.0f / (float)IAuraChunk.getSpotAmountInArea((IWorld)world, pos, 30))));
        if (this.amount <= 1) {
            return false;
        }
        this.dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 150000), (int)5, (int)35);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(PlayerEntity player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (NaturesAuraAPI.instance().isEffectPowderActive(player.field_70170_p, player.func_180425_c(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((IItemProvider)Items.field_151014_N);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + world.field_73012_v.nextInt(this.amount / 2); i >= 0; --i) {
            BlockPos plantPos;
            block4: {
                IGrowable growable;
                BlockState state;
                Block block;
                int z;
                int x = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)this.dist));
                plantPos = new BlockPos(x, world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)this.dist))), z).func_177977_b();
                if (!(plantPos.func_177951_i((Vec3i)pos) <= (double)(this.dist * this.dist)) || !world.func_175667_e(plantPos) || NaturesAuraAPI.instance().isEffectPowderActive(world, plantPos, NAME) || !((block = (state = world.func_180495_p(plantPos)).func_177230_c()) instanceof IGrowable) || block instanceof DoublePlantBlock || block instanceof TallGrassBlock || block == Blocks.field_196658_i || !(growable = (IGrowable)block).func_176473_a((IBlockReader)world, plantPos, state, false)) continue;
                try {
                    growable.func_225535_a_((ServerWorld)world, world.field_73012_v, plantPos, state);
                }
                catch (Exception e) {
                    if (growable instanceof BambooBlock) break block4;
                    throw e;
                }
            }
            BlockPos closestSpot = IAuraChunk.getHighestSpot((IWorld)world, plantPos, 25, pos);
            IAuraChunk.getAuraChunk((IWorld)world, closestSpot).drainAura(closestSpot, 3500);
            PacketHandler.sendToAllAround((IWorld)world, plantPos, 32, new PacketParticles(plantPos.func_177958_n(), plantPos.func_177956_o(), plantPos.func_177952_p(), PacketParticles.Type.PLANT_BOOST, new int[0]));
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.plantBoostEffect.get() != false && type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

