/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat;

import com.google.common.collect.ImmutableMap;
import de.ellpeck.naturesaura.compat.ICompat;
import de.ellpeck.naturesaura.data.ItemTagProvider;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.CurioTags;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;

public class CuriosCompat
implements ICompat {
    private static final Map<Item, Tag<Item>> TYPES = ImmutableMap.builder().put((Object)ModItems.EYE, (Object)CurioTags.CHARM).put((Object)ModItems.EYE_IMPROVED, (Object)CurioTags.CHARM).put((Object)ModItems.AURA_CACHE, (Object)CurioTags.BELT).put((Object)ModItems.AURA_TROVE, (Object)CurioTags.BELT).put((Object)ModItems.SHOCKWAVE_CREATOR, (Object)CurioTags.NECKLACE).put((Object)ModItems.DEATH_RING, (Object)CurioTags.RING).build();

    @Override
    public void setup() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void setupClient() {
    }

    @SubscribeEvent
    public void sendImc(InterModEnqueueEvent event) {
        TYPES.values().stream().distinct().forEach(t -> {
            String path = t.func_199886_b().func_110623_a();
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage(path));
        });
    }

    @SubscribeEvent
    public void onCapabilitiesAttach(AttachCapabilitiesEvent<ItemStack> event) {
        final ItemStack stack = (ItemStack)event.getObject();
        if (TYPES.containsKey(stack.func_77973_b())) {
            event.addCapability(new ResourceLocation("naturesaura", "curios"), new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap != CuriosCapability.ITEM) {
                        return LazyOptional.empty();
                    }
                    return LazyOptional.of(() -> new ICurio(){

                        public void onCurioTick(String identifier, int index, LivingEntity livingEntity) {
                            stack.func_77973_b().func_77663_a(stack, livingEntity.field_70170_p, (Entity)livingEntity, -1, false);
                        }

                        public boolean canRightClickEquip() {
                            return true;
                        }

                        public boolean shouldSyncToTracking(String identifier, LivingEntity livingEntity) {
                            return true;
                        }
                    });
                }
            });
        }
    }

    @Override
    public void addItemTags(ItemTagProvider provider) {
        for (Map.Entry<Item, Tag<Item>> entry : TYPES.entrySet()) {
            provider.func_200426_a(entry.getValue()).func_200048_a((Object)entry.getKey());
        }
    }
}

