/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import de.ellpeck.naturesaura.items.ItemAuraBottle;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.recipes.AltarRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ProcessorAltar
implements IComponentProcessor {
    private AltarRecipe recipe;

    public void setup(IVariableProvider<String> provider) {
        this.recipe = (AltarRecipe)PatchouliCompat.getRecipe("altar", (String)provider.get("recipe"));
    }

    public String process(String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "input": {
                return PatchouliAPI.instance.serializeIngredient(this.recipe.input);
            }
            case "output": {
                return PatchouliAPI.instance.serializeItemStack(this.recipe.output);
            }
            case "catalyst": {
                if (this.recipe.catalyst != Ingredient.field_193370_a) {
                    return PatchouliAPI.instance.serializeIngredient(this.recipe.catalyst);
                }
                return null;
            }
            case "type": {
                if (this.recipe.requiredType != null) {
                    return PatchouliAPI.instance.serializeItemStack(ItemAuraBottle.setType(new ItemStack((IItemProvider)ModItems.AURA_BOTTLE), this.recipe.requiredType));
                }
                return null;
            }
            case "name": {
                return this.recipe.output.func_200301_q().func_150254_d();
            }
        }
        return null;
    }

    public boolean allowRender(String group) {
        return group.isEmpty() || group.equals(this.recipe.catalyst == Ingredient.field_193370_a ? "altar" : "catalyst");
    }
}

