/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.item.IAuraRecharge;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.lwjgl.opengl.GL11;

public final class Helper {
    public static boolean getTileEntitiesInArea(World world, BlockPos pos, int radius, Function<TileEntity, Boolean> consumer) {
        world.field_72984_F.func_194340_a(() -> "naturesaura:getTileEntitiesInArea");
        for (int x = pos.func_177958_n() - radius >> 4; x <= pos.func_177958_n() + radius >> 4; ++x) {
            for (int z = pos.func_177952_p() - radius >> 4; z <= pos.func_177952_p() + radius >> 4; ++z) {
                if (!Helper.isChunkLoaded(world, x, z)) continue;
                for (TileEntity tile : world.func_72964_e(x, z).func_177434_r().values()) {
                    if (!(tile.func_174877_v().func_177951_i((Vec3i)pos) <= (double)(radius * radius)) || !consumer.apply(tile).booleanValue()) continue;
                    world.field_72984_F.func_76319_b();
                    return true;
                }
            }
        }
        world.field_72984_F.func_76319_b();
        return false;
    }

    public static void getAuraChunksInArea(World world, BlockPos pos, int radius, Consumer<AuraChunk> consumer) {
        world.field_72984_F.func_194340_a(() -> "naturesaura:getAuraChunksInArea");
        for (int x = pos.func_177958_n() - radius >> 4; x <= pos.func_177958_n() + radius >> 4; ++x) {
            for (int z = pos.func_177952_p() - radius >> 4; z <= pos.func_177952_p() + radius >> 4; ++z) {
                Chunk chunk;
                if (!Helper.isChunkLoaded(world, x, z) || !(chunk = world.func_72964_e(x, z)).hasCapability(NaturesAuraAPI.capAuraChunk, null)) continue;
                AuraChunk auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null);
                consumer.accept(auraChunk);
            }
        }
        world.field_72984_F.func_76319_b();
    }

    public static List<EntityItemFrame> getAttachedItemFrames(World world, BlockPos pos) {
        List frames = world.func_72872_a(EntityItemFrame.class, new AxisAlignedBB(pos).func_186662_g(0.25));
        for (int i = frames.size() - 1; i >= 0; --i) {
            EntityItemFrame frame = (EntityItemFrame)frames.get(i);
            BlockPos framePos = frame.func_174857_n().func_177972_a(frame.field_174860_b.func_176734_d());
            if (pos.equals((Object)framePos)) continue;
            frames.remove(i);
        }
        return frames;
    }

    public static boolean isChunkLoaded(World world, int x, int z) {
        IChunkProvider provider = world.func_72863_F();
        if (provider instanceof ChunkProviderServer) {
            return ((ChunkProviderServer)provider).func_73149_a(x, z);
        }
        return !provider.func_186025_d(x, z).func_76621_g();
    }

    public static int blendColors(int c1, int c2, float ratio) {
        int a = (int)((float)(c1 >> 24 & 0xFF) * ratio + (float)(c2 >> 24 & 0xFF) * (1.0f - ratio));
        int r = (int)((float)(c1 >> 16 & 0xFF) * ratio + (float)(c2 >> 16 & 0xFF) * (1.0f - ratio));
        int g = (int)((float)(c1 >> 8 & 0xFF) * ratio + (float)(c2 >> 8 & 0xFF) * (1.0f - ratio));
        int b = (int)((float)(c1 & 0xFF) * ratio + (float)(c2 & 0xFF) * (1.0f - ratio));
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static boolean areItemsEqual(ItemStack first, ItemStack second, boolean nbt) {
        if (!ItemStack.func_179545_c((ItemStack)first, (ItemStack)second)) {
            return false;
        }
        return !nbt || ItemStack.areItemStackShareTagsEqual((ItemStack)first, (ItemStack)second);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderItemInWorld(ItemStack stack) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderItemInGui(ItemStack stack, int x, int y, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, 0, 0);
        Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, 0, 0, null);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    public static boolean putStackOnTile(EntityPlayer player, EnumHand hand, BlockPos pos, int slot, boolean sound) {
        IItemHandlerModifiable handler;
        TileEntity tile = player.field_70170_p.func_175625_s(pos);
        if (tile instanceof TileEntityImpl && (handler = ((TileEntityImpl)tile).getItemHandler(null)) != null) {
            ItemStack remain;
            ItemStack handStack = player.func_184586_b(hand);
            if (!handStack.func_190926_b() && !ItemStack.func_77989_b((ItemStack)(remain = handler.insertItem(slot, handStack, player.field_70170_p.field_72995_K)), (ItemStack)handStack)) {
                if (sound) {
                    player.field_70170_p.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187620_cL, SoundCategory.PLAYERS, 0.75f, 1.0f);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_184611_a(hand, remain);
                }
                return true;
            }
            if (!handler.getStackInSlot(slot).func_190926_b()) {
                if (sound) {
                    player.field_70170_p.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187629_cO, SoundCategory.PLAYERS, 0.75f, 1.0f);
                }
                if (!player.field_70170_p.field_72995_K) {
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (!player.func_191521_c(stack)) {
                        EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
                        player.field_70170_p.func_72838_d((Entity)item);
                    }
                    handler.setStackInSlot(slot, ItemStack.field_190927_a);
                }
                return true;
            }
        }
        return false;
    }

    public static ICapabilityProvider makeRechargeProvider(final ItemStack stack, final boolean needsSelected) {
        return new ICapabilityProvider(){
            private final IAuraRecharge recharge = (container, containerSlot, itemSlot, isSelected) -> {
                if (isSelected || !needsSelected) {
                    int toDrain = 300;
                    if (stack.func_77952_i() > 0 && container.drainAura(toDrain, true) >= toDrain) {
                        stack.func_77964_b(stack.func_77952_i() - 1);
                        container.drainAura(toDrain, false);
                        return true;
                    }
                }
                return false;
            };

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == NaturesAuraAPI.capAuraRecharge;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == NaturesAuraAPI.capAuraRecharge ? this.recharge : null);
            }
        };
    }

    public static IBlockState getStateFromString(String raw) {
        String[] split = raw.split("\\[");
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0]));
        if (block != null) {
            IBlockState state = block.func_176223_P();
            if (split.length > 1) {
                block0: for (String part : split[1].replace("]", "").split(",")) {
                    String[] keyValue = part.split("=");
                    for (IProperty prop : state.func_177228_b().keySet()) {
                        IBlockState changed = Helper.findProperty(state, prop, keyValue[0], keyValue[1]);
                        if (changed == null) continue;
                        state = changed;
                        continue block0;
                    }
                }
            }
            return state;
        }
        return null;
    }

    private static <T extends Comparable<T>> IBlockState findProperty(IBlockState state, IProperty<T> prop, String key, String newValue) {
        if (key.equals(prop.func_177701_a())) {
            for (Comparable value : prop.func_177700_c()) {
                if (!prop.func_177702_a(value).equals(newValue)) continue;
                return state.func_177226_a(prop, value);
            }
        }
        return null;
    }

    public static <T> void registerCap(Class<T> type) {
        CapabilityManager.INSTANCE.register(type, new Capability.IStorage<T>(){

            @Nullable
            public NBTBase writeNBT(Capability capability, Object instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability capability, Object instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> null);
    }

    public static void addAdvancement(EntityPlayer player, ResourceLocation advancement, String criterion) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMp = (EntityPlayerMP)player;
        Advancement adv = playerMp.func_71121_q().func_191952_z().func_192778_a(advancement);
        if (adv != null) {
            playerMp.func_192039_O().func_192750_a(adv, criterion);
        }
    }

    public static int getIngredientAmount(Ingredient ingredient) {
        int highestAmount = 0;
        for (ItemStack stack : ingredient.func_193365_a()) {
            if (stack.func_190916_E() <= highestAmount) continue;
            highestAmount = stack.func_190916_E();
        }
        return highestAmount;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderWeirdBox(double x, double y, double z, double width, double height, double depth) {
        GL11.glVertex3d((double)x, (double)(y + height), (double)z);
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)z);
        GL11.glVertex3d((double)(x + width), (double)y, (double)z);
        GL11.glVertex3d((double)x, (double)y, (double)z);
        GL11.glVertex3d((double)(x + width), (double)y, (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)y, (double)z);
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)z);
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)x, (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)x, (double)y, (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)y, (double)(z + depth));
        GL11.glVertex3d((double)x, (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)x, (double)(y + height), (double)z);
        GL11.glVertex3d((double)x, (double)y, (double)z);
        GL11.glVertex3d((double)x, (double)y, (double)(z + depth));
        GL11.glVertex3d((double)x, (double)(y + height), (double)z);
        GL11.glVertex3d((double)x, (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)z);
        GL11.glVertex3d((double)(x + width), (double)y, (double)z);
        GL11.glVertex3d((double)(x + width), (double)y, (double)(z + depth));
        GL11.glVertex3d((double)x, (double)y, (double)(z + depth));
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static boolean isHoldingItem(EntityPlayer player, Item item) {
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static AxisAlignedBB aabb(Vec3d pos) {
        return new AxisAlignedBB(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }
}

