/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.api.multiblock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class Matcher {
    private final IBlockState defaultState;
    private final ICheck check;

    public Matcher(IBlockState defaultState, ICheck check) {
        this.defaultState = defaultState;
        this.check = check;
    }

    public IBlockState getDefaultState() {
        return this.defaultState;
    }

    public ICheck getCheck() {
        return this.check;
    }

    public static Matcher wildcard() {
        return new Matcher(Blocks.field_150350_a.func_176223_P(), null);
    }

    public static Matcher oreDict(Block defaultBlock, final String name) {
        return new Matcher(defaultBlock.func_176223_P(), new ICheck(){
            private List<IBlockState> states;

            @Override
            public boolean matches(World world, BlockPos start, BlockPos offset, BlockPos pos, IBlockState state, char c) {
                if (this.states == null) {
                    this.states = new ArrayList<IBlockState>();
                    for (ItemStack stack : OreDictionary.getOres((String)name)) {
                        Block block = Block.func_149634_a((Item)stack.func_77973_b());
                        if (block == null || block == Blocks.field_150350_a) continue;
                        int damage = stack.func_77952_i();
                        if (damage == Short.MAX_VALUE) {
                            this.states.addAll((Collection<IBlockState>)block.func_176194_O().func_177619_a());
                            continue;
                        }
                        this.states.add(block.func_176203_a(damage));
                    }
                }
                return this.states.isEmpty() || this.states.contains(state);
            }
        });
    }

    public static interface ICheck {
        public boolean matches(World var1, BlockPos var2, BlockPos var3, BlockPos var4, IBlockState var5, char var6);
    }
}

