/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.api.recipes.TreeRitualRecipe;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityWoodStand;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderWoodStand;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockWoodStand
extends BlockContainerImpl
implements ITESRProvider {
    private static final AxisAlignedBB BOUND_BOX = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.8125, 0.8125);

    public BlockWoodStand() {
        super(Material.field_151575_d, "wood_stand", TileEntityWoodStand.class, "wood_stand");
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTreeGrow(SaplingGrowTreeEvent event) {
        IBlockState sapling;
        ItemStack saplingStack;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (!world.field_72995_K && Multiblocks.TREE_RITUAL.isComplete(world, pos) && !(saplingStack = (sapling = world.func_180495_p(pos)).func_177230_c().func_185473_a(world, pos, sapling)).func_190926_b()) {
            for (TreeRitualRecipe recipe : NaturesAuraAPI.TREE_RITUAL_RECIPES.values()) {
                MutableObject toPick;
                ArrayList<Ingredient> required;
                boolean fine;
                if (!recipe.saplingType.apply(saplingStack) || !(fine = Multiblocks.TREE_RITUAL.forEach(pos, 'W', (arg_0, arg_1) -> BlockWoodStand.lambda$onTreeGrow$0(world, required = new ArrayList<Ingredient>(Arrays.asList(recipe.ingredients)), toPick = new MutableObject(), arg_0, arg_1))) || !required.isEmpty()) continue;
                ((TileEntityWoodStand)((Object)toPick.getValue())).setRitual(pos, recipe);
                break;
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return Helper.putStackOnTile(playerIn, hand, pos, 0, true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUND_BOX;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Tuple<Class, TileEntitySpecialRenderer> getTESR() {
        return new Tuple(TileEntityWoodStand.class, (Object)new RenderWoodStand());
    }

    private static /* synthetic */ Boolean lambda$onTreeGrow$0(World world, List required, MutableObject toPick, BlockPos tilePos, Matcher matcher) {
        TileEntity tile = world.func_175625_s(tilePos);
        if (tile instanceof TileEntityWoodStand) {
            TileEntityWoodStand stand = (TileEntityWoodStand)tile;
            ItemStack stack = stand.items.getStackInSlot(0);
            if (!stack.func_190926_b()) {
                for (int i = required.size() - 1; i >= 0; --i) {
                    Ingredient req = (Ingredient)required.get(i);
                    if (!req.apply(stack)) continue;
                    required.remove(i);
                    if (toPick.getValue() == null) {
                        toPick.setValue((Object)stand);
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }
}

