/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class AuraChunkProvider
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    private final Chunk chunk;
    private IAuraChunk auraChunk;

    public AuraChunkProvider(Chunk chunk) {
        this.chunk = chunk;
    }

    private IAuraChunk getAuraChunk() {
        if (this.auraChunk == null) {
            this.auraChunk = new AuraChunk(this.chunk, IAuraType.forWorld(this.chunk.func_177412_p()));
        }
        return this.auraChunk;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == NaturesAuraAPI.capAuraChunk;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == NaturesAuraAPI.capAuraChunk ? this.getAuraChunk() : null);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)this.getAuraChunk().serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.getAuraChunk().deserializeNBT((NBTBase)nbt);
    }
}

