/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.crafttweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseMapAddition;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.TreeRitualRecipe;
import de.ellpeck.naturesaura.compat.crafttweaker.CraftTweakerCompat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.naturesaura.TreeRitual")
public final class TreeRitualTweaker {
    @ZenMethod
    public static void addRecipe(String name, IIngredient saplingType, IItemStack result, int time, IIngredient[] items) {
        CraftTweakerCompat.SCHEDULED_ACTIONS.add(() -> {
            ResourceLocation res = new ResourceLocation("crafttweaker", name);
            return new Add(Collections.singletonMap(res, new TreeRitualRecipe(res, CraftTweakerMC.getIngredient((IIngredient)saplingType), InputHelper.toStack((IItemStack)result), time, (Ingredient[])Arrays.stream(items).map(CraftTweakerMC::getIngredient).toArray(Ingredient[]::new))));
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerCompat.SCHEDULED_ACTIONS.add(() -> {
            HashMap<ResourceLocation, TreeRitualRecipe> recipes = new HashMap<ResourceLocation, TreeRitualRecipe>();
            for (TreeRitualRecipe recipe : NaturesAuraAPI.TREE_RITUAL_RECIPES.values()) {
                if (!Helper.areItemsEqual(recipe.result, InputHelper.toStack((IItemStack)output), true)) continue;
                recipes.put(recipe.name, recipe);
            }
            return new Remove(recipes);
        });
    }

    private static class Remove
    extends BaseMapRemoval<ResourceLocation, TreeRitualRecipe> {
        protected Remove(Map<ResourceLocation, TreeRitualRecipe> map) {
            super("Tree Ritual", NaturesAuraAPI.TREE_RITUAL_RECIPES, map);
        }

        protected String getRecipeInfo(Map.Entry<ResourceLocation, TreeRitualRecipe> recipe) {
            return LogHelper.getStackDescription((Object)recipe.getValue().result);
        }
    }

    private static class Add
    extends BaseMapAddition<ResourceLocation, TreeRitualRecipe> {
        protected Add(Map<ResourceLocation, TreeRitualRecipe> map) {
            super("Tree Ritual", NaturesAuraAPI.TREE_RITUAL_RECIPES, map);
        }

        protected String getRecipeInfo(Map.Entry<ResourceLocation, TreeRitualRecipe> recipe) {
            return LogHelper.getStackDescription((Object)recipe.getValue().result);
        }
    }
}

