/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities;

import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.misc.WorldData;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEffectInhibitor
extends Entity
implements IVisualizable {
    private static final DataParameter<String> INHIBITED_EFFECT = EntityDataManager.func_187226_a(EntityEffectInhibitor.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityEffectInhibitor.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> AMOUNT = EntityDataManager.func_187226_a(EntityEffectInhibitor.class, (DataSerializer)DataSerializers.field_187192_b);
    @SideOnly(value=Side.CLIENT)
    public int renderTicks;

    public EntityEffectInhibitor(World worldIn) {
        super(worldIn);
    }

    public static void place(World world, ItemStack stack, double posX, double posY, double posZ) {
        ResourceLocation effect = ItemEffectPowder.getEffect(stack);
        EntityEffectInhibitor entity = new EntityEffectInhibitor(world);
        entity.setInhibitedEffect(effect);
        entity.setColor(NaturesAuraAPI.EFFECT_POWDERS.get(effect));
        entity.setAmount(stack.func_190916_E());
        entity.func_70107_b(posX, posY, posZ);
        world.func_72838_d((Entity)entity);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.addToPowderList();
    }

    public void onRemovedFromWorld() {
        this.removeFromPowderList();
        super.onRemovedFromWorld();
    }

    public void func_70107_b(double x, double y, double z) {
        boolean should;
        boolean bl = should = x != this.field_70165_t || y != this.field_70163_u || z != this.field_70161_v;
        if (should) {
            this.removeFromPowderList();
        }
        super.func_70107_b(x, y, z);
        if (should) {
            this.addToPowderList();
        }
    }

    private void addToPowderList() {
        if (!this.isAddedToWorld()) {
            return;
        }
        List<Tuple<Vec3d, Integer>> powders = this.getPowderList();
        powders.add((Tuple<Vec3d, Integer>)new Tuple((Object)this.func_174791_d(), (Object)this.getAmount()));
    }

    private void removeFromPowderList() {
        if (!this.isAddedToWorld()) {
            return;
        }
        List<Tuple<Vec3d, Integer>> powders = this.getPowderList();
        Vec3d pos = this.func_174791_d();
        for (int i = 0; i < powders.size(); ++i) {
            if (!pos.equals(powders.get(i).func_76341_a())) continue;
            powders.remove(i);
            break;
        }
    }

    private List<Tuple<Vec3d, Integer>> getPowderList() {
        ListMultimap<ResourceLocation, Tuple<Vec3d, Integer>> powders = ((WorldData)IWorldData.getWorldData((World)this.field_70170_p)).effectPowders;
        return powders.get((Object)this.getInhibitedEffect());
    }

    protected void func_70088_a() {
        this.func_70105_a(0.25f, 0.25f);
        this.field_70180_af.func_187214_a(INHIBITED_EFFECT, null);
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(AMOUNT, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setInhibitedEffect(new ResourceLocation(compound.func_74779_i("effect")));
        this.setColor(compound.func_74762_e("color"));
        this.setAmount(compound.func_74764_b("amount") ? compound.func_74762_e("amount") : 24);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("effect", this.getInhibitedEffect().toString());
        compound.func_74768_a("color", this.getColor());
        compound.func_74768_a("amount", this.getAmount());
    }

    public void func_70030_z() {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82737_E() % 5L == 0L) {
                NaturesAura.proxy.spawnMagicParticle(this.field_70165_t + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70163_u, this.field_70161_v + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.005f, this.field_70170_p.field_73012_v.nextFloat() * 0.03f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.005f, this.getColor(), this.field_70170_p.field_73012_v.nextFloat() * 3.0f + 1.0f, 120, 0.0f, true, true);
            }
            ++this.renderTicks;
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70099_a(this.getDrop(), 0.0f);
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    public ItemStack getDrop() {
        return ItemEffectPowder.setEffect(new ItemStack(ModItems.EFFECT_POWDER, this.getAmount()), this.getInhibitedEffect());
    }

    public void setInhibitedEffect(ResourceLocation effect) {
        this.removeFromPowderList();
        this.field_70180_af.func_187227_b(INHIBITED_EFFECT, (Object)effect.toString());
        this.addToPowderList();
    }

    public ResourceLocation getInhibitedEffect() {
        return new ResourceLocation((String)this.field_70180_af.func_187225_a(INHIBITED_EFFECT));
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setAmount(int amount) {
        this.removeFromPowderList();
        this.field_70180_af.func_187227_b(AMOUNT, (Object)amount);
        this.addToPowderList();
    }

    public int getAmount() {
        return (Integer)this.field_70180_af.func_187225_a(AMOUNT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        return Helper.aabb(this.func_174791_d()).func_186662_g((double)this.getAmount());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return this.getColor();
    }
}

