/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityGratedChute;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityNatureAltar;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityRFConverter;
import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.items.ItemAuraCache;
import de.ellpeck.naturesaura.items.ItemRangeVisualizer;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.particles.ParticleHandler;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableInt;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientEvents {
    public static final ResourceLocation OVERLAYS = new ResourceLocation("naturesaura", "textures/gui/overlays.png");
    public static final ResourceLocation BOOK_GUI = new ResourceLocation("naturesaura", "textures/gui/book.png");
    private static final ItemStack ITEM_FRAME = new ItemStack(Items.field_151160_bD);
    private static final Map<ResourceLocation, Tuple<ItemStack, Boolean>> SHOWING_EFFECTS = new HashMap<ResourceLocation, Tuple<ItemStack, Boolean>>();
    private static ItemStack heldCache = ItemStack.field_190927_a;
    private static ItemStack heldEye = ItemStack.field_190927_a;
    private static ItemStack heldOcular = ItemStack.field_190927_a;

    @SubscribeEvent
    public void onDebugRender(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_194340_a(() -> "naturesaura:onDebugRender");
        if (mc.field_71474_y.field_74330_P && ModConfig.client.debugText) {
            String prefix = TextFormatting.GREEN + "[" + "Nature's Aura" + "]" + TextFormatting.RESET + " ";
            ArrayList left = event.getLeft();
            left.add("");
            int depth = ParticleHandler.getParticleAmount(true);
            int noDepth = ParticleHandler.getParticleAmount(false);
            left.add(prefix + "P: " + (depth + noDepth) + " (D: " + depth + " nD: " + noDepth + ")");
            if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                MutableInt amount = new MutableInt(1000000);
                MutableInt spots = new MutableInt();
                IAuraChunk.getSpotsInArea((World)mc.field_71441_e, mc.field_71439_g.func_180425_c(), 35, (blockPos, drainSpot) -> {
                    spots.increment();
                    amount.add((Number)drainSpot);
                });
                NumberFormat format = NumberFormat.getInstance();
                left.add(prefix + "A: " + format.format(amount.intValue()) + " (S: " + spots.intValue() + ")");
                left.add(prefix + "AT: " + IAuraType.forWorld((World)mc.field_71441_e).getName());
            }
        }
        mc.field_71424_I.func_76319_b();
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_194340_a(() -> "naturesaura:renderParticles");
        ParticleHandler.renderParticles(event.getPartialTicks());
        mc.field_71424_I.func_76319_b();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            heldCache = ItemStack.field_190927_a;
            heldEye = ItemStack.field_190927_a;
            heldOcular = ItemStack.field_190927_a;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e == null) {
                ParticleHandler.clearParticles();
                ItemRangeVisualizer.clear();
            } else if (!mc.func_147113_T()) {
                int i;
                if (mc.field_71441_e.func_82737_E() % 20L == 0L) {
                    mc.field_71424_I.func_194340_a(() -> "naturesaura:spawnExcessParticles");
                    int amount = MathHelper.func_76128_c((double)(190.0 * ModConfig.client.excessParticleAmount));
                    for (i = 0; i < amount; ++i) {
                        int chance;
                        int excess;
                        int z;
                        int x = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t) + mc.field_71441_e.field_73012_v.nextInt(64) - 32;
                        BlockPos pos = new BlockPos(x, mc.field_71441_e.func_189649_b(x, z = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v) + mc.field_71441_e.field_73012_v.nextInt(64) - 32) - 1, z);
                        IBlockState state = mc.field_71441_e.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (!(block instanceof IGrowable) && !(block instanceof IPlantable) && !block.isLeaves(state, (IBlockAccess)mc.field_71441_e, pos) || (excess = IAuraChunk.triangulateAuraInArea((World)mc.field_71441_e, pos, 45) - 1000000) <= 0 || mc.field_71441_e.field_73012_v.nextInt(chance = Math.max(10, 50 - excess / 25000)) > 0) continue;
                        NaturesAuraAPI.instance().spawnMagicParticle((float)pos.func_177958_n() + mc.field_71441_e.field_73012_v.nextFloat(), (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + mc.field_71441_e.field_73012_v.nextFloat(), mc.field_71441_e.field_73012_v.nextGaussian() * (double)0.01f, mc.field_71441_e.field_73012_v.nextFloat() * 0.025f, mc.field_71441_e.field_73012_v.nextGaussian() * (double)0.01f, BiomeColorHelper.func_180287_b((IBlockAccess)mc.field_71441_e, (BlockPos)pos), Math.min(2.0f, 1.0f + mc.field_71441_e.field_73012_v.nextFloat() * ((float)excess / 30000.0f)), Math.min(300, 100 + mc.field_71441_e.field_73012_v.nextInt(excess / 3000 + 1)), 0.0f, false, true);
                    }
                    mc.field_71424_I.func_76319_b();
                }
                if (Helper.isHoldingItem((EntityPlayer)mc.field_71439_g, ModItems.RANGE_VISUALIZER) && mc.field_71441_e.func_82737_E() % 5L == 0L) {
                    NaturesAuraAPI.IInternalHooks inst = NaturesAuraAPI.instance();
                    inst.setParticleSpawnRange(512);
                    inst.setParticleDepth(false);
                    for (BlockPos pos : ItemRangeVisualizer.VISUALIZED_RAILS.get((Object)mc.field_71441_e.field_73011_w.getDimension())) {
                        NaturesAuraAPI.instance().spawnMagicParticle((float)pos.func_177958_n() + mc.field_71441_e.field_73012_v.nextFloat(), (float)pos.func_177956_o() + mc.field_71441_e.field_73012_v.nextFloat(), (float)pos.func_177952_p() + mc.field_71441_e.field_73012_v.nextFloat(), 0.0, 0.0, 0.0, 14744319, mc.field_71441_e.field_73012_v.nextFloat() * 5.0f + 1.0f, 100, 0.0f, false, true);
                    }
                    inst.setParticleDepth(true);
                    inst.setParticleSpawnRange(32);
                }
                mc.field_71424_I.func_194340_a(() -> "naturesaura:updateParticles");
                ParticleHandler.updateParticles();
                mc.field_71424_I.func_76319_b();
                if (Compat.baubles) {
                    IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)mc.field_71439_g);
                    for (i = 0; i < baubles.getSlots(); ++i) {
                        ItemStack slot = baubles.getStackInSlot(i);
                        if (slot.func_190926_b()) continue;
                        if (slot.func_77973_b() instanceof ItemAuraCache) {
                            heldCache = slot;
                            continue;
                        }
                        if (slot.func_77973_b() == ModItems.EYE) {
                            heldEye = slot;
                            continue;
                        }
                        if (slot.func_77973_b() != ModItems.EYE_IMPROVED) continue;
                        heldOcular = slot;
                    }
                }
                for (int i2 = 0; i2 < mc.field_71439_g.field_71071_by.func_70302_i_(); ++i2) {
                    ItemStack slot = mc.field_71439_g.field_71071_by.func_70301_a(i2);
                    if (slot.func_190926_b()) continue;
                    if (slot.func_77973_b() instanceof ItemAuraCache) {
                        heldCache = slot;
                        continue;
                    }
                    if (slot.func_77973_b() == ModItems.EYE && i2 <= 8) {
                        heldEye = slot;
                        continue;
                    }
                    if (slot.func_77973_b() != ModItems.EYE_IMPROVED) continue;
                    heldOcular = slot;
                }
                if (!heldOcular.func_190926_b() && mc.field_71441_e.func_82737_E() % 20L == 0L) {
                    SHOWING_EFFECTS.clear();
                    Helper.getAuraChunksInArea((World)mc.field_71441_e, mc.field_71439_g.func_180425_c(), 100, chunk -> chunk.getActiveEffectIcons((EntityPlayer)mc.field_71439_g, SHOWING_EFFECTS));
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_194340_a(() -> "naturesaura:onWorldRender");
        GL11.glPushMatrix();
        float partial = event.getPartialTicks();
        GL11.glTranslated((double)(-mc.field_71439_g.field_70169_q - (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70169_q) * (double)partial), (double)(-mc.field_71439_g.field_70167_r - (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70167_r) * (double)partial), (double)(-mc.field_71439_g.field_70166_s - (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70166_s) * (double)partial));
        if (mc.field_71474_y.field_74330_P && mc.field_71439_g.field_71075_bZ.field_75098_d && ModConfig.client.debugWorld) {
            HashMap spots = new HashMap();
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBegin((int)7);
            IAuraChunk.getSpotsInArea((World)mc.field_71441_e, mc.field_71439_g.func_180425_c(), 64, (pos, spot) -> {
                spots.put(pos, spot);
                GlStateManager.func_179131_c((float)(spot > 0 ? 0.0f : 1.0f), (float)(spot > 0 ? 1.0f : 0.0f), (float)0.0f, (float)0.35f);
                Helper.renderWeirdBox(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1.0, 1.0, 1.0);
            });
            GL11.glEnd();
            GL11.glPopAttrib();
            float scale = 0.03f;
            NumberFormat format = NumberFormat.getInstance();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            for (Map.Entry spot2 : spots.entrySet()) {
                BlockPos pos2 = (BlockPos)spot2.getKey();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(((double)pos2.func_177958_n() + 0.1) / (double)scale), (double)((float)(pos2.func_177956_o() + 1) / scale), (double)(((double)pos2.func_177952_p() + 0.1) / (double)scale));
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.65f, (float)0.65f, (float)0.65f);
                mc.field_71466_p.func_78276_b(format.format(spot2.getValue()), 0, 0, 0);
                GlStateManager.func_179121_F();
            }
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
        if (Helper.isHoldingItem((EntityPlayer)mc.field_71439_g, ModItems.RANGE_VISUALIZER)) {
            int dim = mc.field_71441_e.field_73011_w.getDimension();
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBegin((int)7);
            for (BlockPos pos3 : ItemRangeVisualizer.VISUALIZED_BLOCKS.get((Object)dim)) {
                IBlockState state;
                Block block;
                if (!mc.field_71441_e.func_175667_e(pos3) || !((block = (state = mc.field_71441_e.func_180495_p(pos3)).func_177230_c()) instanceof IVisualizable)) continue;
                this.renderVisualize((IVisualizable)block, (World)mc.field_71441_e, pos3);
            }
            for (Entity entity : ItemRangeVisualizer.VISUALIZED_ENTITIES.get((Object)dim)) {
                if (entity.field_70128_L || !(entity instanceof IVisualizable)) continue;
                this.renderVisualize((IVisualizable)entity, (World)mc.field_71441_e, entity.func_180425_c());
            }
            GL11.glEnd();
            GL11.glPopAttrib();
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        mc.field_71424_I.func_76319_b();
    }

    private void renderVisualize(IVisualizable visualize, World world, BlockPos pos) {
        AxisAlignedBB box = visualize.getVisualizationBounds(world, pos);
        if (box == null) {
            return;
        }
        box = box.func_186662_g((double)0.05f);
        int color = visualize.getVisualizationColor(world, pos);
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)0.5f);
        Helper.renderWeirdBox(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d - box.field_72340_a, box.field_72337_e - box.field_72338_b, box.field_72334_f - box.field_72339_c);
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_194340_a(() -> "naturesaura:onOverlayRender");
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ScaledResolution res = event.getResolution();
            if (mc.field_71439_g != null) {
                if (!heldCache.func_190926_b()) {
                    IAuraContainer container = (IAuraContainer)heldCache.getCapability(NaturesAuraAPI.capAuraContainer, null);
                    int width = MathHelper.func_76123_f((float)((float)container.getStoredAura() / (float)container.getMaxAura() * 80.0f));
                    int x = res.func_78326_a() / 2 - 173 - (mc.field_71439_g.func_184592_cb().func_190926_b() ? 0 : 29);
                    int y = res.func_78328_b() - 8;
                    GlStateManager.func_179094_E();
                    int color = container.getAuraColor();
                    GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
                    mc.func_110434_K().func_110577_a(OVERLAYS);
                    if (width < 80) {
                        Gui.func_146110_a((int)(x + width), (int)y, (float)width, (float)0.0f, (int)(80 - width), (int)6, (float)256.0f, (float)256.0f);
                    }
                    if (width > 0) {
                        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)6.0f, (int)width, (int)6, (float)256.0f, (float)256.0f);
                    }
                    float scale = 0.75f;
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    String s = heldCache.func_82833_r();
                    mc.field_71466_p.func_175065_a(s, (float)(x + 80) / scale - (float)mc.field_71466_p.func_78256_a(s), (float)(y - 7) / scale, color, true);
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                }
                if (!heldEye.func_190926_b() || !heldOcular.func_190926_b()) {
                    BlockPos pos;
                    GlStateManager.func_179094_E();
                    mc.func_110434_K().func_110577_a(OVERLAYS);
                    int conf = ModConfig.client.auraBarLocation;
                    if (!(mc.field_71474_y.field_74330_P || conf == 2 && mc.field_71462_r instanceof GuiChat)) {
                        int y;
                        int startX;
                        GlStateManager.func_179124_c((float)0.3254902f, (float)0.627451f, (float)0.03137255f);
                        int totalAmount = IAuraChunk.triangulateAuraInArea((World)mc.field_71441_e, mc.field_71439_g.func_180425_c(), 35);
                        float totalPercentage = (float)totalAmount / 2000000.0f;
                        String text = I18n.func_135052_a((String)"info.naturesaura.aura_in_area", (Object[])new Object[0]);
                        float textScale = 0.75f;
                        int n = startX = conf % 2 == 0 ? 3 : res.func_78326_a() - 3 - 6;
                        int startY = conf < 2 ? 10 : (!heldOcular.func_190926_b() && (totalPercentage > 1.0f || totalPercentage < 0.0f) ? -26 : 0) + res.func_78328_b() - 60;
                        float plusOffX = conf % 2 == 0 ? 7.0f : -7.0f;
                        float textX = conf % 2 == 0 ? 3.0f : (float)(res.func_78326_a() - 3) - (float)mc.field_71466_p.func_78256_a(text) * textScale;
                        float textY = conf < 2 ? 3.0f : (float)(res.func_78328_b() - 3 - 6);
                        int tHeight = MathHelper.func_76123_f((float)(MathHelper.func_76131_a((float)totalPercentage, (float)0.0f, (float)1.0f) * 50.0f));
                        int n2 = y = !heldOcular.func_190926_b() && totalPercentage > 1.0f ? startY + 26 : startY;
                        if (tHeight < 50) {
                            Gui.func_146110_a((int)startX, (int)y, (float)6.0f, (float)12.0f, (int)6, (int)(50 - tHeight), (float)256.0f, (float)256.0f);
                        }
                        if (tHeight > 0) {
                            Gui.func_146110_a((int)startX, (int)(y + 50 - tHeight), (float)0.0f, (float)(62 - tHeight), (int)6, (int)tHeight, (float)256.0f, (float)256.0f);
                        }
                        if (!heldOcular.func_190926_b()) {
                            int bottomHeight;
                            GlStateManager.func_179124_c((float)0.627451f, (float)0.3254902f, (float)0.03137255f);
                            int topHeight = MathHelper.func_76123_f((float)(MathHelper.func_76131_a((float)((totalPercentage - 1.0f) * 2.0f), (float)0.0f, (float)1.0f) * 25.0f));
                            if (topHeight > 0) {
                                if (topHeight < 25) {
                                    Gui.func_146110_a((int)startX, (int)startY, (float)18.0f, (float)12.0f, (int)6, (int)(25 - topHeight), (float)256.0f, (float)256.0f);
                                }
                                Gui.func_146110_a((int)startX, (int)(startY + 25 - topHeight), (float)12.0f, (float)(37 - topHeight), (int)6, (int)topHeight, (float)256.0f, (float)256.0f);
                            }
                            if ((bottomHeight = MathHelper.func_76141_d((float)(MathHelper.func_76131_a((float)((totalPercentage + 1.0f) * 2.0f - 1.0f), (float)0.0f, (float)1.0f) * 25.0f))) < 25) {
                                Gui.func_146110_a((int)startX, (int)(startY + 51), (float)18.0f, (float)12.0f, (int)6, (int)(25 - bottomHeight), (float)256.0f, (float)256.0f);
                                if (bottomHeight > 0) {
                                    Gui.func_146110_a((int)startX, (int)(startY + 51 + 25 - bottomHeight), (float)12.0f, (float)(37 - bottomHeight), (int)6, (int)bottomHeight, (float)256.0f, (float)256.0f);
                                }
                            }
                        }
                        int color = heldOcular.func_190926_b() ? 5480456 : 10507016;
                        float f = heldOcular.func_190926_b() ? 1.0f : 1.5f;
                        if (totalPercentage > f) {
                            mc.field_71466_p.func_175065_a("+", (float)startX + plusOffX, (float)startY - 0.5f, color, true);
                        }
                        float f2 = heldOcular.func_190926_b() ? 0.0f : -0.5f;
                        if (totalPercentage < f2) {
                            mc.field_71466_p.func_175065_a("-", (float)startX + plusOffX, (float)startY - 0.5f + (float)(heldOcular.func_190926_b() ? 44 : 70), color, true);
                        }
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
                        mc.field_71466_p.func_175065_a(text, textX / textScale, textY / textScale, 5480456, true);
                        GlStateManager.func_179121_F();
                        if (!heldOcular.func_190926_b()) {
                            float scale = 0.75f;
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                            int stackX = conf % 2 == 0 ? 10 : res.func_78326_a() - 22;
                            int stackY = conf < 2 ? 15 : res.func_78328_b() - 55;
                            for (Tuple<ItemStack, Boolean> effect : SHOWING_EFFECTS.values()) {
                                int theX = (int)((float)stackX / scale);
                                int theY = (int)((float)stackY / scale);
                                ItemStack stack = (ItemStack)effect.func_76341_a();
                                Helper.renderItemInGui(stack, theX, theY, 1.0f);
                                if (((Boolean)effect.func_76340_b()).booleanValue()) {
                                    GlStateManager.func_179097_i();
                                    mc.func_110434_K().func_110577_a(OVERLAYS);
                                    Gui.func_146110_a((int)theX, (int)theY, (float)240.0f, (float)0.0f, (int)16, (int)16, (float)256.0f, (float)256.0f);
                                    GlStateManager.func_179126_j();
                                }
                                stackY += 8;
                            }
                            GlStateManager.func_179121_F();
                        }
                    }
                    if (mc.field_71476_x != null && (pos = mc.field_71476_x.func_178782_a()) != null) {
                        TileEntity tile = mc.field_71441_e.func_175625_s(pos);
                        if (tile != null && tile.hasCapability(NaturesAuraAPI.capAuraContainer, null)) {
                            ItemStack tileStack;
                            IAuraContainer container = (IAuraContainer)tile.getCapability(NaturesAuraAPI.capAuraContainer, null);
                            IBlockState state = mc.field_71441_e.func_180495_p(pos);
                            ItemStack blockStack = state.func_177230_c().getPickBlock(state, mc.field_71476_x, (World)mc.field_71441_e, pos, (EntityPlayer)mc.field_71439_g);
                            this.drawContainerInfo(container.getStoredAura(), container.getMaxAura(), container.getAuraColor(), mc, res, 35, blockStack.func_82833_r(), null);
                            if (tile instanceof TileEntityNatureAltar && !(tileStack = ((TileEntityNatureAltar)tile).getItemHandler(null).getStackInSlot(0)).func_190926_b() && tileStack.hasCapability(NaturesAuraAPI.capAuraContainer, null)) {
                                IAuraContainer stackCont = (IAuraContainer)tileStack.getCapability(NaturesAuraAPI.capAuraContainer, null);
                                this.drawContainerInfo(stackCont.getStoredAura(), stackCont.getMaxAura(), stackCont.getAuraColor(), mc, res, 55, tileStack.func_82833_r(), null);
                            }
                        } else if (tile instanceof TileEntityRFConverter) {
                            TileEntityRFConverter.RFStorage storage = ((TileEntityRFConverter)tile).storage;
                            this.drawContainerInfo(storage.getEnergyStored(), storage.getMaxEnergyStored(), 13388054, mc, res, 35, I18n.func_135052_a((String)"tile.naturesaura.rf_converter.name", (Object[])new Object[0]), storage.getEnergyStored() + " / " + storage.getMaxEnergyStored() + " RF");
                        } else if (tile instanceof TileEntityGratedChute) {
                            TileEntityGratedChute chute = (TileEntityGratedChute)tile;
                            ItemStack stack = chute.getItemHandler(null).getStackInSlot(0);
                            int x = res.func_78326_a() / 2;
                            int y = res.func_78328_b() / 2;
                            if (stack.func_190926_b()) {
                                mc.field_71466_p.func_175065_a(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"info.naturesaura.empty", (Object[])new Object[0]), (float)(x + 5), (float)(y - 11), 0xFFFFFF, true);
                            } else {
                                Helper.renderItemInGui(stack, x + 2, y - 18, 1.0f);
                            }
                            Helper.renderItemInGui(ITEM_FRAME, x - 24, y - 24, 1.0f);
                            mc.func_110434_K().func_110577_a(OVERLAYS);
                            int u = chute.isBlacklist ? 240 : 224;
                            GlStateManager.func_179097_i();
                            Gui.func_146110_a((int)(x - 18), (int)(y - 18), (float)u, (float)0.0f, (int)16, (int)16, (float)256.0f, (float)256.0f);
                            GlStateManager.func_179126_j();
                        }
                    }
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                }
            }
        }
        mc.field_71424_I.func_76319_b();
    }

    private void drawContainerInfo(int stored, int max, int color, Minecraft mc, ScaledResolution res, int yOffset, String name, String textBelow) {
        GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        int x = res.func_78326_a() / 2 - 40;
        int y = res.func_78328_b() / 2 + yOffset;
        int width = MathHelper.func_76123_f((float)((float)stored / (float)max * 80.0f));
        mc.func_110434_K().func_110577_a(OVERLAYS);
        if (width < 80) {
            Gui.func_146110_a((int)(x + width), (int)y, (float)width, (float)0.0f, (int)(80 - width), (int)6, (float)256.0f, (float)256.0f);
        }
        if (width > 0) {
            Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)6.0f, (int)width, (int)6, (float)256.0f, (float)256.0f);
        }
        mc.field_71466_p.func_175065_a(name, (float)(x + 40) - (float)mc.field_71466_p.func_78256_a(name) / 2.0f, (float)(y - 9), color, true);
        if (textBelow != null) {
            mc.field_71466_p.func_175065_a(textBelow, (float)(x + 40) - (float)mc.field_71466_p.func_78256_a(textBelow) / 2.0f, (float)(y + 7), color, true);
        }
    }
}

