/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.neat.NeatConfig;
import vazkii.neat.NeatRenderType;

public class HealthBarRenderer {
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Entity cameraEntity;
        Minecraft mc = Minecraft.func_71410_x();
        if (!NeatConfig.renderInF1 && !Minecraft.func_71382_s() || !NeatConfig.draw) {
            return;
        }
        ActiveRenderInfo renderInfo = mc.field_71460_t.func_215316_n();
        MatrixStack matrixStack = event.getMatrixStack();
        float partialTicks = event.getPartialTicks();
        Object object = cameraEntity = renderInfo.func_216773_g() != null ? renderInfo.func_216773_g() : mc.field_71439_g;
        if (NeatConfig.showOnlyFocused) {
            Entity focused = HealthBarRenderer.getEntityLookedAt((Entity)mc.field_71439_g);
            if (focused != null && focused instanceof LivingEntity && focused.func_70089_S()) {
                this.renderHealthBar((LivingEntity)focused, mc, matrixStack, partialTicks, renderInfo, cameraEntity);
            }
        } else {
            Vector3d cameraPos = renderInfo.func_216785_c();
            ClippingHelper clippingHelper = new ClippingHelper(matrixStack.func_227866_c_().func_227870_a_(), event.getProjectionMatrix());
            clippingHelper.func_228952_a_(cameraPos.func_82615_a(), cameraPos.func_82617_b(), cameraPos.func_82616_c());
            ClientWorld client = mc.field_71441_e;
            if (client != null) {
                for (Entity entity : client.func_217416_b()) {
                    if (entity == null || !(entity instanceof LivingEntity) || entity == cameraEntity || !entity.func_70089_S() || !entity.func_184182_bu().isEmpty() || !entity.func_145770_h(cameraPos.func_82615_a(), cameraPos.func_82617_b(), cameraPos.func_82616_c()) || !entity.field_70158_ak && !clippingHelper.func_228957_a_(entity.func_174813_aQ())) continue;
                    this.renderHealthBar((LivingEntity)entity, mc, matrixStack, partialTicks, renderInfo, cameraEntity);
                }
            }
        }
    }

    public void renderHealthBar(LivingEntity passedEntity, Minecraft mc, MatrixStack matrixStack, float partialTicks, ActiveRenderInfo renderInfo, Entity viewPoint) {
        Stack<LivingEntity> ridingStack = new Stack<LivingEntity>();
        LivingEntity entity = passedEntity;
        ridingStack.push(entity);
        while (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof LivingEntity) {
            entity = (LivingEntity)entity.func_184187_bx();
            ridingStack.push(entity);
        }
        matrixStack.func_227860_a_();
        while (!ridingStack.isEmpty()) {
            float distance;
            boolean boss;
            entity = (LivingEntity)ridingStack.pop();
            boolean bl = boss = !entity.func_184222_aU();
            String entityID = entity.func_70022_Q();
            if (NeatConfig.blacklist.contains(entityID) || (distance = passedEntity.func_70032_d(viewPoint)) > (float)NeatConfig.maxDistance || !passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj() || !NeatConfig.showOnBosses && !boss || !NeatConfig.showOnPlayers && entity instanceof PlayerEntity || entity.func_110138_aP() <= 0.0f || !NeatConfig.showFullHealth && entity.func_110143_aJ() == entity.func_110138_aP()) continue;
            double x = passedEntity.field_70169_q + (passedEntity.func_226277_ct_() - passedEntity.field_70169_q) * (double)partialTicks;
            double y = passedEntity.field_70167_r + (passedEntity.func_226278_cu_() - passedEntity.field_70167_r) * (double)partialTicks;
            double z = passedEntity.field_70166_s + (passedEntity.func_226281_cx_() - passedEntity.field_70166_s) * (double)partialTicks;
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            Vector3d renderPos = renderManager.field_217783_c.func_216785_c();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)(x - renderPos.func_82615_a())), (double)((float)(y - renderPos.func_82617_b() + (double)passedEntity.func_213302_cg() + NeatConfig.heightAbove)), (double)((float)(z - renderPos.func_82616_c())));
            IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
            ItemStack icon = HealthBarRenderer.getIcon(entity, boss);
            int light = 0xF000F0;
            this.renderEntity(mc, matrixStack, buffer, renderInfo, entity, 0xF000F0, icon, boss);
            matrixStack.func_227865_b_();
            matrixStack.func_227861_a_(0.0, (double)(-(NeatConfig.backgroundHeight + NeatConfig.barHeight + NeatConfig.backgroundPadding)), 0.0);
        }
        matrixStack.func_227865_b_();
    }

    private void renderEntity(Minecraft mc, MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer, ActiveRenderInfo renderInfo, LivingEntity entity, int light, ItemStack icon, boolean boss) {
        int armor;
        float namel;
        Quaternion rotation = renderInfo.func_227995_f_().func_227068_g_();
        rotation.func_227065_a_(-1.0f);
        matrixStack.func_227863_a_(rotation);
        float scale = 0.026666673f;
        matrixStack.func_227862_a_(-scale, -scale, scale);
        float health = MathHelper.func_76131_a((float)entity.func_110143_aJ(), (float)0.0f, (float)entity.func_110138_aP());
        float percent = health / entity.func_110138_aP() * 100.0f;
        float size = NeatConfig.plateSize;
        float textScale = 0.5f;
        String name = (entity.func_145818_k_() ? entity.func_200201_e() : entity.func_145748_c_()).getString();
        if (entity.func_145818_k_()) {
            name = TextFormatting.ITALIC + name;
        }
        if ((namel = (float)mc.field_71466_p.func_78256_a(name) * textScale) + 20.0f > size * 2.0f) {
            size = namel / 2.0f + 10.0f;
        }
        float healthSize = size * (health / entity.func_110138_aP());
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        Matrix4f modelViewMatrix = entry.func_227870_a_();
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        normal.func_229188_a_(entry.func_227872_b_());
        IVertexBuilder builder = buffer.getBuffer(NeatRenderType.getHealthBarType());
        float padding = NeatConfig.backgroundPadding;
        int bgHeight = NeatConfig.backgroundHeight;
        int barHeight = NeatConfig.barHeight;
        float z = 0.01f;
        if (NeatConfig.drawBackground) {
            builder.func_227888_a_(modelViewMatrix, -size - padding, (float)(-bgHeight), z).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 64).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
            builder.func_227888_a_(modelViewMatrix, -size - padding, (float)barHeight + padding, z).func_225583_a_(0.0f, 0.5f).func_225586_a_(0, 0, 0, 64).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
            builder.func_227888_a_(modelViewMatrix, size + padding, (float)barHeight + padding, z).func_225583_a_(1.0f, 0.5f).func_225586_a_(0, 0, 0, 64).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
            builder.func_227888_a_(modelViewMatrix, size + padding, (float)(-bgHeight), z).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 64).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
        }
        builder.func_227888_a_(modelViewMatrix, -size, 0.0f, z -= 0.001f).func_225583_a_(0.0f, 0.5f).func_225586_a_(0, 0, 0, 127).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
        builder.func_227888_a_(modelViewMatrix, -size, (float)barHeight, z).func_225583_a_(0.0f, 0.75f).func_225586_a_(0, 0, 0, 127).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
        builder.func_227888_a_(modelViewMatrix, size, (float)barHeight, z).func_225583_a_(1.0f, 0.75f).func_225586_a_(0, 0, 0, 127).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
        builder.func_227888_a_(modelViewMatrix, size, 0.0f, z).func_225583_a_(1.0f, 0.5f).func_225586_a_(0, 0, 0, 127).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
        int argb = HealthBarRenderer.getColor(entity, NeatConfig.colorByType, boss);
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        builder.func_227888_a_(modelViewMatrix, -size, 0.0f, z -= 0.001f).func_225583_a_(0.0f, 0.75f).func_225586_a_(r, g, b, 127).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
        builder.func_227888_a_(modelViewMatrix, -size, (float)barHeight, z).func_225583_a_(0.0f, 1.0f).func_225586_a_(r, g, b, 127).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
        builder.func_227888_a_(modelViewMatrix, healthSize * 2.0f - size, (float)barHeight, z).func_225583_a_(1.0f, 1.0f).func_225586_a_(r, g, b, 127).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
        builder.func_227888_a_(modelViewMatrix, healthSize * 2.0f - size, 0.0f, z).func_225583_a_(1.0f, 0.75f).func_225586_a_(r, g, b, 127).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
        int white = 0xFFFFFF;
        int black = 0;
        matrixStack.func_227861_a_((double)(-size), -4.5, 0.0);
        matrixStack.func_227862_a_(textScale, textScale, textScale);
        modelViewMatrix = matrixStack.func_227866_c_().func_227870_a_();
        mc.field_71466_p.func_228079_a_(name, 0.0f, 0.0f, white, false, modelViewMatrix, (IRenderTypeBuffer)buffer, false, black, light);
        float s1 = 0.75f;
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(s1, s1, s1);
        modelViewMatrix = matrixStack.func_227866_c_().func_227870_a_();
        int h = NeatConfig.hpTextHeight;
        String maxHpStr = TextFormatting.BOLD + "" + (double)Math.round((double)entity.func_110138_aP() * 100.0) / 100.0;
        String hpStr = "" + (double)Math.round((double)health * 100.0) / 100.0;
        String percStr = (int)percent + "%";
        if (maxHpStr.endsWith(".00")) {
            maxHpStr = maxHpStr.substring(0, maxHpStr.length() - 3);
        }
        if (hpStr.endsWith(".00")) {
            hpStr = hpStr.substring(0, hpStr.length() - 3);
        }
        if (NeatConfig.showCurrentHP) {
            mc.field_71466_p.func_228079_a_(hpStr, 2.0f, (float)h, white, false, modelViewMatrix, (IRenderTypeBuffer)buffer, false, black, light);
        }
        if (NeatConfig.showMaxHP) {
            mc.field_71466_p.func_228079_a_(maxHpStr, (float)((int)(size / (textScale * s1) * 2.0f) - 2 - mc.field_71466_p.func_78256_a(maxHpStr)), (float)h, white, false, modelViewMatrix, (IRenderTypeBuffer)buffer, false, black, light);
        }
        if (NeatConfig.showPercentage) {
            mc.field_71466_p.func_228079_a_(percStr, (float)((int)(size / (textScale * s1)) - mc.field_71466_p.func_78256_a(percStr) / 2), (float)h, white, false, modelViewMatrix, (IRenderTypeBuffer)buffer, false, black, light);
        }
        if (NeatConfig.enableDebugInfo && mc.field_71474_y.field_74330_P) {
            mc.field_71466_p.func_228079_a_("ID: \"" + Registry.field_212629_r.func_148757_b((Object)entity.func_200600_R()) + "\"", 0.0f, (float)(h + 16), white, false, modelViewMatrix, (IRenderTypeBuffer)buffer, false, black, light);
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        int off = 0;
        s1 = 0.5f;
        matrixStack.func_227862_a_(s1, s1, s1);
        matrixStack.func_227861_a_((double)(size / (textScale * s1) * 2.0f), 0.0, 0.0);
        mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        if (NeatConfig.showAttributes) {
            this.renderIcon(mc, off, 0, icon, matrixStack, (IRenderTypeBuffer)buffer, renderInfo);
            off -= 16;
        }
        if ((armor = entity.func_70658_aO()) > 0 && NeatConfig.showArmor) {
            int i;
            int ironArmor = armor % 5;
            int diamondArmor = armor / 5;
            if (!NeatConfig.groupArmor) {
                ironArmor = armor;
                diamondArmor = 0;
            }
            icon = new ItemStack((IItemProvider)Items.field_151030_Z);
            for (i = 0; i < ironArmor; ++i) {
                this.renderIcon(mc, off, 0, icon, matrixStack, (IRenderTypeBuffer)buffer, renderInfo);
                off -= 4;
            }
            icon = new ItemStack((IItemProvider)Items.field_151163_ad);
            for (i = 0; i < diamondArmor; ++i) {
                this.renderIcon(mc, off, 0, icon, matrixStack, (IRenderTypeBuffer)buffer, renderInfo);
                off -= 4;
            }
        }
        matrixStack.func_227865_b_();
    }

    private void renderIcon(Minecraft mc, int vertexX, int vertexY, @Nonnull ItemStack icon, MatrixStack matrixStack, IRenderTypeBuffer buffer, ActiveRenderInfo renderInfo) {
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
        matrixStack.func_227861_a_((double)(vertexY - 16), (double)(vertexX - 16), 0.0);
        matrixStack.func_227862_a_(16.0f, 16.0f, 1.0f);
        try {
            IVertexBuilder builder;
            ResourceLocation registryName = icon.func_77973_b().getRegistryName();
            Pair pair = Pair.of((Object)PlayerContainer.field_226615_c_, (Object)new ResourceLocation(registryName.func_110624_b(), "item/" + registryName.func_110623_a()));
            TextureAtlasSprite sprite = (TextureAtlasSprite)mc.func_228015_a_((ResourceLocation)pair.getFirst()).apply(pair.getSecond());
            Matrix4f modelViewMatrix = matrixStack.func_227866_c_().func_227870_a_();
            if (icon.func_190926_b()) {
                builder = buffer.getBuffer(NeatRenderType.getNoIconType());
                builder.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
                builder.func_225582_a_(0.0, 1.0, 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
                builder.func_225582_a_(1.0, 1.0, 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
                builder.func_225582_a_(1.0, 0.0, 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            } else {
                builder = buffer.getBuffer(NeatRenderType.getIconType((ResourceLocation)pair.getSecond()));
                builder.func_227888_a_(modelViewMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
                builder.func_227888_a_(modelViewMatrix, 0.0f, 1.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
                builder.func_227888_a_(modelViewMatrix, 1.0f, 1.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
                builder.func_227888_a_(modelViewMatrix, 1.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
            }
            builder = buffer.getBuffer(NeatRenderType.getNoIconType());
            builder.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            builder.func_225582_a_(0.0, 1.0, 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            builder.func_225582_a_(1.0, 1.0, 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            builder.func_225582_a_(1.0, 0.0, 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrixStack.func_227865_b_();
    }

    public static Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = 32.0;
        double distance = 32.0;
        RayTraceResult pos = HealthBarRenderer.raycast(e, 32.0);
        Vector3d positionVector = e.func_213303_ch();
        if (e instanceof PlayerEntity) {
            positionVector = positionVector.func_72441_c(0.0, (double)e.func_213307_e(e.func_213283_Z()), 0.0);
        }
        if (pos != null) {
            distance = pos.func_216347_e().func_72438_d(positionVector);
        }
        Vector3d lookVector = e.func_70040_Z();
        Vector3d reachVector = positionVector.func_72441_c(lookVector.field_72450_a * 32.0, lookVector.field_72448_b * 32.0, lookVector.field_72449_c * 32.0);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.func_130014_f_().func_72839_b(e, e.func_174813_aQ().func_72314_b(lookVector.field_72450_a * 32.0, lookVector.field_72448_b * 32.0, lookVector.field_72449_c * 32.0).func_72321_a(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            if (entity.func_70067_L()) {
                double distanceToEntity;
                AxisAlignedBB collisionBox = entity.func_184177_bl();
                Optional interceptPosition = collisionBox.func_216365_b(positionVector, reachVector);
                if (collisionBox.func_72318_a(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.func_72438_d((Vector3d)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    public static RayTraceResult raycast(Entity e, double len) {
        Vector3d look;
        Vector3d vec = new Vector3d(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
        if (e instanceof PlayerEntity) {
            vec = vec.func_178787_e(new Vector3d(0.0, (double)e.func_213307_e(e.func_213283_Z()), 0.0));
        }
        if ((look = e.func_70040_Z()) == null) {
            return null;
        }
        return HealthBarRenderer.raycast(vec, look, e, len);
    }

    public static RayTraceResult raycast(Vector3d origin, Vector3d ray, Entity e, double len) {
        Vector3d next = origin.func_178787_e(ray.func_72432_b().func_186678_a(len));
        return e.field_70170_p.func_217299_a(new RayTraceContext(origin, next, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, e));
    }

    @Nonnull
    public static ItemStack getIcon(LivingEntity entity, boolean boss) {
        if (boss) {
            return new ItemStack((IItemProvider)Items.field_151156_bN);
        }
        CreatureAttribute attr = entity.func_70668_bt();
        if (attr == CreatureAttribute.field_223224_c_) {
            return new ItemStack((IItemProvider)Items.field_151070_bp);
        }
        if (attr == CreatureAttribute.field_223223_b_) {
            return new ItemStack((IItemProvider)Items.field_151078_bh);
        }
        return ItemStack.field_190927_a;
    }

    public static int getColor(LivingEntity entity, boolean colorByType, boolean boss) {
        if (colorByType) {
            int r = 0;
            int g = 255;
            int b = 0;
            if (boss) {
                r = 128;
                g = 0;
                b = 128;
            }
            if (entity instanceof MonsterEntity) {
                r = 255;
                g = 0;
                b = 0;
            }
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        float health = MathHelper.func_76131_a((float)entity.func_110143_aJ(), (float)0.0f, (float)entity.func_110138_aP());
        float hue = Math.max(0.0f, health / entity.func_110138_aP() / 3.0f - 0.07f);
        return Color.HSBtoRGB(hue, 1.0f, 1.0f);
    }
}

