/*
 * Decompiled with CFR 0.152.
 */
package nomowanderer;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nomowanderer.Config;
import nomowanderer.tileentity.NoSolicitingSignTileEntity;

@Mod.EventBusSubscriber(modid="nomowanderer")
public class EntitySpawnHandler {
    @SubscribeEvent
    public static void maybeBlockTraderSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Entity entity = event.getEntity();
        if (entity instanceof WanderingTraderEntity) {
            IChunk eventChunk;
            BlockPos eventPos = event.getEntity().func_180425_c();
            IWorld world = event.getWorld();
            ArrayList<IChunk> chunks = EntitySpawnHandler.getChunksInRadius(world, (eventChunk = world.func_217349_x(eventPos)).func_76632_l(), (Integer)Config.SIGN_SPAWN_PREV_RANGE.get());
            boolean foundSign = EntitySpawnHandler.lookForSignsInChunks(chunks);
            if (foundSign) {
                event.setCanceled(event.isCancelable());
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private static boolean lookForSignsInChunks(ArrayList<IChunk> chunks) {
        for (IChunk chunk : chunks) {
            if (!(chunk instanceof Chunk)) continue;
            Chunk newChunk = (Chunk)chunk;
            Map tileEntities = newChunk.func_177434_r();
            for (BlockPos pos : tileEntities.keySet()) {
                TileEntity te = (TileEntity)tileEntities.get(pos);
                if (!(te instanceof NoSolicitingSignTileEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayList<IChunk> getChunksInRadius(IWorld w, ChunkPos chunkPos, int radius) {
        int curX = chunkPos.field_77276_a - radius;
        int startX = curX;
        int endX = chunkPos.field_77276_a + radius;
        int endZ = chunkPos.field_77275_b + radius;
        ArrayList<IChunk> chunks = new ArrayList<IChunk>();
        for (int curZ = chunkPos.field_77275_b - radius; curZ <= endZ; ++curZ) {
            while (curX <= endX) {
                IChunk chunk = w.func_212866_a_(curX, curZ);
                chunks.add(chunk);
                ++curX;
            }
            curX = startX;
        }
        return chunks;
    }
}

