/*
 * Decompiled with CFR 0.152.
 */
package nomowanderer;

import com.lazy.baubles.api.BaublesApi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nomowanderer.Config;
import nomowanderer.RegistryEvents;
import nomowanderer.compat.ExternalMods;
import nomowanderer.items.NoMoWandererTotemItem;
import nomowanderer.tileentity.NoSolicitingSignTileEntity;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="nomowanderer")
public class EntitySpawnHandler {
    @SubscribeEvent
    public static void maybeBlockTraderSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Entity entity = event.getEntity();
        if (entity instanceof WanderingTraderEntity) {
            boolean cancelSpawn;
            boolean bl = cancelSpawn = (Boolean)Config.DISABLE_TRADER_SPAWN.get() != false || EntitySpawnHandler.canFindTotem(event) || EntitySpawnHandler.canFindSign(event);
            if (cancelSpawn) {
                event.setCanceled(event.isCancelable());
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private static boolean canFindTotem(LivingSpawnEvent.SpecialSpawn event) {
        int TRADER_SPAWN_DIST = 50;
        boolean baubles = ExternalMods.BAUBLES.isLoaded();
        boolean curios = ExternalMods.CURIOS.isLoaded();
        AxisAlignedBB aabb = new AxisAlignedBB(event.getX() - 50.0, event.getY() - 50.0, event.getZ() - 50.0, event.getX() + 50.0, event.getY() + 50.0, event.getZ() + 50.0);
        HashSet<NoMoWandererTotemItem> totemSet = new HashSet<NoMoWandererTotemItem>();
        totemSet.add(RegistryEvents.noMoWandererTotemItem);
        List entities = event.getWorld().func_217357_a(PlayerEntity.class, aabb);
        for (PlayerEntity player : entities) {
            if (!player.field_71071_by.func_213902_a(totemSet) && (!curios || !CuriosApi.getCuriosHelper().findEquippedCurio((Item)RegistryEvents.noMoWandererTotemItem, (LivingEntity)player).isPresent()) && (!baubles || -1 == BaublesApi.isBaubleEquipped((PlayerEntity)player, (Item)RegistryEvents.noMoWandererTotemItem))) continue;
            return true;
        }
        return false;
    }

    private static boolean canFindSign(LivingSpawnEvent.SpecialSpawn event) {
        BlockPos eventPos = event.getEntity().func_233580_cy_();
        IWorld world = event.getWorld();
        IChunk eventChunk = world.func_217349_x(eventPos);
        ArrayList<IChunk> chunks = EntitySpawnHandler.getChunksInRadius(world, eventChunk.func_76632_l(), (Integer)Config.SPAWN_PREV_RANGE.get());
        return EntitySpawnHandler.lookForSignsInChunks(chunks);
    }

    private static boolean lookForSignsInChunks(ArrayList<IChunk> chunks) {
        for (IChunk chunk : chunks) {
            if (!(chunk instanceof Chunk)) continue;
            Chunk newChunk = (Chunk)chunk;
            Map tileEntities = newChunk.func_177434_r();
            for (BlockPos pos : tileEntities.keySet()) {
                TileEntity te = (TileEntity)tileEntities.get(pos);
                if (!(te instanceof NoSolicitingSignTileEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayList<IChunk> getChunksInRadius(IWorld w, ChunkPos chunkPos, int radius) {
        int curX = chunkPos.field_77276_a - radius;
        int startX = curX;
        int endX = chunkPos.field_77276_a + radius;
        int endZ = chunkPos.field_77275_b + radius;
        ArrayList<IChunk> chunks = new ArrayList<IChunk>();
        for (int curZ = chunkPos.field_77275_b - radius; curZ <= endZ; ++curZ) {
            while (curX <= endX) {
                IChunk chunk = w.func_212866_a_(curX, curZ);
                chunks.add(chunk);
                ++curX;
            }
            curX = startX;
        }
        return chunks;
    }
}

