/*
 * Decompiled with CFR 0.152.
 */
package nomowanderer.items;

import com.lazy.baubles.api.BaubleType;
import com.lazy.baubles.api.IBauble;
import com.lazy.baubles.api.cap.BaublesCapabilities;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import nomowanderer.compat.ExternalMods;

public class NoMoWandererTotemItem
extends Item {
    public static final String ID = "no_mo_wanderer_totem";

    public NoMoWandererTotemItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.setRegistryName(new ResourceLocation("nomowanderer", ID));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String msg1 = "Blocks Wandering Trader spawns around the player.";
        String msg2 = "Can be in your inventory, a Baubles or Curios slot.";
        tooltip.add((ITextComponent)new StringTextComponent(msg1).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(msg2).func_240699_a_(TextFormatting.GRAY));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (ExternalMods.BAUBLES.isLoaded()) {
            final IBauble iBauble = () -> BaubleType.TRINKET;
            return new ICapabilityProvider(){
                private final LazyOptional<IBauble> opt = LazyOptional.of(() -> iBauble);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return BaublesCapabilities.ITEM_BAUBLE.orEmpty(cap, this.opt);
                }
            };
        }
        return null;
    }
}

