/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm;

import cpw.mods.modlauncher.Launcher;
import io.github.zekerzhayard.optiforge.asm.transformers.ITransformer;
import io.github.zekerzhayard.optiforge.asm.utils.ASMUtils;
import io.github.zekerzhayard.optiforge.asm.utils.annotations.IAnnotationAction;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"OptiForge");
    private boolean checked = false;
    private List<ITransformer> transformers = new ArrayList<ITransformer>();
    private HashMap<String, IAnnotationAction> annotationActions = new HashMap();

    public void onLoad(String mixinPackage) {
        try {
            URLClassLoader ucl = (URLClassLoader)FieldUtils.readDeclaredField((Object)this.getClass().getClassLoader(), (String)"delegatedClassLoader", (boolean)true);
            FMLLoader.getLoadingModList().getModFiles().stream().filter(mfi -> mfi.getMods().stream().anyMatch(mi -> mi.getModId().equals("optiforge"))).map(mfi -> {
                try {
                    return mfi.getFile().getFilePath().toUri().toURL();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).forEach(url -> {
                try {
                    MethodUtils.invokeMethod((Object)ucl, (boolean)true, (String)"addURL", (Object[])new Object[]{url});
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            ServiceLoader.load(ITransformer.class, ucl).forEach(t -> {
                this.transformers.add((ITransformer)t);
                LOGGER.info(" - Add a transformer: {}", (Object)t.getClass().getName());
            });
            LOGGER.info("Add {} transformer(s) totally.", (Object)this.transformers.size());
            ServiceLoader.load(IAnnotationAction.class, ucl).forEach(a -> {
                this.annotationActions.put(Type.getDescriptor(a.registerAnnotation()), (IAnnotationAction)a);
                LOGGER.info(" - Add an annotation action: {}", (Object)a.getClass().getName());
            });
            LOGGER.info("Add {} annotation action(s) totally.", (Object)this.annotationActions.size());
            this.checked = true;
        }
        catch (Exception e) {
            LOGGER.error("An unexpected issue occurred when loading transformers and all mixin classes will not apply: ", (Throwable)e);
            this.checked = false;
        }
    }

    public String getRefMapperConfig() {
        return Launcher.INSTANCE.environment().findNameMapping("srg").isPresent() ? null : "mixins.optiforge.refmap.json";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return this.checked;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (this.checked) {
            this.transformers.stream().filter(t -> t.isTargetClass(targetClassName)).peek(t -> LOGGER.info("[PRE] Found a transformer \"{}\" for class \"{}\"", (Object)t.getClass().getName(), (Object)targetClassName)).forEach(t -> t.preTransform(targetClass));
        }
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (this.checked) {
            this.applyAnnotationAction(targetClass, mixinClassName, IAnnotationAction::beforePostTransforming);
            this.transformers.stream().filter(t -> t.isTargetClass(targetClassName)).peek(t -> LOGGER.info("[POST] Found a transformer \"{}\" for class \"{}\"", (Object)t.getClass().getName(), (Object)targetClassName)).forEach(t -> t.postTransform(targetClass, mixinClassName));
            this.applyAnnotationAction(targetClass, mixinClassName, IAnnotationAction::afterPostTransforming);
        }
    }

    private void applyAnnotationAction(ClassNode targetClass, String mixinClassName, IAnnotationAction.ActionFunction function) {
        ArrayList methods = new ArrayList(targetClass.methods);
        for (MethodNode mn : methods) {
            if (!ASMUtils.isMixinMethod(mn, mixinClassName)) continue;
            this.annotationActions.forEach((k, v) -> {
                AnnotationNode annotation = Annotations.get((List)mn.visibleAnnotations, (String)k);
                if (annotation != null) {
                    HashMap values = new HashMap();
                    if (annotation.values != null) {
                        for (int i = 0; i < annotation.values.size(); i += 2) {
                            values.put((String)annotation.values.get(i), annotation.values.get(i + 1));
                        }
                    }
                    function.action((IAnnotationAction)v, targetClass, mn, values, mixinClassName);
                }
            });
        }
    }
}

