/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.fml;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformTargetLabel;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.TransformerHolder;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import io.github.zekerzhayard.optiforge.asm.fml.FakeOptiFineTransformationService;
import io.github.zekerzhayard.optiforge.asm.fml.OptiForgeTransformer;
import io.github.zekerzhayard.optiforge.asm.fml.VersionChecker;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.loading.FMLServiceProvider;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class OptiForgeTransformationService
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String NAME = "optiforge";
    private static boolean checked;

    @Nonnull
    public String name() {
        return NAME;
    }

    public void initialize(@Nonnull IEnvironment environment) {
        StringBuilder currentFMLVersion = new StringBuilder();
        Object transformationServicesHandler = new Object();
        try {
            transformationServicesHandler = FieldUtils.readDeclaredField((Object)Launcher.INSTANCE, (String)"transformationServicesHandler", (boolean)true);
            ServiceLoader transformationServices = (ServiceLoader)FieldUtils.readDeclaredField((Object)transformationServicesHandler, (String)"transformationServices", (boolean)true);
            ServiceLoaderStreamUtils.map((ServiceLoader)transformationServices, ts -> ts).filter(ts -> ts.getClass().equals(FMLServiceProvider.class)).findFirst().ifPresent(ts -> {
                try {
                    currentFMLVersion.append(FieldUtils.readDeclaredField((Object)ts, (String)"targetForgeVersion", (boolean)true));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("An unexpected issue occurred when detecting Forge version, ignore this if you are under development environment: ", (Throwable)e);
        }
        try {
            Path path = Paths.get(OptiForgeTransformationService.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            checked = Files.isDirectory(path, new LinkOption[0]) || currentFMLVersion.length() == 0;
            if (!checked) {
                checked = VersionChecker.IS_LOADED && VersionChecker.checkOptiFineVersion(VersionChecker.DEFAULT_FUNCTION, true) && VersionChecker.checkMixinVersion(VersionChecker.DEFAULT_FUNCTION) && VersionChecker.checkForgeVersion(VersionChecker.DEFAULT_FUNCTION, currentFMLVersion.toString());
                if (checked) {
                    ModDirTransformerDiscoverer.getExtraLocators().add(path);
                } else {
                    Map serviceLookup = (Map)FieldUtils.readDeclaredField((Object)transformationServicesHandler, (String)"serviceLookup", (boolean)true);
                    if (serviceLookup.containsKey("OptiFine")) {
                        Constructor constructor = TransformationServiceDecorator.class.getDeclaredConstructor(ITransformationService.class);
                        constructor.setAccessible(true);
                        serviceLookup.put("OptiFine", constructor.newInstance(new FakeOptiFineTransformationService()));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An unexpected issue occurred when checking versions: ", (Throwable)e);
        }
    }

    public void beginScanning(@Nonnull IEnvironment environment) {
    }

    public void onLoad(@Nonnull IEnvironment env, @Nonnull Set<String> otherServices) {
    }

    @Nonnull
    public List<ITransformer> transformers() {
        if (checked) {
            try {
                Object transformationServicesHandler = FieldUtils.readDeclaredField((Object)Launcher.INSTANCE, (String)"transformationServicesHandler", (boolean)true);
                TransformStore transformStore = (TransformStore)FieldUtils.readDeclaredField((Object)transformationServicesHandler, (String)"transformStore", (boolean)true);
                EnumMap transformers = (EnumMap)FieldUtils.readDeclaredField((Object)transformStore, (String)"transformers", (boolean)true);
                for (Map.Entry transformListEntry : transformers.entrySet()) {
                    if (((TransformTargetLabel.LabelType)transformListEntry.getKey()).equals((Object)TransformTargetLabel.LabelType.CLASS)) continue;
                    Map transformersMap = (Map)FieldUtils.readDeclaredField(transformListEntry.getValue(), (String)"transformers", (boolean)true);
                    for (Map.Entry entry : transformersMap.entrySet()) {
                        for (ITransformer transformer : (List)entry.getValue()) {
                            String className = ((Type)MethodUtils.invokeMethod(entry.getKey(), (boolean)true, (String)"getClassName")).getInternalName();
                            MethodUtils.invokeMethod(transformers.get(TransformTargetLabel.LabelType.CLASS), (boolean)true, (String)"addTransformer", (Object[])new Object[]{new TransformTargetLabel(className), new TransformerHolder(new OptiForgeTransformer(transformer, ((TransformTargetLabel.LabelType)transformListEntry.getKey()).equals((Object)TransformTargetLabel.LabelType.FIELD) ? ITransformer.Target.targetField((String)className, (String)((TransformTargetLabel)entry.getKey()).getElementName()) : ITransformer.Target.targetMethod((String)className, (String)((TransformTargetLabel)entry.getKey()).getElementName(), (String)((TransformTargetLabel)entry.getKey()).getElementDescriptor().getInternalName())), ((TransformerHolder)transformer).owner())});
                        }
                    }
                    transformersMap.clear();
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return new ArrayList<ITransformer>();
    }

    static {
        try {
            FieldUtils.writeDeclaredField((Object)NAME, (String)"hash", (Object)-65536, (boolean)true);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

