/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.fml;

import cpw.mods.modlauncher.api.ITransformationService;
import io.github.zekerzhayard.optiforge.asm.fml.FakeOptiFineTransformationService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import net.minecraftforge.fml.loading.LibraryFinder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class VersionChecker {
    public static final boolean IS_LOADED;
    public static final String REQUIRED_MINECRAFT_VERSION;
    public static final String REQUIRED_OPTIFINE_VERSION;
    public static final String REQUIRED_FORGE_VERSION;
    public static final Function<String, Boolean> DEFAULT_FUNCTION;
    private static final Logger LOGGER;

    public static boolean checkOptiFineVersion(Function<String, Boolean> function, boolean shouldScan) {
        block12: {
            StringBuilder mcVersion = new StringBuilder(REQUIRED_MINECRAFT_VERSION);
            try {
                String ofVer = (String)Class.forName("optifine.Installer").getMethod("getOptiFineVersion", new Class[0]).invoke(null, new Object[0]);
                String ofVersion = VersionChecker.parseOptiFineVersion(ofVer, mcVersion);
                if (ofVersion != null) {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)("[" + REQUIRED_OPTIFINE_VERSION + ",)"));
                    if (!mcVersion.toString().equals(REQUIRED_MINECRAFT_VERSION) || !versionRange.containsVersion((ArtifactVersion)new DefaultArtifactVersion(ofVersion))) {
                        DefaultArtifactVersion requiredOFVersion = new DefaultArtifactVersion(REQUIRED_OPTIFINE_VERSION);
                        String requiredOptiFineCompletedVersion = "OptiFine_" + REQUIRED_MINECRAFT_VERSION + "_HD_U_" + (char)(requiredOFVersion.getMajorVersion() + 65 - 1) + (requiredOFVersion.getMinorVersion() + (requiredOFVersion.getIncrementalVersion() == 0 ? -1 : 0)) + (requiredOFVersion.getIncrementalVersion() == 0 ? "" : "_pre" + requiredOFVersion.getIncrementalVersion());
                        return function.apply("You are using an unsupported OptiFine version, you can download the newer version from https://optifine.net/downloads.\nThe game will continue, and run without OptiFine and OptiForge.\n(You installed: " + ofVer + ", required: " + requiredOptiFineCompletedVersion + " or newer)");
                    }
                    break block12;
                }
                return function.apply("Unable to parse OptiFine version, try to re-download OptiFine from https://optifine.net/downloads.\nThe game will continue, and run without OptiFine and OptiForge.\n(Detected version: " + ofVer + ")");
            }
            catch (Exception e) {
                if (shouldScan) {
                    try {
                        Method method = LibraryFinder.class.getDeclaredMethod("findLibsPath", new Class[0]);
                        method.setAccessible(true);
                        Path libOptiFinePath = ((Path)method.invoke(null, new Object[0])).resolve("optifine").resolve("OptiFine");
                        if (Files.isDirectory(libOptiFinePath, new LinkOption[0])) {
                            String optifineVersion = "";
                            Path libOptiFine = null;
                            for (Path p2 : Files.list(libOptiFinePath).filter(p -> Files.isRegularFile(p.resolve("OptiFine-" + p.getFileName().toString() + ".jar"), new LinkOption[0]) && p.getFileName().toString().split("_")[0].equals(mcVersion.toString())).map(p -> p.resolve("OptiFine-" + p.getFileName().toString() + ".jar")).collect(Collectors.toList())) {
                                LOGGER.info("Found a possible OptiFine jar: {}", (Object)p2.toAbsolutePath());
                                String ofVersion = VersionChecker.parseOptiFineVersion(VersionChecker.getOptiFineVersionFromJar(p2), null);
                                if (ofVersion != null && optifineVersion.equals("")) {
                                    optifineVersion = ofVersion;
                                }
                                if (ofVersion == null || new DefaultArtifactVersion(ofVersion).compareTo((ArtifactVersion)new DefaultArtifactVersion(optifineVersion)) <= 0) continue;
                                optifineVersion = ofVersion;
                                libOptiFine = p2;
                            }
                            if (libOptiFine != null) {
                                LOGGER.info("Found the real OptiFine jar: {}", (Object)libOptiFine.toAbsolutePath());
                                MethodUtils.invokeMethod((Object)VersionChecker.class.getClassLoader(), (boolean)true, (String)"addURL", (Object[])new Object[]{libOptiFine.toUri().toURL()});
                                FakeOptiFineTransformationService.getInstance().service = (ITransformationService)Class.forName("optifine.OptiFineTransformationService").newInstance();
                                FakeOptiFineTransformationService.getInstance().service.onLoad(FakeOptiFineTransformationService.getInstance().getEnv(), FakeOptiFineTransformationService.getInstance().getOtherServices());
                                return VersionChecker.checkOptiFineVersion(function, false);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("", throwable);
                    }
                }
                StringBuilder message = new StringBuilder("It looks like you have not put OptiFine itself into the mods folder, you can download it from https://optifine.net/downloads.\nThe game will continue, and run without OptiFine and OptiForge.\n\n" + e + "\n");
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    message.append("\tat ").append(traceElement).append("\n");
                }
                LOGGER.error(message.toString());
                return function.apply(message.toString());
            }
        }
        return true;
    }

    public static String parseOptiFineVersion(String optifineVersion, StringBuilder mcVersion) {
        Pattern pattern = Pattern.compile("OptiFine_(?<mcVersion>\\d+\\.\\d+\\.\\d*)_HD_U_(?<ofMajorVersion>[A-Z])(?<ofMinorVersion>\\d+)(_pre(?<ofPreVersion>\\d+))?");
        Matcher matcher = pattern.matcher(optifineVersion);
        if (matcher.find()) {
            if (mcVersion != null) {
                mcVersion.delete(0, mcVersion.length());
                mcVersion.append(matcher.group("mcVersion"));
            }
            int ofMajorVersion = matcher.group("ofMajorVersion").toCharArray()[0] - 65 + 1;
            int ofMinorVersion = Integer.parseInt(matcher.group("ofMinorVersion"));
            String ofPreVersion = matcher.group("ofPreVersion");
            if (ofPreVersion == null) {
                ofPreVersion = "0";
                ++ofMinorVersion;
            }
            return ofMajorVersion + "." + ofMinorVersion + "." + ofPreVersion;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOptiFineVersionFromJar(Path optifine) {
        try (ZipFile zf = new ZipFile(optifine.toFile());){
            ZipEntry ze = zf.getEntry("net/optifine/Config.class");
            if (ze == null) return null;
            try (InputStream is = zf.getInputStream(ze);){
                FieldNode fn;
                ClassNode cn = new ClassNode();
                new ClassReader(IOUtils.toByteArray((InputStream)is)).accept((ClassVisitor)cn, 8);
                Iterator iterator = cn.fields.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                    fn = (FieldNode)iterator.next();
                } while (!fn.name.equals("VERSION") || !fn.desc.equals("Ljava/lang/String;"));
                String string = (String)fn.value;
                return string;
            }
        }
        catch (Throwable t) {
            LOGGER.catching(t);
        }
        return null;
    }

    public static boolean checkMixinVersion(Function<String, Boolean> function) {
        try {
            Class.forName("org.spongepowered.asm.launch.MixinBootstrap").getField("VERSION");
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder("It looks like you have not install Mixin, you can download it from https://www.curseforge.com/minecraft/mc-mods/mixinbootstrap.\nThe game will continue, and run without OptiFine and OptiForge.\n\n" + e + "\n");
            for (StackTraceElement traceElement : e.getStackTrace()) {
                message.append("\tat ").append(traceElement).append("\n");
            }
            LOGGER.error(message.toString());
            return function.apply(message.toString());
        }
        return true;
    }

    public static boolean checkForgeVersion(Function<String, Boolean> function, String currentFMLVersion) {
        try {
            VersionRange version = VersionRange.createFromVersionSpec((String)("[" + REQUIRED_FORGE_VERSION + ",)"));
            if (!version.containsVersion((ArtifactVersion)new DefaultArtifactVersion(currentFMLVersion))) {
                return function.apply("You are using an unsupported Forge version, you can download the newer version from https://files.minecraftforge.net/maven/net/minecraftforge/forge/index_" + REQUIRED_MINECRAFT_VERSION + ".html.\nThe game will continue, and run without OptiFine and OptiForge.\n(You installed: " + currentFMLVersion + ", required: " + REQUIRED_FORGE_VERSION + " or newer)");
            }
        }
        catch (Exception e) {
            LOGGER.error("An unexpected issue occurred when checking Forge version: ", (Throwable)e);
        }
        return true;
    }

    static {
        boolean isLoaded;
        DEFAULT_FUNCTION = str -> {
            JOptionPane.showMessageDialog(null, str, "OptiForge Version Checker", 2);
            return false;
        };
        LOGGER = LogManager.getLogger();
        Properties properties = new Properties();
        try {
            properties.load(VersionChecker.class.getResourceAsStream("/requiredmods.properties"));
            isLoaded = true;
        }
        catch (IOException e) {
            LOGGER.error("An unexpected issue occurred when loading required mods versions, version checker will not work: ", (Throwable)e);
            isLoaded = false;
        }
        IS_LOADED = isLoaded;
        REQUIRED_MINECRAFT_VERSION = properties.getProperty("required.minecraft.version");
        REQUIRED_OPTIFINE_VERSION = properties.getProperty("required.optifine.version");
        REQUIRED_FORGE_VERSION = properties.getProperty("required.forge.version");
    }
}

