/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.transformers.net.minecraft.client.renderer;

import io.github.zekerzhayard.optiforge.asm.transformers.ITransformer;
import io.github.zekerzhayard.optiforge.asm.utils.ASMUtils;
import java.util.Objects;
import net.minecraftforge.coremod.api.ASMAPI;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.util.Bytecode;

public class ItemRendererTransformer
implements ITransformer {
    @Override
    public boolean isTargetClass(String className) {
        return className.equals("net.minecraft.client.renderer.ItemRenderer");
    }

    @Override
    public ClassNode postTransform(ClassNode cn, String mixinClassName) {
        MethodNode mn = Objects.requireNonNull(Bytecode.findMethod((ClassNode)cn, (String)ASMAPI.mapMethod((String)"func_229111_a_"), (String)"(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/model/ItemCameraTransforms$TransformType;ZLcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;IILnet/minecraft/client/renderer/model/IBakedModel;)V"));
        boolean isTarget = false;
        LabelNode ln = new LabelNode();
        block0: for (AbstractInsnNode ain : mn.instructions.toArray()) {
            if (ain.getOpcode() == 183) {
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.contains("inject$renderItem$0")) continue;
                for (MethodNode method : cn.methods) {
                    if (!min.name.equals(method.name) || !min.desc.equals(method.desc) || !ASMUtils.isMixinMethod(method, mixinClassName)) continue;
                    mn.instructions.insert(ain, (AbstractInsnNode)new JumpInsnNode(154, ln));
                    continue block0;
                }
                continue;
            }
            if (isTarget || ain.getOpcode() != 178) continue;
            FieldInsnNode fin = (FieldInsnNode)ain;
            if (!fin.owner.equals("net/optifine/reflect/Reflector") || !fin.name.equals("IForgeItem_getItemStackTileEntityRenderer") || !fin.desc.equals("Lnet/optifine/reflect/ReflectorMethod;")) continue;
            isTarget = true;
            AbstractInsnNode ain2 = ain;
            while ((ain2 = ain2.getPrevious()).getOpcode() != 167) {
            }
            LabelNode ln2 = ((JumpInsnNode)ain2).label;
            mn.instructions.insert(ain2, (AbstractInsnNode)ln);
            mn.instructions.insert((AbstractInsnNode)ln, (AbstractInsnNode)new JumpInsnNode(167, ln2));
        }
        return cn;
    }
}

