/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.utils.annotations;

import io.github.zekerzhayard.optiforge.asm.utils.annotations.IAnnotationAction;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import net.minecraftforge.coremod.api.ASMAPI;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface LazyOverwrite {
    public String prefix();

    public boolean remap() default true;

    public static class AnnotationAction
    implements IAnnotationAction {
        @Override
        public Class<? extends Annotation> registerAnnotation() {
            return LazyOverwrite.class;
        }

        @Override
        public void afterPostTransforming(ClassNode targetClass, MethodNode targetMethod, Map<String, ?> values, String mixinClassName) {
            Object remap;
            Object prefix = values.get("prefix");
            if (prefix instanceof String) {
                targetMethod.name = StringUtils.removeStart((String)targetMethod.name, (String)((String)prefix));
            }
            if (!Boolean.FALSE.equals(remap = values.get("remap"))) {
                targetMethod.name = ASMAPI.mapMethod((String)targetMethod.name);
            }
        }
    }
}

