/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.utils.annotations;

import io.github.zekerzhayard.optiforge.asm.utils.annotations.IAnnotationAction;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.util.Annotations;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MarkStatic {
    public Marker[] markers();

    public static class AnnotationAction
    implements IAnnotationAction {
        @Override
        public Class<? extends Annotation> registerAnnotation() {
            return MarkStatic.class;
        }

        @Override
        public void afterPostTransforming(ClassNode targetClass, MethodNode targetMethod, Map<String, ?> values, String mixinClassName) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, Boolean> isInterfaceMap = new HashMap<String, Boolean>();
            for (AnnotationNode an : (List)values.get("markers")) {
                String before = ((Type)Annotations.getValue((AnnotationNode)an, (String)"before")).getInternalName();
                map.put(before, ((Type)Annotations.getValue((AnnotationNode)an, (String)"after")).getInternalName());
                isInterfaceMap.put(before, Boolean.TRUE.equals(Annotations.getValue((AnnotationNode)an, (String)"isInterface")));
            }
            for (AbstractInsnNode ain : targetMethod.instructions.toArray()) {
                if (ain.getOpcode() != 184) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!map.containsKey(min.owner)) continue;
                min.itf = (Boolean)isInterfaceMap.get(min.owner);
                min.owner = (String)map.get(min.owner);
            }
        }
    }

    public static @interface Marker {
        public Class<?> before();

        public Class<?> after();

        public boolean isInterface() default false;
    }
}

