/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.utils.annotations;

import io.github.zekerzhayard.optiforge.asm.utils.ASMUtils;
import io.github.zekerzhayard.optiforge.asm.utils.annotations.IAnnotationAction;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RedirectSurrogate {
    public int[] loacalVariableOrdinals();

    public static class AnnotationAction
    implements IAnnotationAction {
        @Override
        public Class<? extends Annotation> registerAnnotation() {
            return RedirectSurrogate.class;
        }

        @Override
        public void afterPostTransforming(ClassNode targetClass, MethodNode targetMethod, Map<String, ?> values, String mixinClassName) {
            MethodNode mixinMethod = null;
            for (MethodNode mn : targetClass.methods) {
                String[] names;
                if (!ASMUtils.isMixinMethod(mn, mixinClassName) || (names = mn.name.split("\\$", 3)).length != 3 || !targetMethod.name.equals(names[2])) continue;
                mixinMethod = mn;
                break;
            }
            Objects.requireNonNull(mixinMethod, "You must specify a @RedirectSurrogate method to overload another mixin method!");
            for (MethodNode mn : targetClass.methods) {
                for (AbstractInsnNode ain : mn.instructions.toArray()) {
                    int len;
                    List ordinals;
                    if (!(ain instanceof MethodInsnNode)) continue;
                    MethodInsnNode min = (MethodInsnNode)ain;
                    if (!min.owner.equals(targetClass.name) || !min.name.equals(mixinMethod.name) || !min.desc.equals(mixinMethod.desc) || (ordinals = (List)values.get("loacalVariableOrdinals")) == null) continue;
                    Type[] targetMethodParams = Type.getArgumentTypes((String)targetMethod.desc);
                    for (int i = len = Type.getArgumentTypes((String)mixinMethod.desc).length; i < targetMethodParams.length; ++i) {
                        mn.instructions.insertBefore((AbstractInsnNode)min, (AbstractInsnNode)new VarInsnNode(targetMethodParams[i].getOpcode(21), ASMUtils.findLocalVariableIndex(mn, targetMethodParams[i].getDescriptor(), (Integer)ordinals.get(i - len))));
                    }
                    min.desc = targetMethod.desc;
                }
            }
            targetMethod.name = mixinMethod.name;
            targetClass.methods.remove(mixinMethod);
        }
    }
}

