/*
 * Decompiled with CFR 0.152.
 */
package io.github.jmanz7.oreandfarming.items;

import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class DrillItem
extends PickaxeItem {
    private DrillTier tier;

    public DrillItem(DrillTier tier, Item.Properties builder) {
        super((IItemTier)tier, 1, -2.8f, builder);
        this.tier = tier;
    }

    public DrillTier getTier() {
        return this.tier;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return super.func_150893_a(stack, state) / 3.0f;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K) {
            Direction.Axis axis = entityLiving.func_174811_aO().func_176740_k();
            if (entityLiving.field_70125_A < -45.0f || entityLiving.field_70125_A > 45.0f) {
                axis = Direction.Axis.Y;
            }
            int side = this.tier.getMiningSize() / 2;
            for (int x = -side; x <= side; ++x) {
                for (int y = -side; y <= side; ++y) {
                    BlockPos destroyPos;
                    if (x == 0 && y == 0) continue;
                    switch (axis) {
                        case X: {
                            destroyPos = pos.func_177982_a(0, y, x);
                            break;
                        }
                        case Y: {
                            destroyPos = pos.func_177982_a(x, 0, y);
                            break;
                        }
                        case Z: {
                            destroyPos = pos.func_177982_a(x, y, 0);
                            break;
                        }
                        default: {
                            destroyPos = pos;
                        }
                    }
                    BlockState destroyState = worldIn.func_180495_p(destroyPos);
                    boolean drop = destroyState.canHarvestBlock((IBlockReader)worldIn, destroyPos, (PlayerEntity)entityLiving);
                    if (!(destroyState.func_185887_b((IBlockReader)worldIn, destroyPos) >= 0.0f)) continue;
                    worldIn.func_175655_b(destroyPos, drop);
                }
            }
            stack.func_222118_a(1, entityLiving, entity -> entity.func_213334_d(Hand.MAIN_HAND));
            return true;
        }
        return false;
    }

    public static enum DrillTier implements IItemTier
    {
        IRON(3, 2, 80, 6.0f, 2.0f, 14, Items.field_151042_j),
        DIAMOND(5, 3, 100, 8.0f, 3.0f, 10, Items.field_151045_i);

        private final int miningSize;
        private final int harvestLevel;
        private final int maxUses;
        private final float efficiency;
        private final float attackDamage;
        private final int enchantability;
        private final Item repairMaterial;

        private DrillTier(int miningSize, int harvestLevel, int maxUses, float efficiency, float attackDamage, int enchantability, Item repairMaterial) {
            this.miningSize = miningSize;
            this.harvestLevel = harvestLevel;
            this.maxUses = maxUses;
            this.efficiency = efficiency;
            this.attackDamage = attackDamage;
            this.enchantability = enchantability;
            this.repairMaterial = repairMaterial;
        }

        public int getMiningSize() {
            return this.miningSize;
        }

        public int func_200926_a() {
            return this.maxUses;
        }

        public float func_200928_b() {
            return this.efficiency;
        }

        public float func_200929_c() {
            return this.attackDamage;
        }

        public int func_200925_d() {
            return this.harvestLevel;
        }

        public int func_200927_e() {
            return this.enchantability;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.repairMaterial});
        }
    }
}

