/*
 * Decompiled with CFR 0.152.
 */
package kais.outfox.fox;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import kais.outfox.Outfox;
import kais.outfox.OutfoxConfig;
import kais.outfox.OutfoxResources;
import kais.outfox.fox.EntityAISearchForBlock;
import kais.outfox.fox.EntityAIStealFromOwnersAttacker;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.DyeUtils;

public class EntityFox
extends EntityTameable {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityFox.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RIBBON_COLOR = EntityDataManager.func_187226_a(EntityFox.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> STOLEN_ITEM = EntityDataManager.func_187226_a(EntityFox.class, (DataSerializer)DataSerializers.field_187196_f);
    private EntityAIAvoidEntity<EntityPlayer> aiAvoid;
    private EntityAISit aiSit;
    private EntityAISearchForBlock aiSearch;
    private EntityAITempt aiTempt;
    @Nullable
    protected Block searchedBlock;
    @Nullable
    protected HashMap<String, String> stateTags;
    protected PathNavigateGround searchNavigator;
    protected int stealCooldown;
    private boolean interacted;
    private boolean isWet;
    private boolean isShaking;
    private float timeFoxIsShaking;
    private float prevTimeFoxIsShaking;

    public EntityFox(World worldIn) {
        super(worldIn);
        this.searchNavigator = new PathNavigateTweakable((EntityLiving)this, worldIn);
        this.func_70105_a(0.6f, 0.7f);
    }

    protected void func_184651_r() {
        this.aiSearch = new EntityAISearchForBlock(this, 0.75);
        this.aiSit = new AISit(this);
        this.aiTempt = new EntityAITempt((EntityCreature)this, 0.5, Items.field_179558_bo, true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.75));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIStealFromOwnersAttacker(this, 0.66, 1.15));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.aiSearch);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 12.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(RIBBON_COLOR, (Object)EnumDyeColor.BLUE.func_176767_b());
        this.field_70180_af.func_187214_a(STOLEN_ITEM, (Object)ItemStack.field_190927_a);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setVariant(this.field_70146_Z.nextInt(6));
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(Math.max(56.0, (double)OutfoxConfig.search.search_range));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.33);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74774_a("RibbonColor", (byte)this.getRibbonColor().func_176767_b());
        if (this.searchedBlock != null) {
            compound.func_74778_a("SearchedBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.searchedBlock)).toString());
            if (this.stateTags != null) {
                String tagstring = "[";
                for (Map.Entry<String, String> entry : this.stateTags.entrySet()) {
                    tagstring = tagstring + entry.getKey() + "=" + entry.getValue() + ",";
                }
                tagstring = tagstring + "]";
                compound.func_74778_a("SearchedBlockTags", tagstring);
            }
        }
        if (!((ItemStack)this.field_70180_af.func_187225_a(STOLEN_ITEM)).func_190926_b()) {
            compound.func_74782_a("StolenItem", (NBTBase)((ItemStack)this.field_70180_af.func_187225_a(STOLEN_ITEM)).func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Variant", 99)) {
            this.setVariant(compound.func_74762_e("Variant"));
        } else {
            OutfoxResources.logWarn("A fox didn't have a saved variant for some reason, defaulting to 0");
            this.setVariant(0);
        }
        if (compound.func_150297_b("RibbonColor", 99)) {
            this.setRibbonColor(EnumDyeColor.func_176766_a((int)compound.func_74771_c("RibbonColor")));
        } else {
            OutfoxResources.logWarn("A fox didn't have a saved ribbon color for some reason, defaulting to blue");
            this.setRibbonColor(EnumDyeColor.BLUE);
        }
        if (compound.func_74764_b("SearchedBlock")) {
            this.searchedBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("SearchedBlock")));
            if (compound.func_74764_b("SearchedBlockTags")) {
                this.stateTags = OutfoxResources.stateStringToHashMap(compound.func_74779_i("SearchedBlockTags"), compound.func_74779_i("SearchedBlock"));
            }
        }
        if (compound.func_74764_b("StolenItem")) {
            this.setStolenItem(new ItemStack(compound.func_74775_l("StolenItem")));
        } else {
            this.setStolenItem(ItemStack.field_190927_a);
        }
        if (this.aiSit != null) {
            this.aiSit.func_75270_a(compound.func_74767_n("Sitting"));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
        }
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeFoxIsShaking = 0.0f;
            this.prevTimeFoxIsShaking = 0.0f;
        } else if (this.isShaking) {
            if (this.timeFoxIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeFoxIsShaking = this.timeFoxIsShaking;
            this.timeFoxIsShaking += 0.05f;
            if (this.prevTimeFoxIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeFoxIsShaking = 0.0f;
                this.timeFoxIsShaking = 0.0f;
            }
            if (this.prevTimeFoxIsShaking > 0.4f && this.field_70170_p.field_72995_K) {
                float py = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeFoxIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float px = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float pz = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float vx = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.1f;
                    float vz = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.1f;
                    Outfox.proxy.doParticleEffect("shake", this, this.field_70165_t + (double)px, py + 0.8f, this.field_70161_v + (double)pz, vx, this.field_70181_x, vz);
                }
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.interacted = false;
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && this.field_70122_E && !this.func_70781_l()) {
            this.isShaking = true;
            this.timeFoxIsShaking = 0.0f;
            this.prevTimeFoxIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropStolenItem();
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean isFoxFood;
        if (this.interacted) {
            return false;
        }
        this.interacted = true;
        ItemStack item = player.func_184586_b(hand);
        boolean bl = isFoxFood = item.func_77973_b() instanceof ItemFood && this.func_70877_b(item);
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player)) {
            if (!(isFoxFood && this.func_110143_aJ() < 15.0f || !super.func_184645_a(player, hand))) {
                return true;
            }
            if (!item.func_190926_b()) {
                if (isFoxFood && this.func_110143_aJ() < 15.0f) {
                    ItemFood food = (ItemFood)item.func_77973_b();
                    this.func_70691_i(food.func_150905_g(item));
                    if (!player.field_71075_bZ.field_75098_d) {
                        item.func_190918_g(1);
                    }
                    return true;
                }
                if (DyeUtils.isDye((ItemStack)item)) {
                    EnumDyeColor color = EnumDyeColor.func_176766_a((int)DyeUtils.dyeDamageFromStack((ItemStack)item).orElse(EnumDyeColor.BLUE.func_176767_b()));
                    if (color != this.getRibbonColor()) {
                        this.setRibbonColor(color);
                        if (!player.field_71075_bZ.field_75098_d) {
                            item.func_190918_g(1);
                        }
                        return true;
                    }
                } else if (this.setSearchedBlock(item)) {
                    return true;
                }
            } else if (OutfoxConfig.search.search_enabled && player.func_70093_af() && this.searchedBlock != null) {
                if (this.aiSearch != null) {
                    this.aiSearch.reset();
                }
                this.searchedBlock = null;
                Outfox.proxy.doParticlesSimple("block_cancel", this);
                return true;
            }
            if (!this.field_70170_p.field_72995_K && hand.equals((Object)EnumHand.OFF_HAND) && !this.dropStolenItem()) {
                this.aiSit.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.func_70661_as().func_75499_g();
                return true;
            }
        } else if (!this.func_70909_n() && (player.field_71075_bZ.field_75098_d || this.aiTempt == null || this.aiTempt.func_75277_f()) && isFoxFood && player.func_70068_e((Entity)this) < 9.0) {
            if (!player.field_71075_bZ.field_75098_d) {
                item.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if ((player.field_71075_bZ.field_75098_d || this.field_70146_Z.nextInt(Math.min(1, OutfoxConfig.general.tame_chance)) + 1 == 1) && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.func_70908_e(true);
                    this.aiSit.func_75270_a(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        this.interacted = false;
        return false;
    }

    protected void func_175544_ck() {
        if (this.aiAvoid == null) {
            this.aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 12.0f, 0.7, 1.2);
        }
        this.field_70714_bg.func_85156_a(this.aiAvoid);
        if (!this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(4, this.aiAvoid);
        }
    }

    public ItemStack func_184607_cu() {
        return (ItemStack)this.field_70180_af.func_187225_a(STOLEN_ITEM);
    }

    public boolean func_70877_b(ItemStack item) {
        return item.func_77973_b().equals(Items.field_179558_bo) || item.func_77973_b().equals(Items.field_179559_bp);
    }

    public boolean func_70878_b(EntityAnimal otheranimal) {
        return this.func_70909_n() && !this.func_70906_o() && super.func_70878_b(otheranimal) && !((EntityTameable)otheranimal).func_70906_o();
    }

    public EntityFox createChild(EntityAgeable ageable) {
        EntityFox fox = new EntityFox(this.field_70170_p);
        fox.setVariant(this.field_70146_Z.nextInt(6));
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            fox.func_184754_b(uuid);
            fox.func_70903_f(true);
        }
        return fox;
    }

    public boolean func_85031_j(Entity entityIn) {
        if (entityIn instanceof EntityPlayer && (EntityPlayer)entityIn == this.func_70902_q() && this.func_70902_q().field_184622_au != null) {
            String item = this.func_70902_q().func_184586_b(this.func_70902_q().field_184622_au).func_77973_b().getRegistryName().func_110623_a();
            for (String s : OutfoxConfig.general.immune_tools) {
                if (!item.contains(s)) continue;
                return true;
            }
        }
        boolean b = super.func_85031_j(entityIn);
        if (!this.field_70170_p.field_72995_K) {
            this.aiSit.func_75270_a(b);
        }
        return b;
    }

    public boolean func_70104_M() {
        if (this.aiSearch != null && this.aiSearch.isBlockFound()) {
            return !this.func_70661_as().func_75500_f() && super.func_70104_M();
        }
        return super.func_70104_M();
    }

    public int getVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(VARIANT)), (int)0, (int)5);
    }

    public EnumDyeColor getRibbonColor() {
        return EnumDyeColor.func_176766_a((int)((Integer)this.field_70180_af.func_187225_a(RIBBON_COLOR) & 0xF));
    }

    public void setRibbonColor(EnumDyeColor ribboncolor) {
        this.field_70180_af.func_187227_b(RIBBON_COLOR, (Object)ribboncolor.func_176767_b());
    }

    @Nullable
    public Block getSearchedBlock() {
        return this.searchedBlock;
    }

    @Nullable
    public int[] getTargetBlock() {
        if (this.aiSearch != null) {
            return this.aiSearch.getTargetBlock();
        }
        return null;
    }

    public boolean hasStolenItem() {
        return this.field_70180_af.func_187225_a(STOLEN_ITEM) != ItemStack.field_190927_a;
    }

    public boolean setStolenItem(ItemStack item) {
        this.field_70180_af.func_187227_b(STOLEN_ITEM, (Object)item);
        return this.field_70180_af.func_187225_a(STOLEN_ITEM) != ItemStack.field_190927_a;
    }

    public boolean dropStolenItem() {
        ItemStack item = (ItemStack)this.field_70180_af.func_187225_a(STOLEN_ITEM);
        if (!item.func_190926_b()) {
            this.func_70099_a(item, 0.5f);
            this.field_70180_af.func_187227_b(STOLEN_ITEM, (Object)ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    protected boolean func_70041_e_() {
        if (this.aiSearch != null) {
            return !this.aiSearch.isRunning() && super.func_70041_e_();
        }
        return super.func_70041_e_();
    }

    protected void playStealSound() {
        this.func_184185_a(OutfoxResources.FOX_STEAL_SND, this.func_70599_aP(), 1.0f);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return OutfoxConfig.search.search_enabled && !this.func_70906_o() && this.aiSearch != null && this.aiSearch.isBlockFound() ? OutfoxResources.FOX_SNIFF_SND : OutfoxResources.FOX_IDLE_SND;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return OutfoxResources.FOX_HURT_SND;
    }

    protected SoundEvent func_184615_bR() {
        return OutfoxResources.FOX_DEATH_SND;
    }

    protected void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    protected boolean setSearchedBlock(ItemStack item) {
        if (!OutfoxConfig.search.search_enabled) {
            return false;
        }
        Block b = null;
        String tags = "";
        String[] alias = OutfoxResources.getAliasedItem(item);
        if (alias != null) {
            b = Block.func_149684_b((String)alias[0]);
            tags = alias[1];
        } else if (item.func_77973_b() instanceof ItemBlock) {
            b = ((ItemBlock)item.func_77973_b()).func_179223_d();
        }
        if (b != null) {
            if (this.aiSearch != null) {
                this.aiSearch.reset();
            }
            if (OutfoxResources.checkBlockIdIsBlacklisted(b.getRegistryName().toString())) {
                this.searchedBlock = b;
                if (tags == "") {
                    this.setBlockTags(b, item.func_77960_j());
                } else {
                    this.stateTags = OutfoxResources.stateStringToHashMap(tags, alias[0] + " (from aliased items list, check config!)");
                }
                Outfox.proxy.doParticlesSimple("block_set", this);
                return true;
            }
            this.searchedBlock = null;
            this.stateTags = new HashMap();
            Outfox.proxy.doParticlesSimple("block_notallowed", this);
            return true;
        }
        return false;
    }

    protected void setBlockTags(Block block, int meta) {
        Vec3d v = this.func_70902_q().func_70040_Z();
        this.stateTags = OutfoxResources.blockStateToHashMap(block.getStateForPlacement(this.field_70170_p, this.func_180425_c(), this.func_70902_q().func_174811_aO(), (float)v.field_72450_a, (float)v.field_72448_b, (float)v.field_72449_c, meta, this.func_70902_q(), this.func_70902_q().func_184600_cs()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeFoxIsShaking = 0.0f;
            this.prevTimeFoxIsShaking = 0.0f;
        } else if (id == 9) {
            Vec3d v = Vec3d.func_189986_a((float)0.0f, (float)this.func_70079_am());
            Outfox.proxy.doParticleEffect("searching", this, this.field_70165_t + v.field_72450_a * 0.8, this.func_174813_aQ().field_72338_b + 0.6, this.field_70161_v + v.field_72449_c * 0.8, 0.0, 0.05, 0.0);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected ItemStack getStolenItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(STOLEN_ITEM);
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isFoxWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    protected float getShadingWhileWet(float partialTicks) {
        return 0.75f + (this.prevTimeFoxIsShaking + (this.timeFoxIsShaking - this.prevTimeFoxIsShaking) * partialTicks) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    protected float getShakeAngle(float partialTicks, float offset) {
        float f = (this.prevTimeFoxIsShaking + (this.timeFoxIsShaking - this.prevTimeFoxIsShaking) * partialTicks + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    static class PathFinderTweakable<T extends NodeProcessor>
    extends PathFinder {
        private final PathPoint[] pathOptions;
        private final PathHeap path;
        private final Set<PathPoint> closedSet;
        private final NodeProcessor nodeProcessor;

        public PathFinderTweakable(NodeProcessor processorIn) {
            super(processorIn);
            this.pathOptions = new PathPoint[OutfoxConfig.search.search_waypoints];
            this.path = new PathHeap();
            this.closedSet = Sets.newHashSet();
            this.nodeProcessor = processorIn;
        }

        @Nullable
        public Path func_186336_a(IBlockAccess worldIn, EntityLiving entitylivingIn, BlockPos targetPos, float maxDistance) {
            return this.findPath(worldIn, entitylivingIn, (float)targetPos.func_177958_n() + 0.5f, (float)targetPos.func_177956_o() + 0.5f, (float)targetPos.func_177952_p() + 0.5f, maxDistance);
        }

        @Nullable
        private Path findPath(IBlockAccess worldIn, EntityLiving entitylivingIn, double x, double y, double z, float maxDistance) {
            this.path.func_75848_a();
            this.nodeProcessor.func_186315_a(worldIn, entitylivingIn);
            PathPoint pathpoint = this.nodeProcessor.func_186318_b();
            PathPoint pathpoint1 = this.nodeProcessor.func_186325_a(x, y, z);
            Path path = this.findPath(pathpoint, pathpoint1, maxDistance);
            this.nodeProcessor.func_176163_a();
            return path;
        }

        @Nullable
        private Path findPath(PathPoint pathFrom, PathPoint pathTo, float maxDistance) {
            pathFrom.field_75836_e = 0.0f;
            pathFrom.field_75834_g = pathFrom.field_75833_f = pathFrom.func_186281_c(pathTo);
            this.path.func_75848_a();
            this.closedSet.clear();
            this.path.func_75849_a(pathFrom);
            PathPoint pathpoint = pathFrom;
            int i = 0;
            while (!this.path.func_75845_e() && ++i < 200) {
                PathPoint pathpoint1 = this.path.func_75844_c();
                if (pathpoint1.equals((Object)pathTo)) {
                    pathpoint = pathTo;
                    break;
                }
                if (pathpoint1.func_186281_c(pathTo) < pathpoint.func_186281_c(pathTo)) {
                    pathpoint = pathpoint1;
                }
                pathpoint1.field_75842_i = true;
                int j = this.nodeProcessor.func_186320_a(this.pathOptions, pathpoint1, pathTo, maxDistance);
                for (int k = 0; k < j; ++k) {
                    PathPoint pathpoint2 = this.pathOptions[k];
                    float f = pathpoint1.func_186281_c(pathpoint2);
                    pathpoint2.field_186284_j = pathpoint1.field_186284_j + f;
                    pathpoint2.field_186285_k = f + pathpoint2.field_186286_l;
                    float f1 = pathpoint1.field_75836_e + pathpoint2.field_186285_k;
                    if (!(pathpoint2.field_186284_j < maxDistance) || pathpoint2.func_75831_a() && !(f1 < pathpoint2.field_75836_e)) continue;
                    pathpoint2.field_75841_h = pathpoint1;
                    pathpoint2.field_75836_e = f1;
                    pathpoint2.field_75833_f = pathpoint2.func_186281_c(pathTo) + pathpoint2.field_186286_l;
                    if (pathpoint2.func_75831_a()) {
                        this.path.func_75850_a(pathpoint2, pathpoint2.field_75836_e + pathpoint2.field_75833_f);
                        continue;
                    }
                    pathpoint2.field_75834_g = pathpoint2.field_75836_e + pathpoint2.field_75833_f;
                    this.path.func_75849_a(pathpoint2);
                }
            }
            if (pathpoint == pathFrom) {
                return null;
            }
            Path path = this.createPath(pathFrom, pathpoint);
            return path;
        }

        private Path createPath(PathPoint start, PathPoint end) {
            int i = 1;
            PathPoint p = end;
            while (p.field_75841_h != null) {
                ++i;
                p = p.field_75841_h;
            }
            PathPoint[] path = new PathPoint[i];
            PathPoint p2 = end;
            path[--i] = end;
            while (p2.field_75841_h != null) {
                p2 = p2.field_75841_h;
                path[--i] = p2;
            }
            return new Path(path);
        }
    }

    static class PathNavigateTweakable<T extends EntityLiving, U extends World>
    extends PathNavigateGround {
        private final EntityFox fox;

        public PathNavigateTweakable(EntityLiving entitylivingIn, World worldIn) {
            super(entitylivingIn, worldIn);
            this.fox = (EntityFox)entitylivingIn;
        }

        protected PathFinder func_179679_a() {
            this.field_179695_a = new WalkNodeProcessor();
            this.field_179695_a.func_186317_a(true);
            return new PathFinderTweakable(this.field_179695_a);
        }

        public boolean func_75484_a(@Nullable Path pathentityIn, double speedIn) {
            return this.fox.func_70661_as().func_75484_a(pathentityIn, speedIn);
        }
    }

    static class AISit<T extends EntityTameable>
    extends EntityAISit {
        private final EntityFox fox;

        public AISit(EntityFox foxIn) {
            super((EntityTameable)foxIn);
            this.fox = foxIn;
        }

        public boolean func_75250_a() {
            if (!OutfoxConfig.stealing.sit_override) {
                return super.func_75250_a();
            }
            return this.fox.func_70902_q() != null && this.fox.func_70902_q().func_70643_av() == null ? super.func_75250_a() : this.fox.func_70906_o();
        }
    }
}

