/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu.logo;

import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.util.Strings;
import shadows.menu.ExtendedMenuScreen;
import shadows.menu.buttons.AnchorPoint;
import shadows.placebo.config.Configuration;

public class Logo {
    protected ResourceLocation texture;
    protected final int xOff;
    protected final int yOff;
    protected final int width;
    protected final int height;
    protected final int texWidth;
    protected final int texHeight;
    protected final AnchorPoint anchor;

    public Logo(int xOff, int yOff, int width, int height, int texWidth, int texHeight, ResourceLocation texture, AnchorPoint anchor) {
        this.xOff = xOff;
        this.yOff = yOff;
        this.width = width;
        this.height = height;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.texture = texture;
        this.anchor = anchor;
    }

    public void draw(ExtendedMenuScreen screen) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.texture);
        GlStateManager.disableDepthTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)this.anchor.getX(screen), (float)this.anchor.getY(screen), (float)0.0f);
        GlStateManager.scaled((double)((double)this.width / (double)this.texWidth), (double)((double)this.height / (double)this.texHeight), (double)1.0);
        Screen.blit((int)this.xOff, (int)this.yOff, (float)0.0f, (float)0.0f, (int)this.texWidth, (int)this.texHeight, (int)this.texWidth, (int)this.texHeight);
        GlStateManager.popMatrix();
        GlStateManager.enableDepthTest();
    }

    @Nullable
    public static Logo read(Configuration cfg) {
        String tex = cfg.getString("Texture Path", "logo", "", "The location of the logo texture.  Must be a png file.  Should contain the extension.");
        int xOff = cfg.getInt("X Offset", "logo", 0, -500000, 500000, "The X offset of the logo.");
        int yOff = cfg.getInt("Y Offset", "logo", 0, -500000, 500000, "The Y offset of the logo.");
        int width = cfg.getInt("Width", "logo", 0, 0, 500000, "The width of the logo.");
        int height = cfg.getInt("Height", "logo", 0, 0, 500000, "The height of the logo.");
        int texWidth = cfg.getInt("Texture Width", "logo", 0, 0, 500000, "The width of the logo's texture.");
        int texHeight = cfg.getInt("Texture Height", "logo", 0, 0, 500000, "The height of the logo's texture.");
        AnchorPoint anchor = AnchorPoint.valueOf(cfg.getString("Anchor Point", "logo", "DEFAULT_LOGO", "The anchor point of the logo.  The types of anchor points are available on the wiki."));
        if (Strings.isBlank((String)tex)) {
            return null;
        }
        return new Logo(xOff, yOff, width, height, texWidth, texHeight, new ResourceLocation(tex), anchor);
    }
}

