/*
 * Decompiled with CFR 0.152.
 */
package quarris.pickpocketer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class InventoryMob
implements IInventory,
INBTSerializable<NBTTagCompound> {
    private static final Field rand = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_70146_Z");
    private static final Field deathLootTable = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_184659_bA");
    private static final Field deathLootTableSeed = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_184653_bB");
    private static final Method getLootTable = ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"func_184647_J", ResourceLocation.class, (Class[])new Class[0]);
    public final EntityLiving mob;
    public NonNullList<ItemStack> inventory;

    public InventoryMob(EntityLiving mob) {
        this.mob = mob;
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    }

    public void populateMobInventory(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.mob.getEntityData().func_74764_b("PP:Inventory")) {
            this.deserializeNBT(this.mob.getEntityData().func_74775_l("PP:Inventory"));
            return;
        }
        try {
            ResourceLocation resourcelocation = (ResourceLocation)deathLootTable.get(this.mob);
            if (resourcelocation == null) {
                resourcelocation = (ResourceLocation)getLootTable.invoke((Object)this.mob, new Object[0]);
            }
            if (resourcelocation != null) {
                LootTable loottable = this.mob.field_70170_p.func_184146_ak().func_186521_a(resourcelocation);
                DamageSource source = DamageSource.func_76365_a((EntityPlayer)player);
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.mob.field_70170_p).func_186472_a((Entity)this.mob).func_186473_a(source).func_186470_a(player).func_186469_a(player.func_184817_da());
                List loot = loottable.func_186462_a(deathLootTableSeed.getFloat(this.mob) == 0.0f ? (Random)rand.get(this.mob) : new Random(deathLootTableSeed.getLong(this.mob)), lootcontext$builder.func_186471_a());
                int size = Math.min(5, loot.size());
                for (int i = 0; i < size; ++i) {
                    this.func_70299_a(i, (ItemStack)loot.get(i));
                }
                this.save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int func_70302_i_() {
        return 11;
    }

    public boolean func_191420_l() {
        if (!this.inventory.isEmpty()) {
            for (ItemStack stack : this.mob.func_184209_aF()) {
                if (stack.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        this.validateIndex(index);
        if (index < 5) {
            return (ItemStack)this.inventory.get(index);
        }
        return this.mob.func_184582_a(EntityEquipmentSlot.values()[index - 5]);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack.func_190916_E() < count) {
            return stack.func_77946_l();
        }
        int remain = stack.func_190916_E() - count;
        stack.func_190920_e(remain);
        ItemStack ret = stack.func_77946_l();
        ret.func_190920_e(count);
        return ret;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (index < 5) {
            this.inventory.set(index, (Object)ItemStack.field_190927_a);
        } else {
            EntityEquipmentSlot slot = EntityEquipmentSlot.values()[index - 5];
            this.mob.func_184201_a(slot, ItemStack.field_190927_a);
        }
        this.save();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index < 5) {
            this.inventory.set(index, (Object)stack);
        } else {
            EntityEquipmentSlot slot = EntityEquipmentSlot.values()[index - 5];
            this.mob.func_184201_a(slot, stack);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public void save() {
        this.mob.getEntityData().func_74782_a("PP:Inventory", (NBTBase)this.serializeNBT());
    }

    public boolean func_70300_a(EntityPlayer player) {
        return (double)this.mob.func_70032_d((Entity)player) <= 3.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return this.func_145748_c_().func_150254_d();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return this.mob.func_145748_c_();
    }

    private void validateIndex(int index) {
        if (index >= this.func_70302_i_()) {
            throw new IllegalArgumentException("Invalid slot index " + index + " for mob " + this.mob);
        }
    }

    public NBTTagCompound serializeNBT() {
        return ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), this.inventory);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.inventory);
    }
}

