/*
 * Decompiled with CFR 0.152.
 */
package quarris.pickpocketer;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import quarris.pickpocketer.ModConfig;
import quarris.pickpocketer.PickPocketer;

@Mod.EventBusSubscriber(modid="pickpocketer")
public class StealingManager {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getTarget() instanceof EntityLivingBase) {
            EntityPlayer player = event.getEntityPlayer();
            EntityLivingBase target = (EntityLivingBase)event.getTarget();
            for (String entityName : ModConfig.blacklist) {
                if (!EntityRegistry.getEntry(target.getClass()).getRegistryName().toString().equals(entityName)) continue;
                return;
            }
            if (!player.func_70093_af() || target instanceof EntityPlayer && ((EntityPlayer)target).func_184812_l_()) {
                return;
            }
            StealingAttemptResult result = StealingManager.canStealFrom(player, target);
            if (result == StealingAttemptResult.INV_FULL) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("stealing.attempt.inv_full", new Object[0]), true);
            } else if (result == StealingAttemptResult.NOT_HIDDEN) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("stealing.attempt.not_hidden", new Object[0]), true);
            } else if (result == StealingAttemptResult.COOLDOWN) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("stealing.attempt.cooldown", new Object[0]), true);
            } else if (result == StealingAttemptResult.CAN_STEAL) {
                StealingManager.openStealingContainer(player, target);
            }
        }
    }

    private static void openStealingContainer(EntityPlayer thief, EntityLivingBase target) {
        thief.openGui((Object)"pickpocketer", 0, thief.field_70170_p, target.func_145782_y(), 0, 0);
    }

    public static StealingAttemptResult canStealFrom(EntityPlayer thief, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && thief.getEntityData().func_74764_b("PP:StolenTime") && thief.field_70170_p.func_82737_E() <= thief.getEntityData().func_74763_f("PP:StolenTime") + (long)ModConfig.cooldown) {
            return StealingAttemptResult.COOLDOWN;
        }
        if (StealingManager.isHiddenFrom(thief, entity)) {
            if (thief.field_71071_by.field_70462_a.stream().anyMatch(ItemStack::func_190926_b)) {
                return StealingAttemptResult.CAN_STEAL;
            }
            return StealingAttemptResult.INV_FULL;
        }
        return StealingAttemptResult.NOT_HIDDEN;
    }

    public static boolean isHiddenFrom(EntityPlayer thief, EntityLivingBase entity) {
        return StealingManager.isBehind(thief, entity);
    }

    private static boolean isBehind(EntityPlayer thief, EntityLivingBase entity) {
        Vec3d directionToPlayer = entity.func_174791_d().func_178788_d(thief.func_174791_d());
        Vec3d look = PickPocketer.proxy.getEntityLook(entity);
        return look.func_72430_b(directionToPlayer) > 0.0;
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), 0.0, (double)(f * f2));
    }

    public static enum StealingAttemptResult {
        CAN_STEAL,
        INV_FULL,
        NOT_HIDDEN,
        COOLDOWN;

    }
}

