/*
 * Decompiled with CFR 0.152.
 */
package com.abneyonline.platter;

import com.abneyonline.platter.tile.AcaciaPlatterTile;
import com.abneyonline.platter.tile.BirchPlatterTile;
import com.abneyonline.platter.tile.DarkOakPlatterTile;
import com.abneyonline.platter.tile.JunglePlatterTile;
import com.abneyonline.platter.tile.OakPlatterTile;
import com.abneyonline.platter.tile.PlatterTile;
import com.abneyonline.platter.tile.SprucePlatterTile;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PlatterBlock
extends Block {
    private static final VoxelShape RENDER_SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);

    public PlatterBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.0f).harvestLevel(0).harvestTool(ToolType.AXE));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        if (!worldIn.func_201670_d()) {
            ItemStack playerHand = player.func_184614_ca();
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                if (player.func_213453_ef()) {
                    for (int a = h.getSlots() - 1; a >= 0; --a) {
                        ItemStack found = h.getStackInSlot(a);
                        if (found.func_190926_b()) continue;
                        ItemStack toRemove = h.extractItem(a, found.func_190916_E(), false);
                        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)toRemove);
                        tileEntity.func_70296_d();
                        worldIn.func_184138_a(pos, state, state, 2);
                        return;
                    }
                } else {
                    ItemStack toInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)playerHand.func_77946_l(), (boolean)false);
                    if (!player.func_184812_l_()) {
                        playerHand.func_190918_g(playerHand.func_190916_E() - toInsert.func_190916_E());
                    }
                    tileEntity.func_70296_d();
                    worldIn.func_184138_a(pos, state, state, 2);
                }
            });
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.func_201670_d()) {
            ArrayList toDrop = new ArrayList();
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                for (int a = 0; a < h.getSlots(); ++a) {
                    if (h.getStackInSlot(a).func_190926_b()) continue;
                    toDrop.add(h.getStackInSlot(a).func_77946_l());
                }
            });
            for (int a = 0; a < toDrop.size(); ++a) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((ItemStack)toDrop.get(a)));
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        String toCheck = this.getRegistryName().func_110623_a();
        if (toCheck.contains("oak") && !toCheck.contains("dark")) {
            return new OakPlatterTile();
        }
        if (toCheck.contains("spruce")) {
            return new SprucePlatterTile();
        }
        if (toCheck.contains("birch")) {
            return new BirchPlatterTile();
        }
        if (toCheck.contains("jungle")) {
            return new JunglePlatterTile();
        }
        if (toCheck.contains("acacia")) {
            return new AcaciaPlatterTile();
        }
        if (toCheck.contains("dark")) {
            return new DarkOakPlatterTile();
        }
        return new PlatterTile();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        boolean toReturn = false;
        LazyOptional handler = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (handler.isPresent()) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((IItemHandler)handler.orElse(null)));
        }
        return 0;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return RENDER_SHAPE;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return RENDER_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return RENDER_SHAPE;
    }
}

