/*
 * Decompiled with CFR 0.152.
 */
package com.abneyonline.platter.network;

import com.abneyonline.platter.helpers.HungerHelper;
import com.abneyonline.platter.network.MessageExhaustionSync;
import com.abneyonline.platter.network.MessageSaturationSync;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class SyncHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("platter", "sync")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();

    public static void init() {
        CHANNEL.registerMessage(1, MessageExhaustionSync.class, MessageExhaustionSync::encode, MessageExhaustionSync::decode, MessageExhaustionSync::handle);
        CHANNEL.registerMessage(2, MessageSaturationSync.class, MessageSaturationSync::encode, MessageSaturationSync::decode, MessageSaturationSync::handle);
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        Float lastSaturationLevel = lastSaturationLevels.get(player.func_110124_au());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.func_110124_au());
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != player.func_71024_bL().func_75115_e()) {
            MessageSaturationSync msg = new MessageSaturationSync(player.func_71024_bL().func_75115_e());
            CHANNEL.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            lastSaturationLevels.put(player.func_110124_au(), Float.valueOf(player.func_71024_bL().func_75115_e()));
        }
        float exhaustionLevel = HungerHelper.getExhaustion((PlayerEntity)player);
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            MessageExhaustionSync msg = new MessageExhaustionSync(exhaustionLevel);
            CHANNEL.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            lastExhaustionLevels.put(player.func_110124_au(), Float.valueOf(exhaustionLevel));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        lastSaturationLevels.remove(event.getPlayer().func_110124_au());
        lastExhaustionLevels.remove(event.getPlayer().func_110124_au());
    }
}

