/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.optifine.BetterGrass;
import net.optifine.BlockDir;
import net.optifine.Config;
import net.optifine.ConnectedProperties;
import net.optifine.ConnectedTexturesCompact;
import net.optifine.config.Matches;
import net.optifine.model.BlockModelUtils;
import net.optifine.model.ListQuadsOverlay;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.util.BiomeUtils;
import net.optifine.util.BlockUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TileEntityUtils;

public class ConnectedTextures {
    private static Map[] spriteQuadMaps = null;
    private static Map[] spriteQuadFullMaps = null;
    private static Map[][] spriteQuadCompactMaps = null;
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] tileProperties = null;
    private static boolean multipass = false;
    protected static final int UNKNOWN = -1;
    protected static final int Y_NEG_DOWN = 0;
    protected static final int Y_POS_UP = 1;
    protected static final int Z_NEG_NORTH = 2;
    protected static final int Z_POS_SOUTH = 3;
    protected static final int X_NEG_WEST = 4;
    protected static final int X_POS_EAST = 5;
    private static final int Y_AXIS = 0;
    private static final int Z_AXIS = 1;
    private static final int X_AXIS = 2;
    public static final byj AIR_DEFAULT_STATE = bpi.a.p();
    private static eaj emptySprite = null;
    public static sm LOCATION_SPRITE_EMPTY = new sm("optifine/ctm/default/empty");
    private static final BlockDir[] SIDES_Y_NEG_DOWN = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.NORTH, BlockDir.SOUTH};
    private static final BlockDir[] SIDES_Y_POS_UP = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.SOUTH, BlockDir.NORTH};
    private static final BlockDir[] SIDES_Z_NEG_NORTH = new BlockDir[]{BlockDir.EAST, BlockDir.WEST, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_Z_POS_SOUTH = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_X_NEG_WEST = new BlockDir[]{BlockDir.NORTH, BlockDir.SOUTH, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_X_POS_EAST = new BlockDir[]{BlockDir.SOUTH, BlockDir.NORTH, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_Z_NEG_NORTH_Z_AXIS = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.UP, BlockDir.DOWN};
    private static final BlockDir[] SIDES_X_POS_EAST_X_AXIS = new BlockDir[]{BlockDir.NORTH, BlockDir.SOUTH, BlockDir.UP, BlockDir.DOWN};
    private static final BlockDir[] EDGES_Y_NEG_DOWN = new BlockDir[]{BlockDir.NORTH_EAST, BlockDir.NORTH_WEST, BlockDir.SOUTH_EAST, BlockDir.SOUTH_WEST};
    private static final BlockDir[] EDGES_Y_POS_UP = new BlockDir[]{BlockDir.SOUTH_EAST, BlockDir.SOUTH_WEST, BlockDir.NORTH_EAST, BlockDir.NORTH_WEST};
    private static final BlockDir[] EDGES_Z_NEG_NORTH = new BlockDir[]{BlockDir.DOWN_WEST, BlockDir.DOWN_EAST, BlockDir.UP_WEST, BlockDir.UP_EAST};
    private static final BlockDir[] EDGES_Z_POS_SOUTH = new BlockDir[]{BlockDir.DOWN_EAST, BlockDir.DOWN_WEST, BlockDir.UP_EAST, BlockDir.UP_WEST};
    private static final BlockDir[] EDGES_X_NEG_WEST = new BlockDir[]{BlockDir.DOWN_SOUTH, BlockDir.DOWN_NORTH, BlockDir.UP_SOUTH, BlockDir.UP_NORTH};
    private static final BlockDir[] EDGES_X_POS_EAST = new BlockDir[]{BlockDir.DOWN_NORTH, BlockDir.DOWN_SOUTH, BlockDir.UP_NORTH, BlockDir.UP_SOUTH};
    private static final BlockDir[] EDGES_Z_NEG_NORTH_Z_AXIS = new BlockDir[]{BlockDir.UP_EAST, BlockDir.UP_WEST, BlockDir.DOWN_EAST, BlockDir.DOWN_WEST};
    private static final BlockDir[] EDGES_X_POS_EAST_X_AXIS = new BlockDir[]{BlockDir.UP_SOUTH, BlockDir.UP_NORTH, BlockDir.DOWN_SOUTH, BlockDir.DOWN_NORTH};
    public static final eaj SPRITE_DEFAULT = new eaj(new sm("default"));
    private static final Random RANDOM = new Random(0L);

    public static drn[] getConnectedTexture(bje blockAccess, byj blockState, fk blockPos, drn quad, RenderEnv renderEnv) {
        eaj spriteIn = quad.getSprite();
        if (spriteIn == null) {
            return renderEnv.getArrayQuadsCtm(quad);
        }
        bph block = blockState.d();
        if (ConnectedTextures.skipConnectedTexture((bjg)blockAccess, blockState, blockPos, quad, renderEnv)) {
            quad = ConnectedTextures.getQuad(emptySprite, quad);
            return renderEnv.getArrayQuadsCtm(quad);
        }
        fp side = quad.e();
        drn[] quads = ConnectedTextures.getConnectedTextureMultiPass(blockAccess, blockState, blockPos, side, quad, renderEnv);
        return quads;
    }

    private static boolean skipConnectedTexture(bjg blockAccess, byj blockState, fk blockPos, drn quad, RenderEnv renderEnv) {
        bph block = blockState.d();
        if (block instanceof bsd) {
            bdj colorNeighbour;
            bdj color;
            fp face = quad.e();
            if (face != fp.b && face != fp.a) {
                return false;
            }
            if (!quad.isFaceQuad()) {
                return false;
            }
            fk posNeighbour = blockPos.a(quad.e());
            byj stateNeighbour = blockAccess.d_(posNeighbour);
            if (stateNeighbour.d() != block) {
                return false;
            }
            bph blockNeighbour = stateNeighbour.d();
            if (block instanceof bur && blockNeighbour instanceof bur && (color = ((bur)block).a()) != (colorNeighbour = ((bur)blockNeighbour).a())) {
                return false;
            }
            double midX = quad.getMidX();
            if (midX < 0.4) {
                if (((Boolean)stateNeighbour.c((bzm)bql.d)).booleanValue()) {
                    return true;
                }
            } else if (midX > 0.6) {
                if (((Boolean)stateNeighbour.c((bzm)bql.b)).booleanValue()) {
                    return true;
                }
            } else {
                double midZ = quad.getMidZ();
                if (midZ < 0.4) {
                    if (((Boolean)stateNeighbour.c((bzm)bql.a)).booleanValue()) {
                        return true;
                    }
                } else if (midZ > 0.6) {
                    if (((Boolean)stateNeighbour.c((bzm)bql.c)).booleanValue()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    protected static drn[] getQuads(eaj sprite, drn quadIn, RenderEnv renderEnv) {
        if (sprite == null) {
            return null;
        }
        if (sprite == SPRITE_DEFAULT) {
            return renderEnv.getArrayQuadsCtm(quadIn);
        }
        drn quad = ConnectedTextures.getQuad(sprite, quadIn);
        drn[] quads = renderEnv.getArrayQuadsCtm(quad);
        return quads;
    }

    private static synchronized drn getQuad(eaj sprite, drn quadIn) {
        drn quad;
        if (spriteQuadMaps == null) {
            return quadIn;
        }
        int spriteIndex = sprite.getIndexInMap();
        if (spriteIndex < 0 || spriteIndex >= spriteQuadMaps.length) {
            return quadIn;
        }
        IdentityHashMap<drn, drn> quadMap = spriteQuadMaps[spriteIndex];
        if (quadMap == null) {
            ConnectedTextures.spriteQuadMaps[spriteIndex] = quadMap = new IdentityHashMap<drn, drn>(1);
        }
        if ((quad = (drn)quadMap.get(quadIn)) == null) {
            quad = ConnectedTextures.makeSpriteQuad(quadIn, sprite);
            quadMap.put(quadIn, quad);
        }
        return quad;
    }

    private static synchronized drn getQuadFull(eaj sprite, drn quadIn, int tintIndex) {
        fp face;
        drn quad;
        if (spriteQuadFullMaps == null) {
            return null;
        }
        if (sprite == null) {
            return null;
        }
        int spriteIndex = sprite.getIndexInMap();
        if (spriteIndex < 0 || spriteIndex >= spriteQuadFullMaps.length) {
            return null;
        }
        EnumMap<fp, drn> quadMap = spriteQuadFullMaps[spriteIndex];
        if (quadMap == null) {
            ConnectedTextures.spriteQuadFullMaps[spriteIndex] = quadMap = new EnumMap<fp, drn>(fp.class);
        }
        if ((quad = (drn)quadMap.get(face = quadIn.e())) == null) {
            quad = BlockModelUtils.makeBakedQuad(face, sprite, tintIndex);
            quadMap.put(face, quad);
        }
        return quad;
    }

    private static drn makeSpriteQuad(drn quad, eaj sprite) {
        int[] data = (int[])quad.b().clone();
        eaj spriteFrom = quad.getSprite();
        for (int i2 = 0; i2 < 4; ++i2) {
            ConnectedTextures.fixVertex(data, i2, spriteFrom, sprite);
        }
        drn bq = new drn(data, quad.d(), quad.e(), sprite);
        return bq;
    }

    private static void fixVertex(int[] data, int vertex, eaj spriteFrom, eaj spriteTo) {
        int mul = data.length / 4;
        int pos = mul * vertex;
        float u = Float.intBitsToFloat(data[pos + 4]);
        float v = Float.intBitsToFloat(data[pos + 4 + 1]);
        double su16 = spriteFrom.getSpriteU16(u);
        double sv16 = spriteFrom.getSpriteV16(v);
        data[pos + 4] = Float.floatToRawIntBits(spriteTo.a(su16));
        data[pos + 4 + 1] = Float.floatToRawIntBits(spriteTo.b(sv16));
    }

    private static drn[] getConnectedTextureMultiPass(bje blockAccess, byj blockState, fk blockPos, fp side, drn quad, RenderEnv renderEnv) {
        drn[] quads = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, quad, true, 0, renderEnv);
        if (!multipass) {
            return quads;
        }
        if (quads.length == 1 && quads[0] == quad) {
            return quads;
        }
        List<drn> listQuads = renderEnv.getListQuadsCtmMultipass(quads);
        for (int q = 0; q < listQuads.size(); ++q) {
            drn[] newMpQuads;
            drn newQuad;
            drn mpQuad = newQuad = listQuads.get(q);
            for (int i2 = 0; i2 < 3 && (newMpQuads = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, mpQuad, false, i2 + 1, renderEnv)).length == 1 && newMpQuads[0] != mpQuad; ++i2) {
                mpQuad = newMpQuads[0];
            }
            listQuads.set(q, mpQuad);
        }
        for (int i3 = 0; i3 < quads.length; ++i3) {
            quads[i3] = listQuads.get(i3);
        }
        return quads;
    }

    public static drn[] getConnectedTextureSingle(bje blockAccess, byj blockState, fk blockPos, fp facing, drn quad, boolean checkBlocks, int pass, RenderEnv renderEnv) {
        int blockId;
        drn[] newQuads;
        ConnectedProperties cp;
        int i2;
        int side;
        ConnectedProperties[] cps;
        int iconId;
        bph block = blockState.d();
        eaj icon = quad.getSprite();
        if (tileProperties != null && (iconId = icon.getIndexInMap()) >= 0 && iconId < tileProperties.length && (cps = tileProperties[iconId]) != null) {
            side = ConnectedTextures.getSide(facing);
            for (i2 = 0; i2 < cps.length; ++i2) {
                cp = cps[i2];
                if (cp == null || !cp.matchesBlockId(blockState.getBlockId()) || (newQuads = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, quad, pass, renderEnv)) == null) continue;
                return newQuads;
            }
        }
        if (blockProperties != null && checkBlocks && (blockId = renderEnv.getBlockId()) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null) {
            side = ConnectedTextures.getSide(facing);
            for (i2 = 0; i2 < cps.length; ++i2) {
                cp = cps[i2];
                if (cp == null || !cp.matchesIcon(icon) || (newQuads = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, quad, pass, renderEnv)) == null) continue;
                return newQuads;
            }
        }
        return renderEnv.getArrayQuadsCtm(quad);
    }

    public static int getSide(fp facing) {
        if (facing == null) {
            return -1;
        }
        switch (facing) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case f: {
                return 5;
            }
            case e: {
                return 4;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        return -1;
    }

    private static fp getFacing(int side) {
        switch (side) {
            case 0: {
                return fp.a;
            }
            case 1: {
                return fp.b;
            }
            case 5: {
                return fp.f;
            }
            case 4: {
                return fp.e;
            }
            case 2: {
                return fp.c;
            }
            case 3: {
                return fp.d;
            }
        }
        return fp.b;
    }

    private static drn[] getConnectedTexture(ConnectedProperties cp, bje blockAccess, byj blockState, fk blockPos, int side, drn quad, int pass, RenderEnv renderEnv) {
        String name;
        bkt blockBiome;
        int vertAxis = 0;
        int metadata = blockState.getMetadata();
        bph block = blockState.d();
        if (block instanceof btt) {
            vertAxis = ConnectedTextures.getPillarAxis(blockState);
        }
        if (!cp.matchesBlock(blockState.getBlockId(), metadata)) {
            return null;
        }
        if (side >= 0 && cp.faces != 63) {
            int sideCheck = side;
            if (vertAxis != 0) {
                sideCheck = ConnectedTextures.fixSideByAxis(side, vertAxis);
            }
            if ((1 << sideCheck & cp.faces) == 0) {
                return null;
            }
        }
        int y = blockPos.p();
        if (cp.heights != null && !cp.heights.isInRange(y)) {
            return null;
        }
        if (cp.biomes != null && !cp.matchesBiome(blockBiome = BiomeUtils.getBiome(blockAccess, blockPos))) {
            return null;
        }
        if (cp.nbtName != null && !cp.nbtName.matchesValue(name = TileEntityUtils.getTileEntityName((bjg)blockAccess, blockPos))) {
            return null;
        }
        eaj icon = quad.getSprite();
        switch (cp.method) {
            case 10: {
                if (pass != 0) break;
                return ConnectedTextures.getConnectedTextureCtmCompact(cp, (bjg)blockAccess, blockState, blockPos, vertAxis, side, quad, metadata, renderEnv);
            }
            case 1: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureCtm(cp, (bjg)blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv), quad, renderEnv);
            }
            case 2: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureHorizontal(cp, (bjg)blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 6: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureVertical(cp, (bjg)blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 3: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureTop(cp, (bjg)blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 4: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureRandom(cp, (bjg)blockAccess, blockState, blockPos, side), quad, renderEnv);
            }
            case 5: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureRepeat(cp, blockPos, side), quad, renderEnv);
            }
            case 7: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureFixed(cp), quad, renderEnv);
            }
            case 8: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureHorizontalVertical(cp, (bjg)blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 9: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureVerticalHorizontal(cp, (bjg)blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 11: {
                return ConnectedTextures.getConnectedTextureOverlay(cp, (bjg)blockAccess, blockState, blockPos, vertAxis, side, quad, metadata, renderEnv);
            }
            case 12: {
                return ConnectedTextures.getConnectedTextureOverlayFixed(cp, quad, renderEnv);
            }
            case 13: {
                return ConnectedTextures.getConnectedTextureOverlayRandom(cp, (bjg)blockAccess, blockState, blockPos, side, quad, renderEnv);
            }
            case 14: {
                return ConnectedTextures.getConnectedTextureOverlayRepeat(cp, blockPos, side, quad, renderEnv);
            }
            case 15: {
                return ConnectedTextures.getConnectedTextureOverlayCtm(cp, (bjg)blockAccess, blockState, blockPos, vertAxis, side, quad, metadata, renderEnv);
            }
        }
        return null;
    }

    private static int fixSideByAxis(int side, int vertAxis) {
        switch (vertAxis) {
            case 0: {
                return side;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return side;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 0;
                    }
                }
                return side;
            }
        }
        return side;
    }

    private static int getPillarAxis(byj blockState) {
        fp.a axis = (fp.a)blockState.c((bzm)btt.a);
        switch (axis) {
            case a: {
                return 2;
            }
            case c: {
                return 1;
            }
        }
        return 0;
    }

    private static eaj getConnectedTextureRandom(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int face = side / cp.symmetry * cp.symmetry;
        if (cp.linked) {
            fk posDown = blockPos.c();
            byj bsDown = blockAccess.d_(posDown);
            while (bsDown.d() == blockState.d() && (posDown = (blockPos = posDown).c()).p() >= 0) {
                bsDown = blockAccess.d_(posDown);
            }
        }
        int rand = Config.getRandom(blockPos, face) & Integer.MAX_VALUE;
        for (int i2 = 0; i2 < cp.randomLoops; ++i2) {
            rand = Config.intHash(rand);
        }
        int index = 0;
        if (cp.weights == null) {
            index = rand % cp.tileIcons.length;
        } else {
            int randWeight = rand % cp.sumAllWeights;
            int[] sumWeights = cp.sumWeights;
            for (int i3 = 0; i3 < sumWeights.length; ++i3) {
                if (randWeight >= sumWeights[i3]) continue;
                index = i3;
                break;
            }
        }
        return cp.tileIcons[index];
    }

    private static eaj getConnectedTextureFixed(ConnectedProperties cp) {
        return cp.tileIcons[0];
    }

    private static eaj getConnectedTextureRepeat(ConnectedProperties cp, fk blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int x = blockPos.o();
        int y = blockPos.p();
        int z = blockPos.q();
        int nx = 0;
        int ny = 0;
        switch (side) {
            case 0: {
                nx = x;
                ny = -z - 1;
                break;
            }
            case 1: {
                nx = x;
                ny = z;
                break;
            }
            case 2: {
                nx = -x - 1;
                ny = -y;
                break;
            }
            case 3: {
                nx = x;
                ny = -y;
                break;
            }
            case 4: {
                nx = z;
                ny = -y;
                break;
            }
            case 5: {
                nx = -z - 1;
                ny = -y;
            }
        }
        ny %= cp.height;
        if ((nx %= cp.width) < 0) {
            nx += cp.width;
        }
        if (ny < 0) {
            ny += cp.height;
        }
        int index = ny * cp.width + nx;
        return cp.tileIcons[index];
    }

    private static eaj getConnectedTextureCtm(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, eaj icon, int metadata, RenderEnv renderEnv) {
        int index = ConnectedTextures.getConnectedTextureCtmIndex(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv);
        return cp.tileIcons[index];
    }

    private static synchronized drn[] getConnectedTextureCtmCompact(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, drn quad, int metadata, RenderEnv renderEnv) {
        eaj icon = quad.getSprite();
        int index = ConnectedTextures.getConnectedTextureCtmIndex(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv);
        return ConnectedTexturesCompact.getConnectedTextureCtmCompact(index, cp, side, quad, renderEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static drn[] getConnectedTextureOverlay(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, drn quad, int metadata, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        eaj icon = quad.getSprite();
        BlockDir[] dirSides = ConnectedTextures.getSideDirections(side, vertAxis);
        boolean[] sides = renderEnv.getBorderFlags();
        for (int i2 = 0; i2 < 4; ++i2) {
            sides[i2] = ConnectedTextures.isNeighbourOverlay(cp, blockAccess, blockState, dirSides[i2].offset(blockPos), side, icon, metadata);
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            if (sides[0] && sides[1] && sides[2] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[8], quad, cp.tintIndex), cp.tintBlockState);
                drn[] drnArray = null;
                return drnArray;
            }
            if (sides[0] && sides[1] && sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[5], quad, cp.tintIndex), cp.tintBlockState);
                drn[] drnArray = null;
                return drnArray;
            }
            if (sides[0] && sides[2] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[6], quad, cp.tintIndex), cp.tintBlockState);
                drn[] drnArray = null;
                return drnArray;
            }
            if (sides[1] && sides[2] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[12], quad, cp.tintIndex), cp.tintBlockState);
                drn[] drnArray = null;
                return drnArray;
            }
            if (sides[0] && sides[1] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[13], quad, cp.tintIndex), cp.tintBlockState);
                drn[] drnArray = null;
                return drnArray;
            }
            BlockDir[] dirEdges = ConnectedTextures.getEdgeDirections(side, vertAxis);
            boolean[] edges = renderEnv.getBorderFlags2();
            for (int i3 = 0; i3 < 4; ++i3) {
                edges[i3] = ConnectedTextures.isNeighbourOverlay(cp, blockAccess, blockState, dirEdges[i3].offset(blockPos), side, icon, metadata);
            }
            if (sides[1] && sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[3], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[3]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[16], quad, cp.tintIndex), cp.tintBlockState);
                }
                drn[] i3 = null;
                return i3;
            }
            if (sides[0] && sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[4], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[2]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[14], quad, cp.tintIndex), cp.tintBlockState);
                }
                drn[] i3 = null;
                return i3;
            }
            if (sides[1] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[10], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[1]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[2], quad, cp.tintIndex), cp.tintBlockState);
                }
                drn[] i3 = null;
                return i3;
            }
            if (sides[0] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[11], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[0]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[0], quad, cp.tintIndex), cp.tintBlockState);
                }
                drn[] i3 = null;
                return i3;
            }
            boolean[] sidesMatch = renderEnv.getBorderFlags3();
            for (int i4 = 0; i4 < 4; ++i4) {
                sidesMatch[i4] = ConnectedTextures.isNeighbourMatching(cp, blockAccess, blockState, dirSides[i4].offset(blockPos), side, icon, metadata);
            }
            if (sides[0]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[9], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (sides[1]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[7], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[1], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[15], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[0] && (sidesMatch[1] || sidesMatch[2]) && !sides[1] && !sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[0], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[1] && (sidesMatch[0] || sidesMatch[2]) && !sides[0] && !sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[2], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[2] && (sidesMatch[1] || sidesMatch[3]) && !sides[1] && !sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[14], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[3] && (sidesMatch[0] || sidesMatch[3]) && !sides[0] && !sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[16], quad, cp.tintIndex), cp.tintBlockState);
            }
            drn[] drnArray = null;
            return drnArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static drn[] getConnectedTextureOverlayFixed(ConnectedProperties cp, drn quad, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            eaj sprite = ConnectedTextures.getConnectedTextureFixed(cp);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            drn[] drnArray = null;
            return drnArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static drn[] getConnectedTextureOverlayRandom(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int side, drn quad, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            eaj sprite = ConnectedTextures.getConnectedTextureRandom(cp, blockAccess, blockState, blockPos, side);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            drn[] drnArray = null;
            return drnArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static drn[] getConnectedTextureOverlayRepeat(ConnectedProperties cp, fk blockPos, int side, drn quad, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            eaj sprite = ConnectedTextures.getConnectedTextureRepeat(cp, blockPos, side);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            drn[] drnArray = null;
            return drnArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static drn[] getConnectedTextureOverlayCtm(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, drn quad, int metadata, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            eaj sprite = ConnectedTextures.getConnectedTextureCtm(cp, blockAccess, blockState, blockPos, vertAxis, side, quad.getSprite(), metadata, renderEnv);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            drn[] drnArray = null;
            return drnArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    private static BlockDir[] getSideDirections(int side, int vertAxis) {
        switch (side) {
            case 0: {
                return SIDES_Y_NEG_DOWN;
            }
            case 1: {
                return SIDES_Y_POS_UP;
            }
            case 2: {
                if (vertAxis == 1) {
                    return SIDES_Z_NEG_NORTH_Z_AXIS;
                }
                return SIDES_Z_NEG_NORTH;
            }
            case 3: {
                return SIDES_Z_POS_SOUTH;
            }
            case 4: {
                return SIDES_X_NEG_WEST;
            }
            case 5: {
                if (vertAxis == 2) {
                    return SIDES_X_POS_EAST_X_AXIS;
                }
                return SIDES_X_POS_EAST;
            }
        }
        throw new IllegalArgumentException("Unknown side: " + side);
    }

    private static BlockDir[] getEdgeDirections(int side, int vertAxis) {
        switch (side) {
            case 0: {
                return EDGES_Y_NEG_DOWN;
            }
            case 1: {
                return EDGES_Y_POS_UP;
            }
            case 2: {
                if (vertAxis == 1) {
                    return EDGES_Z_NEG_NORTH_Z_AXIS;
                }
                return EDGES_Z_NEG_NORTH;
            }
            case 3: {
                return EDGES_Z_POS_SOUTH;
            }
            case 4: {
                return EDGES_X_NEG_WEST;
            }
            case 5: {
                if (vertAxis == 2) {
                    return EDGES_X_POS_EAST_X_AXIS;
                }
                return EDGES_X_POS_EAST;
            }
        }
        throw new IllegalArgumentException("Unknown side: " + side);
    }

    protected static Map[][] getSpriteQuadCompactMaps() {
        return spriteQuadCompactMaps;
    }

    private static int getConnectedTextureCtmIndex(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, eaj icon, int metadata, RenderEnv renderEnv) {
        boolean[] borders = renderEnv.getBorderFlags();
        switch (side) {
            case 0: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                if (!cp.innerSeams) break;
                fk posFront = blockPos.c();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.d(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.e(), side, icon, metadata);
                break;
            }
            case 1: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                if (!cp.innerSeams) break;
                fk posFront = blockPos.b();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.e(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.d(), side, icon, metadata);
                break;
            }
            case 2: {
                fk posFront;
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                if (cp.innerSeams) {
                    posFront = blockPos.d();
                    borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g(), side, icon, metadata);
                    borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f(), side, icon, metadata);
                    borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c(), side, icon, metadata);
                    boolean bl = borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b(), side, icon, metadata);
                }
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 1, borders);
                ConnectedTextures.switchValues(2, 3, borders);
                break;
            }
            case 3: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                if (!cp.innerSeams) break;
                fk posFront = blockPos.e();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b(), side, icon, metadata);
                break;
            }
            case 4: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                if (!cp.innerSeams) break;
                fk posFront = blockPos.f();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.d(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.e(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b(), side, icon, metadata);
                break;
            }
            case 5: {
                fk posFront;
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                if (cp.innerSeams) {
                    posFront = blockPos.g();
                    borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.e(), side, icon, metadata);
                    borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.d(), side, icon, metadata);
                    borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c(), side, icon, metadata);
                    boolean bl = borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b(), side, icon, metadata);
                }
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 1, borders);
                ConnectedTextures.switchValues(2, 3, borders);
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (index == 0) {
            return index;
        }
        if (!Config.isConnectedTexturesFancy()) {
            return index;
        }
        boolean[] edges = borders;
        switch (side) {
            case 0: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().d(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().e(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().e(), side, icon, metadata);
                if (!cp.innerSeams) break;
                fk posFront = blockPos.c();
                edges[0] = edges[0] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g().d(), side, icon, metadata);
                edges[1] = edges[1] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f().d(), side, icon, metadata);
                edges[2] = edges[2] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g().e(), side, icon, metadata);
                edges[3] = edges[3] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f().e(), side, icon, metadata);
                break;
            }
            case 1: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().e(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().e(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().d(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                if (!cp.innerSeams) break;
                fk posFront = blockPos.b();
                edges[0] = edges[0] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g().e(), side, icon, metadata);
                edges[1] = edges[1] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f().e(), side, icon, metadata);
                edges[2] = edges[2] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g().d(), side, icon, metadata);
                edges[3] = edges[3] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f().d(), side, icon, metadata);
                break;
            }
            case 2: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().c(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().b(), side, icon, metadata);
                if (cp.innerSeams) {
                    fk posFront = blockPos.d();
                    edges[0] = edges[0] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f().c(), side, icon, metadata);
                    edges[1] = edges[1] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g().c(), side, icon, metadata);
                    edges[2] = edges[2] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f().b(), side, icon, metadata);
                    boolean bl2 = edges[3] = edges[3] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g().b(), side, icon, metadata);
                }
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 3, borders);
                ConnectedTextures.switchValues(1, 2, borders);
                break;
            }
            case 3: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().c(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().b(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                if (!cp.innerSeams) break;
                fk posFront = blockPos.e();
                edges[0] = edges[0] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g().c(), side, icon, metadata);
                edges[1] = edges[1] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f().c(), side, icon, metadata);
                edges[2] = edges[2] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g().b(), side, icon, metadata);
                edges[3] = edges[3] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f().b(), side, icon, metadata);
                break;
            }
            case 4: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c().e(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c().d(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().e(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                if (!cp.innerSeams) break;
                fk posFront = blockPos.f();
                edges[0] = edges[0] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c().e(), side, icon, metadata);
                edges[1] = edges[1] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c().d(), side, icon, metadata);
                edges[2] = edges[2] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b().e(), side, icon, metadata);
                edges[3] = edges[3] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b().d(), side, icon, metadata);
                break;
            }
            case 5: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c().d(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c().e(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().e(), side, icon, metadata);
                if (cp.innerSeams) {
                    fk posFront = blockPos.g();
                    edges[0] = edges[0] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c().d(), side, icon, metadata);
                    edges[1] = edges[1] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c().e(), side, icon, metadata);
                    edges[2] = edges[2] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b().d(), side, icon, metadata);
                    boolean bl3 = edges[3] = edges[3] || ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b().e(), side, icon, metadata);
                }
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 3, borders);
                ConnectedTextures.switchValues(1, 2, borders);
            }
        }
        if (index == 13 && edges[0]) {
            index = 4;
        } else if (index == 15 && edges[1]) {
            index = 5;
        } else if (index == 37 && edges[2]) {
            index = 16;
        } else if (index == 39 && edges[3]) {
            index = 17;
        } else if (index == 14 && edges[0] && edges[1]) {
            index = 7;
        } else if (index == 25 && edges[0] && edges[2]) {
            index = 6;
        } else if (index == 27 && edges[3] && edges[1]) {
            index = 19;
        } else if (index == 38 && edges[3] && edges[2]) {
            index = 18;
        } else if (index == 14 && !edges[0] && edges[1]) {
            index = 31;
        } else if (index == 25 && edges[0] && !edges[2]) {
            index = 30;
        } else if (index == 27 && !edges[3] && edges[1]) {
            index = 41;
        } else if (index == 38 && edges[3] && !edges[2]) {
            index = 40;
        } else if (index == 14 && edges[0] && !edges[1]) {
            index = 29;
        } else if (index == 25 && !edges[0] && edges[2]) {
            index = 28;
        } else if (index == 27 && edges[3] && !edges[1]) {
            index = 43;
        } else if (index == 38 && !edges[3] && edges[2]) {
            index = 42;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 46;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 9;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 21;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 8;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 20;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 11;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 22;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 23;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 10;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 34;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 35;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && !edges[3]) {
            index = 32;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 33;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 44;
        } else if (index == 26 && !edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 45;
        }
        return index;
    }

    private static void switchValues(int ix1, int ix2, boolean[] arr) {
        boolean prev1 = arr[ix1];
        arr[ix1] = arr[ix2];
        arr[ix2] = prev1;
    }

    private static boolean isNeighbourOverlay(ConnectedProperties cp, bjg worldReader, byj blockState, fk blockPos, int side, eaj icon, int metadata) {
        eaj neighbourIcon;
        byj neighbourState = worldReader.d_(blockPos);
        if (!ConnectedTextures.isFullCubeModel(neighbourState, worldReader, blockPos)) {
            return false;
        }
        if (cp.connectBlocks != null && !Matches.block(neighbourState.getBlockId(), neighbourState.getMetadata(), cp.connectBlocks)) {
            return false;
        }
        if (cp.connectTileIcons != null && !Config.isSameOne(neighbourIcon = ConnectedTextures.getNeighbourIcon(worldReader, blockState, blockPos, neighbourState, side), cp.connectTileIcons)) {
            return false;
        }
        fk posNeighbourStateAbove = blockPos.a(ConnectedTextures.getFacing(side));
        byj neighbourStateAbove = worldReader.d_(posNeighbourStateAbove);
        if (neighbourStateAbove.g(worldReader, posNeighbourStateAbove)) {
            return false;
        }
        if (side == 1 && neighbourStateAbove.d() == bpi.cA) {
            return false;
        }
        return !ConnectedTextures.isNeighbour(cp, worldReader, blockState, blockPos, neighbourState, side, icon, metadata);
    }

    private static boolean isFullCubeModel(byj state, bjg blockReader, fk pos) {
        if (BlockUtils.isFullCube(state, blockReader, pos)) {
            return true;
        }
        bph block = state.d();
        if (block instanceof brp) {
            return true;
        }
        return block instanceof buq;
    }

    private static boolean isNeighbourMatching(ConnectedProperties cp, bjg worldReader, byj blockState, fk blockPos, int side, eaj icon, int metadata) {
        eaj neighbourIcon;
        byj neighbourState = worldReader.d_(blockPos);
        if (neighbourState == AIR_DEFAULT_STATE) {
            return false;
        }
        if (cp.matchBlocks != null && !cp.matchesBlock(neighbourState.getBlockId(), neighbourState.getMetadata())) {
            return false;
        }
        if (cp.matchTileIcons != null && (neighbourIcon = ConnectedTextures.getNeighbourIcon(worldReader, blockState, blockPos, neighbourState, side)) != icon) {
            return false;
        }
        fk posNeighbourAbove = blockPos.a(ConnectedTextures.getFacing(side));
        byj neighbourStateAbove = worldReader.d_(posNeighbourAbove);
        if (neighbourStateAbove.g(worldReader, posNeighbourAbove)) {
            return false;
        }
        return side != 1 || neighbourStateAbove.d() != bpi.cA;
    }

    private static boolean isNeighbour(ConnectedProperties cp, bjg worldReader, byj blockState, fk blockPos, int side, eaj icon, int metadata) {
        byj neighbourState = worldReader.d_(blockPos);
        return ConnectedTextures.isNeighbour(cp, worldReader, blockState, blockPos, neighbourState, side, icon, metadata);
    }

    private static boolean isNeighbour(ConnectedProperties cp, bjg worldReader, byj blockState, fk blockPos, byj neighbourState, int side, eaj icon, int metadata) {
        if (blockState == neighbourState) {
            return true;
        }
        if (cp.connect == 2) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            eaj neighbourIcon = ConnectedTextures.getNeighbourIcon(worldReader, blockState, blockPos, neighbourState, side);
            return neighbourIcon == icon;
        }
        if (cp.connect == 3) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            return neighbourState.e() == blockState.e();
        }
        if (cp.connect == 1) {
            bph block = blockState.d();
            bph neighbourBlock = neighbourState.d();
            return neighbourBlock == block;
        }
        return false;
    }

    private static eaj getNeighbourIcon(bjg worldReader, byj blockState, fk blockPos, byj neighbourState, int side) {
        fp facing;
        List quads;
        ebv model = dbn.x().U().a().b(neighbourState);
        if (model == null) {
            return null;
        }
        if (Reflector.IForgeBlock_getExtendedState.exists()) {
            neighbourState = (byj)Reflector.call(neighbourState.d(), Reflector.IForgeBlock_getExtendedState, neighbourState, worldReader, blockPos);
        }
        if ((quads = model.a(neighbourState, facing = ConnectedTextures.getFacing(side), RANDOM)) == null) {
            return null;
        }
        if (Config.isBetterGrass()) {
            quads = BetterGrass.getFaceQuads(worldReader, neighbourState, blockPos, facing, quads);
        }
        if (quads.size() > 0) {
            drn quad = (drn)quads.get(0);
            return quad.getSprite();
        }
        List quadsGeneral = model.a(neighbourState, null, RANDOM);
        if (quadsGeneral == null) {
            return null;
        }
        for (int i2 = 0; i2 < quadsGeneral.size(); ++i2) {
            drn quad = (drn)quadsGeneral.get(i2);
            if (quad.e() != facing) continue;
            return quad.getSprite();
        }
        return null;
    }

    private static eaj getConnectedTextureHorizontal(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, eaj icon, int metadata) {
        boolean left = false;
        boolean right = false;
        block0 : switch (vertAxis) {
            case 0: {
                switch (side) {
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    }
                }
                break;
            }
            case 1: {
                switch (side) {
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    }
                }
                break;
            }
            case 2: {
                switch (side) {
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break block0;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break block0;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        break block0;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        break block0;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        break block0;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                    }
                }
            }
        }
        int index = 3;
        index = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static eaj getConnectedTextureVertical(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, eaj icon, int metadata) {
        boolean bottom = false;
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    break;
                }
                if (side == 0) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                    break;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    break;
                }
                if (side == 2) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    break;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    break;
                }
                if (side == 4) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    break;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
            }
        }
        int index = 3;
        index = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static eaj getConnectedTextureHorizontalVertical(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, eaj icon, int metadata) {
        eaj[] tileIcons = cp.tileIcons;
        eaj iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH != null && iconH != icon && iconH != tileIcons[3]) {
            return iconH;
        }
        eaj iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconV == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconV == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconV;
    }

    private static eaj getConnectedTextureVerticalHorizontal(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, eaj icon, int metadata) {
        eaj[] tileIcons = cp.tileIcons;
        eaj iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV != null && iconV != icon && iconV != tileIcons[3]) {
            return iconV;
        }
        eaj iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconH == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconH == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconH;
    }

    private static eaj getConnectedTextureTop(ConnectedProperties cp, bjg blockAccess, byj blockState, fk blockPos, int vertAxis, int side, eaj icon, int metadata) {
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
            }
        }
        if (top) {
            return cp.tileIcons[0];
        }
        return null;
    }

    public static void updateIcons(eai textureMap) {
        blockProperties = null;
        tileProperties = null;
        spriteQuadMaps = null;
        spriteQuadCompactMaps = null;
        if (!Config.isConnectedTextures()) {
            return;
        }
        ye[] rps = Config.getResourcePacks();
        for (int i2 = rps.length - 1; i2 >= 0; --i2) {
            ye rp = rps[i2];
            ConnectedTextures.updateIcons(textureMap, rp);
        }
        ConnectedTextures.updateIcons(textureMap, (ye)Config.getDefaultResourcePack());
        emptySprite = textureMap.registerSprite(LOCATION_SPRITE_EMPTY);
        spriteQuadMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
        spriteQuadFullMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
        spriteQuadCompactMaps = new Map[textureMap.getCountRegisteredSprites() + 1][];
        if (blockProperties.length <= 0) {
            blockProperties = null;
        }
        if (tileProperties.length <= 0) {
            tileProperties = null;
        }
    }

    public static void updateIcons(eai textureMap, ye rp) {
        Object[] names = ResUtils.collectFiles(rp, "optifine/ctm/", ".properties", ConnectedTextures.getDefaultCtmPaths());
        Arrays.sort(names);
        List tileList = ConnectedTextures.makePropertyList(tileProperties);
        List blockList = ConnectedTextures.makePropertyList(blockProperties);
        for (int i2 = 0; i2 < names.length; ++i2) {
            Object name = names[i2];
            Config.dbg("ConnectedTextures: " + (String)name);
            try {
                sm locFile = new sm((String)name);
                InputStream in = rp.a(yf.a, locFile);
                if (in == null) {
                    Config.warn("ConnectedTextures file not found: " + (String)name);
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                ConnectedProperties cp = new ConnectedProperties(props, (String)name);
                if (!cp.isValid((String)name)) continue;
                cp.updateIcons(textureMap);
                ConnectedTextures.addToTileList(cp, tileList);
                ConnectedTextures.addToBlockList(cp, blockList);
                continue;
            }
            catch (FileNotFoundException e2) {
                Config.warn("ConnectedTextures file not found: " + (String)name);
                continue;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        blockProperties = ConnectedTextures.propertyListToArray(blockList);
        tileProperties = ConnectedTextures.propertyListToArray(tileList);
        multipass = ConnectedTextures.detectMultipass();
        Config.dbg("Multipass connected textures: " + multipass);
    }

    public static void refreshIcons(eai textureMap) {
        ConnectedTextures.refreshIcons(blockProperties, textureMap);
        ConnectedTextures.refreshIcons(tileProperties, textureMap);
        emptySprite = ConnectedTextures.getSprite(textureMap, LOCATION_SPRITE_EMPTY);
    }

    private static eaj getSprite(eai textureMap, sm loc) {
        eaj sprite = textureMap.a(loc);
        if (sprite == null || sprite instanceof eac) {
            Config.warn("Missing CTM sprite: " + loc);
        }
        return sprite;
    }

    private static void refreshIcons(ConnectedProperties[][] propertiesArray, eai textureMap) {
        if (propertiesArray == null) {
            return;
        }
        for (int i2 = 0; i2 < propertiesArray.length; ++i2) {
            ConnectedProperties[] properties = propertiesArray[i2];
            if (properties == null) continue;
            for (int c2 = 0; c2 < properties.length; ++c2) {
                ConnectedProperties cp = properties[c2];
                if (cp == null) continue;
                cp.refreshIcons(textureMap);
            }
        }
    }

    private static List makePropertyList(ConnectedProperties[][] propsArr) {
        ArrayList<ArrayList<ConnectedProperties>> list = new ArrayList<ArrayList<ConnectedProperties>>();
        if (propsArr != null) {
            for (int i2 = 0; i2 < propsArr.length; ++i2) {
                ConnectedProperties[] props = propsArr[i2];
                ArrayList<ConnectedProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<ConnectedProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static boolean detectMultipass() {
        ConnectedProperties[] cps;
        int i2;
        ArrayList<ConnectedProperties> propList = new ArrayList<ConnectedProperties>();
        for (i2 = 0; i2 < tileProperties.length; ++i2) {
            cps = tileProperties[i2];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        for (i2 = 0; i2 < blockProperties.length; ++i2) {
            cps = blockProperties[i2];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        ConnectedProperties[] props = propList.toArray(new ConnectedProperties[propList.size()]);
        HashSet<eaj> matchIconSet = new HashSet<eaj>();
        HashSet<eaj> tileIconSet = new HashSet<eaj>();
        for (int i3 = 0; i3 < props.length; ++i3) {
            ConnectedProperties cp = props[i3];
            if (cp.matchTileIcons != null) {
                matchIconSet.addAll(Arrays.asList(cp.matchTileIcons));
            }
            if (cp.tileIcons == null) continue;
            tileIconSet.addAll(Arrays.asList(cp.tileIcons));
        }
        matchIconSet.retainAll(tileIconSet);
        return !matchIconSet.isEmpty();
    }

    private static ConnectedProperties[][] propertyListToArray(List list) {
        ConnectedProperties[][] propArr = new ConnectedProperties[list.size()][];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List subList = (List)list.get(i2);
            if (subList == null) continue;
            ConnectedProperties[] subArr = subList.toArray(new ConnectedProperties[subList.size()]);
            propArr[i2] = subArr;
        }
        return propArr;
    }

    private static void addToTileList(ConnectedProperties cp, List tileList) {
        if (cp.matchTileIcons == null) {
            return;
        }
        for (int i2 = 0; i2 < cp.matchTileIcons.length; ++i2) {
            eaj icon = cp.matchTileIcons[i2];
            if (!(icon instanceof eaj)) {
                Config.warn("TextureAtlasSprite is not TextureAtlasSprite: " + icon + ", name: " + icon.l());
                continue;
            }
            eaj ts = icon;
            int tileId = ts.getIndexInMap();
            if (tileId < 0) {
                Config.warn("Invalid tile ID: " + tileId + ", icon: " + ts.l());
                continue;
            }
            ConnectedTextures.addToList(cp, tileList, tileId);
        }
    }

    private static void addToBlockList(ConnectedProperties cp, List blockList) {
        if (cp.matchBlocks == null) {
            return;
        }
        for (int i2 = 0; i2 < cp.matchBlocks.length; ++i2) {
            int blockId = cp.matchBlocks[i2].getBlockId();
            if (blockId < 0) {
                Config.warn("Invalid block ID: " + blockId);
                continue;
            }
            ConnectedTextures.addToList(cp, blockList, blockId);
        }
    }

    private static void addToList(ConnectedProperties cp, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<ConnectedProperties> subList = (ArrayList<ConnectedProperties>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<ConnectedProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    private static String[] getDefaultCtmPaths() {
        ArrayList list = new ArrayList();
        ConnectedTextures.addDefaultLocation(list, "textures/block/glass.png", "20_glass/glass.properties");
        ConnectedTextures.addDefaultLocation(list, "textures/block/glass.png", "20_glass/glass_pane.properties");
        ConnectedTextures.addDefaultLocation(list, "textures/block/bookshelf.png", "30_bookshelf/bookshelf.properties");
        ConnectedTextures.addDefaultLocation(list, "textures/block/sandstone.png", "40_sandstone/sandstone.properties");
        ConnectedTextures.addDefaultLocation(list, "textures/block/red_sandstone.png", "41_red_sandstone/red_sandstone.properties");
        String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        for (int i2 = 0; i2 < colors.length; ++i2) {
            String color = colors[i2];
            String prefix = StrUtils.fillLeft("" + i2, 2, '0');
            ConnectedTextures.addDefaultLocation(list, "textures/block/" + color + "_stained_glass.png", prefix + "_glass_" + color + "/glass_" + color + ".properties");
            ConnectedTextures.addDefaultLocation(list, "textures/block/" + color + "_stained_glass.png", prefix + "_glass_" + color + "/glass_pane_" + color + ".properties");
        }
        String[] paths = list.toArray(new String[list.size()]);
        return paths;
    }

    private static void addDefaultLocation(List list, String locBase, String pathSuffix) {
        String defPath = "optifine/ctm/default/";
        sm loc = new sm(locBase);
        ye rp = Config.getDefiningResourcePack(loc);
        if (rp == null) {
            return;
        }
        if (rp.a().equals("Programmer Art")) {
            String defPathPa = defPath + "programmer_art/";
            list.add(defPathPa + pathSuffix);
            return;
        }
        if (rp == Config.getDefaultResourcePack()) {
            list.add(defPath + pathSuffix);
        }
    }
}

