/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Iterator;
import net.optifine.BlockPosM;
import net.optifine.shaders.IteratorAxis;

public class Iterator3d
implements Iterator<fk> {
    private IteratorAxis iteratorAxis;
    private BlockPosM blockPos = new BlockPosM(0, 0, 0);
    private int axis = 0;
    private int kX;
    private int kY;
    private int kZ;
    private static final int AXIS_X = 0;
    private static final int AXIS_Y = 1;
    private static final int AXIS_Z = 2;

    public Iterator3d(fk posStart, fk posEnd, int width, int height) {
        boolean revX = posStart.o() > posEnd.o();
        boolean revY = posStart.p() > posEnd.p();
        boolean revZ = posStart.q() > posEnd.q();
        posStart = this.reverseCoord(posStart, revX, revY, revZ);
        posEnd = this.reverseCoord(posEnd, revX, revY, revZ);
        this.kX = revX ? -1 : 1;
        this.kY = revY ? -1 : 1;
        this.kZ = revZ ? -1 : 1;
        cvl vec = new cvl((double)(posEnd.o() - posStart.o()), (double)(posEnd.p() - posStart.p()), (double)(posEnd.q() - posStart.q()));
        cvl vecN = vec.d();
        cvl vecX = new cvl(1.0, 0.0, 0.0);
        double dotX = vecN.b(vecX);
        double dotXabs = Math.abs(dotX);
        cvl vecY = new cvl(0.0, 1.0, 0.0);
        double dotY = vecN.b(vecY);
        double dotYabs = Math.abs(dotY);
        cvl vecZ = new cvl(0.0, 0.0, 1.0);
        double dotZ = vecN.b(vecZ);
        double dotZabs = Math.abs(dotZ);
        if (dotZabs >= dotYabs && dotZabs >= dotXabs) {
            this.axis = 2;
            fk pos1 = new fk(posStart.q(), posStart.p() - width, posStart.o() - height);
            fk pos2 = new fk(posEnd.q(), posStart.p() + width + 1, posStart.o() + height + 1);
            int countX = posEnd.q() - posStart.q();
            double deltaY = (double)(posEnd.p() - posStart.p()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.o() - posStart.o()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else if (dotYabs >= dotXabs && dotYabs >= dotZabs) {
            this.axis = 1;
            fk pos1 = new fk(posStart.p(), posStart.o() - width, posStart.q() - height);
            fk pos2 = new fk(posEnd.p(), posStart.o() + width + 1, posStart.q() + height + 1);
            int countX = posEnd.p() - posStart.p();
            double deltaY = (double)(posEnd.o() - posStart.o()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.q() - posStart.q()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else {
            this.axis = 0;
            fk pos1 = new fk(posStart.o(), posStart.p() - width, posStart.q() - height);
            fk pos2 = new fk(posEnd.o(), posStart.p() + width + 1, posStart.q() + height + 1);
            int countX = posEnd.o() - posStart.o();
            double deltaY = (double)(posEnd.p() - posStart.p()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.q() - posStart.q()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        }
    }

    private fk reverseCoord(fk pos, boolean revX, boolean revY, boolean revZ) {
        if (revX) {
            pos = new fk(-pos.o(), pos.p(), pos.q());
        }
        if (revY) {
            pos = new fk(pos.o(), -pos.p(), pos.q());
        }
        if (revZ) {
            pos = new fk(pos.o(), pos.p(), -pos.q());
        }
        return pos;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorAxis.hasNext();
    }

    @Override
    public fk next() {
        fk pos = this.iteratorAxis.next();
        switch (this.axis) {
            case 0: {
                this.blockPos.setXyz(pos.o() * this.kX, pos.p() * this.kY, pos.q() * this.kZ);
                return this.blockPos;
            }
            case 1: {
                this.blockPos.setXyz(pos.p() * this.kX, pos.o() * this.kY, pos.q() * this.kZ);
                return this.blockPos;
            }
            case 2: {
                this.blockPos.setXyz(pos.q() * this.kX, pos.p() * this.kY, pos.o() * this.kZ);
                return this.blockPos;
            }
        }
        this.blockPos.setXyz(pos.o() * this.kX, pos.p() * this.kY, pos.q() * this.kZ);
        return this.blockPos;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not supported");
    }

    public static void main(String[] args) {
        fk posStart = new fk(10, 20, 30);
        fk posEnd = new fk(30, 40, 20);
        Iterator3d it = new Iterator3d(posStart, posEnd, 1, 1);
        while (it.hasNext()) {
            fk blockPos = it.next();
            System.out.println("" + blockPos);
        }
    }
}

