/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.config;

import net.optifine.Config;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.ShaderMacro;

public class ShaderMacros {
    private static String PREFIX_MACRO = "MC_";
    public static final String MC_VERSION = "MC_VERSION";
    public static final String MC_GL_VERSION = "MC_GL_VERSION";
    public static final String MC_GLSL_VERSION = "MC_GLSL_VERSION";
    public static final String MC_OS_WINDOWS = "MC_OS_WINDOWS";
    public static final String MC_OS_MAC = "MC_OS_MAC";
    public static final String MC_OS_LINUX = "MC_OS_LINUX";
    public static final String MC_OS_OTHER = "MC_OS_OTHER";
    public static final String MC_GL_VENDOR_ATI = "MC_GL_VENDOR_ATI";
    public static final String MC_GL_VENDOR_INTEL = "MC_GL_VENDOR_INTEL";
    public static final String MC_GL_VENDOR_NVIDIA = "MC_GL_VENDOR_NVIDIA";
    public static final String MC_GL_VENDOR_XORG = "MC_GL_VENDOR_XORG";
    public static final String MC_GL_VENDOR_OTHER = "MC_GL_VENDOR_OTHER";
    public static final String MC_GL_RENDERER_RADEON = "MC_GL_RENDERER_RADEON";
    public static final String MC_GL_RENDERER_GEFORCE = "MC_GL_RENDERER_GEFORCE";
    public static final String MC_GL_RENDERER_QUADRO = "MC_GL_RENDERER_QUADRO";
    public static final String MC_GL_RENDERER_INTEL = "MC_GL_RENDERER_INTEL";
    public static final String MC_GL_RENDERER_GALLIUM = "MC_GL_RENDERER_GALLIUM";
    public static final String MC_GL_RENDERER_MESA = "MC_GL_RENDERER_MESA";
    public static final String MC_GL_RENDERER_OTHER = "MC_GL_RENDERER_OTHER";
    public static final String MC_FXAA_LEVEL = "MC_FXAA_LEVEL";
    public static final String MC_NORMAL_MAP = "MC_NORMAL_MAP";
    public static final String MC_SPECULAR_MAP = "MC_SPECULAR_MAP";
    public static final String MC_RENDER_QUALITY = "MC_RENDER_QUALITY";
    public static final String MC_SHADOW_QUALITY = "MC_SHADOW_QUALITY";
    public static final String MC_HAND_DEPTH = "MC_HAND_DEPTH";
    public static final String MC_OLD_HAND_LIGHT = "MC_OLD_HAND_LIGHT";
    public static final String MC_OLD_LIGHTING = "MC_OLD_LIGHTING";
    private static ShaderMacro[] extensionMacros;

    public static String getOs() {
        t.b os = t.g();
        switch (os) {
            case c: {
                return MC_OS_WINDOWS;
            }
            case d: {
                return MC_OS_MAC;
            }
            case a: {
                return MC_OS_LINUX;
            }
        }
        return MC_OS_OTHER;
    }

    public static String getVendor() {
        String vendor = Config.openGlVendor;
        if (vendor == null) {
            return MC_GL_VENDOR_OTHER;
        }
        if ((vendor = vendor.toLowerCase()).startsWith("ati")) {
            return MC_GL_VENDOR_ATI;
        }
        if (vendor.startsWith("intel")) {
            return MC_GL_VENDOR_INTEL;
        }
        if (vendor.startsWith("nvidia")) {
            return MC_GL_VENDOR_NVIDIA;
        }
        if (vendor.startsWith("x.org")) {
            return MC_GL_VENDOR_XORG;
        }
        return MC_GL_VENDOR_OTHER;
    }

    public static String getRenderer() {
        String renderer = Config.openGlRenderer;
        if (renderer == null) {
            return MC_GL_RENDERER_OTHER;
        }
        if ((renderer = renderer.toLowerCase()).startsWith("amd")) {
            return MC_GL_RENDERER_RADEON;
        }
        if (renderer.startsWith("ati")) {
            return MC_GL_RENDERER_RADEON;
        }
        if (renderer.startsWith("radeon")) {
            return MC_GL_RENDERER_RADEON;
        }
        if (renderer.startsWith("gallium")) {
            return MC_GL_RENDERER_GALLIUM;
        }
        if (renderer.startsWith("intel")) {
            return MC_GL_RENDERER_INTEL;
        }
        if (renderer.startsWith("geforce")) {
            return MC_GL_RENDERER_GEFORCE;
        }
        if (renderer.startsWith("nvidia")) {
            return MC_GL_RENDERER_GEFORCE;
        }
        if (renderer.startsWith("quadro")) {
            return MC_GL_RENDERER_QUADRO;
        }
        if (renderer.startsWith("nvs")) {
            return MC_GL_RENDERER_QUADRO;
        }
        if (renderer.startsWith("mesa")) {
            return MC_GL_RENDERER_MESA;
        }
        return MC_GL_RENDERER_OTHER;
    }

    public static String getPrefixMacro() {
        return PREFIX_MACRO;
    }

    public static ShaderMacro[] getExtensions() {
        if (extensionMacros == null) {
            String[] exts = Config.getOpenGlExtensions();
            ShaderMacro[] extMacros = new ShaderMacro[exts.length];
            for (int i2 = 0; i2 < exts.length; ++i2) {
                extMacros[i2] = new ShaderMacro(PREFIX_MACRO + exts[i2], "");
            }
            extensionMacros = extMacros;
        }
        return extensionMacros;
    }

    public static String getFixedMacroLines() {
        StringBuilder sb2 = new StringBuilder();
        ShaderMacros.addMacroLine(sb2, MC_VERSION, Config.getMinecraftVersionInt());
        ShaderMacros.addMacroLine(sb2, "MC_GL_VERSION " + Config.getGlVersion().toInt());
        ShaderMacros.addMacroLine(sb2, "MC_GLSL_VERSION " + Config.getGlslVersion().toInt());
        ShaderMacros.addMacroLine(sb2, ShaderMacros.getOs());
        ShaderMacros.addMacroLine(sb2, ShaderMacros.getVendor());
        ShaderMacros.addMacroLine(sb2, ShaderMacros.getRenderer());
        return sb2.toString();
    }

    public static String getOptionMacroLines() {
        StringBuilder sb2 = new StringBuilder();
        if (Shaders.configAntialiasingLevel > 0) {
            ShaderMacros.addMacroLine(sb2, MC_FXAA_LEVEL, Shaders.configAntialiasingLevel);
        }
        if (Shaders.configNormalMap) {
            ShaderMacros.addMacroLine(sb2, MC_NORMAL_MAP);
        }
        if (Shaders.configSpecularMap) {
            ShaderMacros.addMacroLine(sb2, MC_SPECULAR_MAP);
        }
        ShaderMacros.addMacroLine(sb2, MC_RENDER_QUALITY, Shaders.configRenderResMul);
        ShaderMacros.addMacroLine(sb2, MC_SHADOW_QUALITY, Shaders.configShadowResMul);
        ShaderMacros.addMacroLine(sb2, MC_HAND_DEPTH, Shaders.configHandDepthMul);
        if (Shaders.isOldHandLight()) {
            ShaderMacros.addMacroLine(sb2, MC_OLD_HAND_LIGHT);
        }
        if (Shaders.isOldLighting()) {
            ShaderMacros.addMacroLine(sb2, MC_OLD_LIGHTING);
        }
        return sb2.toString();
    }

    private static void addMacroLine(StringBuilder sb2, String name, int value) {
        sb2.append("#define ");
        sb2.append(name);
        sb2.append(" ");
        sb2.append(value);
        sb2.append("\n");
    }

    private static void addMacroLine(StringBuilder sb2, String name, float value) {
        sb2.append("#define ");
        sb2.append(name);
        sb2.append(" ");
        sb2.append(value);
        sb2.append("\n");
    }

    private static void addMacroLine(StringBuilder sb2, String name) {
        sb2.append("#define ");
        sb2.append(name);
        sb2.append("\n");
    }
}

