/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BarkMushroomBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public BarkMushroomBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return EAST;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brt) {
        if (!player.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        BarkMushroomBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this));
        world.func_217377_a(pos, false);
        return ActionResultType.SUCCESS;
    }

    public static boolean canAttachTo(IBlockReader world, BlockPos pos, Direction direction) {
        BlockState blockstate = world.func_180495_p(pos);
        return blockstate.func_177230_c() instanceof LogBlock;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        return BarkMushroomBlock.canAttachTo((IBlockReader)worldIn, pos.func_177972_a(direction.func_176734_d()), direction);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176734_d() == state.func_177229_b((IProperty)FACING) && !state.func_196955_c((IWorldReader)world, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate;
        if (!context.func_196012_c() && (blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d()))).func_177230_c() == this && blockstate.func_177229_b((IProperty)FACING) == context.func_196000_l()) {
            return null;
        }
        BlockState blockstate1 = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        for (Direction direction : context.func_196009_e()) {
            if (!direction.func_176740_k().func_176722_c() || !(blockstate1 = (BlockState)blockstate1.func_206870_a((IProperty)FACING, (Comparable)direction.func_176734_d())).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            return (BlockState)blockstate1.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

