/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GroundcoverBlock
extends Block
implements IWaterLoggable {
    public static final IntegerProperty MODEL = IntegerProperty.func_177719_a((String)"model", (int)0, (int)4);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private Type type;

    public GroundcoverBlock(Material material, Type type) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(0.05f, 0.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)MODEL, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public GroundcoverBlock(Material material, Type type, SoundType soundType) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(0.1f, 0.0f).func_200947_a(soundType).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)MODEL, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.field_72995_K) {
            int model = world.func_201674_k().nextInt(5);
            IFluidState ifluidstate = world.func_204610_c(pos);
            world.func_175656_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)MODEL, (Comparable)Integer.valueOf(model))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a)));
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        int model = context.func_195991_k().func_201674_k().nextInt(5);
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)MODEL, (Comparable)Integer.valueOf(model))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return state;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_200132_m();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, false);
            switch (this.type) {
                case TWIGS: {
                    GroundcoverBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_151055_y));
                    break;
                }
                case IRON_NUGGET: {
                    GroundcoverBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_191525_da));
                    break;
                }
                case GOLD_NUGGET: {
                    GroundcoverBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_151074_bl));
                    break;
                }
                case FLINT: {
                    GroundcoverBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_151145_ak));
                    break;
                }
            }
        }
    }

    public boolean func_181623_g() {
        return true;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brt) {
        if (!player.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        if (player.func_184812_l_()) {
            int model = (Integer)state.func_177229_b((IProperty)MODEL);
            model = model < 4 ? ++model : 0;
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)MODEL, (Comparable)Integer.valueOf(model)));
            return ActionResultType.SUCCESS;
        }
        world.func_217377_a(pos, false);
        switch (this.type) {
            case IRON_NUGGET: {
                GroundcoverBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_191525_da));
                break;
            }
            case GOLD_NUGGET: {
                GroundcoverBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_151074_bl));
                break;
            }
            case FLINT: {
                GroundcoverBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_151145_ak));
                break;
            }
            default: {
                GroundcoverBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_220081_d(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        switch (this.type) {
            case IRON_NUGGET: {
                return new ItemStack((IItemProvider)Items.field_191525_da);
            }
            case GOLD_NUGGET: {
                return new ItemStack((IItemProvider)Items.field_151074_bl);
            }
            case FLINT: {
                return new ItemStack((IItemProvider)Items.field_151145_ak);
            }
        }
        return new ItemStack((IItemProvider)this);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{MODEL, WATERLOGGED});
    }

    public static enum Type {
        TWIGS,
        ROCKS,
        BONES,
        IRON_NUGGET,
        GOLD_NUGGET,
        FLINT,
        PINECONES,
        SEASHELLS,
        DUNG;

    }
}

