/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.blocks;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import projectvibrantjourneys.common.entities.passive.ScarecrowEntity;
import projectvibrantjourneys.init.PVJBlocks;
import projectvibrantjourneys.init.PVJEntities;
import projectvibrantjourneys.init.PVJSoundEvents;

public class PossessedPumpkinBlock
extends CarvedPumpkinBlock {
    @Nullable
    private BlockPattern scarecrowPattern;
    private static final Predicate<BlockState> IS_FENCE = state -> state.func_177230_c().func_203417_a(BlockTags.field_219748_G);

    public PossessedPumpkinBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151572_C, (MaterialColor)MaterialColor.field_151676_q).func_200943_b(1.0f).func_200944_c().func_200947_a(SoundType.field_185848_a));
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            this.trySpawnGolem(worldIn, pos);
        }
    }

    private void trySpawnGolem(World world, BlockPos pos) {
        BlockPattern.PatternHelper patternHelper = this.getScarecrowPattern().func_177681_a((IWorldReader)world, pos);
        if (patternHelper != null) {
            for (int j = 0; j < this.getScarecrowPattern().func_177684_c(); ++j) {
                for (int k = 0; k < this.getScarecrowPattern().func_177685_b(); ++k) {
                    CachedBlockInfo cachedblockinfo2 = patternHelper.func_177670_a(j, k, 0);
                    world.func_180501_a(cachedblockinfo2.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                    world.func_217379_c(2001, cachedblockinfo2.func_177508_d(), Block.func_196246_j((BlockState)cachedblockinfo2.func_177509_a()));
                }
            }
            BlockPos blockpos = patternHelper.func_177670_a(1, 2, 0).func_177508_d();
            ScarecrowEntity scarecrow = (ScarecrowEntity)PVJEntities.scarecrow.func_200721_a(world);
            scarecrow.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_217376_c((Entity)scarecrow);
            for (ServerPlayerEntity serverplayerentity1 : world.func_217357_a(ServerPlayerEntity.class, scarecrow.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity1, (Entity)scarecrow);
            }
            for (int i1 = 0; i1 < this.getScarecrowPattern().func_177684_c(); ++i1) {
                for (int j1 = 0; j1 < this.getScarecrowPattern().func_177685_b(); ++j1) {
                    CachedBlockInfo cachedblockinfo1 = patternHelper.func_177670_a(i1, j1, 0);
                    world.func_195592_c(cachedblockinfo1.func_177508_d(), Blocks.field_150350_a);
                }
            }
        }
    }

    private BlockPattern getScarecrowPattern() {
        if (this.scarecrowPattern == null) {
            this.scarecrowPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~^~", "F#F", "~F~"}).func_177662_a('^', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)PVJBlocks.possessed_pumpkin))).func_177662_a('F', CachedBlockInfo.func_177510_a(IS_FENCE)).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150407_cf))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.scarecrowPattern;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), PVJSoundEvents.entity_ghost_ambient, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
    }
}

