/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;

public class WeightedCropList {
    private List<WeightedCropItem> crops = new ArrayList<WeightedCropItem>();
    private int totalWeight = 0;

    public void addEntry(WeightedCropItem ... items) {
        for (WeightedCropItem item : items) {
            this.totalWeight += item.getWeight();
            item.setTotalWeight(this.totalWeight);
            this.crops.add(item);
        }
    }

    public Item getRandom(Random random) {
        int rand = random.nextInt(this.totalWeight);
        for (WeightedCropItem crop : this.crops) {
            if (crop.getTotalWeight() < rand) continue;
            return crop.getCrop();
        }
        return null;
    }

    public static class WeightedCropItem {
        public int totalWeight;
        private int weight;
        private Item crop;

        public WeightedCropItem(Item crop, int weight) {
            this.weight = weight;
            this.crop = crop;
            this.totalWeight = 0;
        }

        public int getWeight() {
            return this.weight;
        }

        public Item getCrop() {
            return this.crop;
        }

        public void setTotalWeight(int weight) {
            this.totalWeight = weight;
        }

        public int getTotalWeight() {
            return this.totalWeight;
        }

        public static WeightedCropItem create(Item crop, int weight) {
            return new WeightedCropItem(crop, weight);
        }
    }
}

