/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.entities.monster;

import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import projectvibrantjourneys.common.entities.ai.LightAvoidingRandomWalkingGoal;
import projectvibrantjourneys.init.PVJSoundEvents;

public class GhostEntity
extends MonsterEntity {
    private static final DataParameter<Integer> VANISHING = EntityDataManager.func_187226_a(GhostEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int vanishTime;

    public GhostEntity(EntityType<? extends GhostEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(9, (Goal)new LightAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
    }

    public void func_70636_d() {
        int light;
        if (this.func_70089_S() && this.func_204609_dp()) {
            this.func_70015_d(8);
        }
        Vec3d vec3d = this.func_213322_ci();
        if (!this.field_70122_E && vec3d.field_72448_b < 0.0) {
            this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.vanishTime = (light = this.func_130014_f_().func_201696_r(this.func_180425_c())) > 9 ? ++this.vanishTime : 0;
        if (this.vanishTime > 400) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.vanishTime > 0 && this.field_70146_Z.nextFloat() < (float)this.vanishTime / 400.0f) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
        super.func_70636_d();
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected SoundEvent func_184639_G() {
        return PVJSoundEvents.entity_ghost_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return PVJSoundEvents.entity_ghost_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return PVJSoundEvents.entity_ghost_death;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VANISHING, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("vanishing", this.getVanishTime());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVanishTime(compound.func_74762_e("vanishing"));
    }

    public int getVanishTime() {
        return this.vanishTime;
    }

    public void setVanishTime(int i) {
        this.vanishTime = i;
    }
}

