/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.entities.monster;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import projectvibrantjourneys.core.PVJConfig;
import projectvibrantjourneys.init.PVJItems;

public class MawEntity
extends MonsterEntity {
    public static final DataParameter<Direction> ATTACHED_FACE = EntityDataManager.func_187226_a(MawEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    public static final DataParameter<Boolean> FRIENDLY = EntityDataManager.func_187226_a(MawEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    List<String> acceptedFoods = (List)PVJConfig.mawFoods.get();

    public MawEntity(EntityType<? extends MawEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 5.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, 4, true, true, entity -> !(entity instanceof ZombiePigmanEntity) && !(entity instanceof CreeperEntity)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACHED_FACE, (Object)Direction.DOWN);
        this.field_70180_af.func_187214_a(FRIENDLY, (Object)false);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)Direction.func_82600_a((int)compound.func_74771_c("AttachFace")));
        this.field_70180_af.func_187227_b(FRIENDLY, (Object)compound.func_74767_n("Friendly"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("AttachFace", (byte)((Direction)this.field_70180_af.func_187225_a(ATTACHED_FACE)).func_176745_a());
        compound.func_74757_a("Friendly", ((Boolean)this.field_70180_af.func_187225_a(FRIENDLY)).booleanValue());
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (this.getAttachmentFace() == Direction.DOWN) {
            return 0.1f;
        }
        return this.func_213302_cg() - 0.1f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.NATURAL) {
            this.setAttachmentFace(world.func_201674_k().nextBoolean() ? Direction.UP : Direction.DOWN);
            if (this.getAttachmentFace() == Direction.UP) {
                BlockPos pos = this.func_180425_c();
                while (pos.func_177981_b(5).func_177956_o() < 255 && world.func_175623_d(pos.func_177981_b(5))) {
                    pos = pos.func_177984_a();
                }
                this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        if (reason != SpawnReason.BREEDING) {
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        }
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    public Direction getAttachmentFace() {
        return (Direction)this.field_70180_af.func_187225_a(ATTACHED_FACE);
    }

    public void setAttachmentFace(Direction d) {
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)d);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return (Boolean)this.field_70180_af.func_187225_a(FRIENDLY) == false;
    }

    public boolean func_213392_I() {
        return (Boolean)this.field_70180_af.func_187225_a(FRIENDLY);
    }

    protected boolean func_225511_J_() {
        return (Boolean)this.field_70180_af.func_187225_a(FRIENDLY) == false;
    }

    public boolean func_70652_k(Entity entity) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
        if (flag) {
            if (entity instanceof LivingEntity) {
                Vec3d vec3d = new Vec3d(this.func_226277_ct_() - entity.func_226277_ct_(), 0.1, this.func_226281_cx_() - entity.func_226281_cx_());
                entity.func_213317_d(vec3d.func_72432_b().func_186678_a(0.5));
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 5));
                if (this.getAttachmentFace() == Direction.UP) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_188424_y, 40, 1));
                }
            }
            if (entity instanceof PlayerEntity) {
                ItemStack itemstack1;
                PlayerEntity playerentity = (PlayerEntity)entity;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.canDisableShield(itemstack1, (LivingEntity)playerentity, (LivingEntity)this) && itemstack1.isShield((LivingEntity)playerentity)) {
                    float f2 = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f2) {
                        playerentity.func_184811_cZ().func_185145_a(itemstack.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)playerentity, (byte)30);
                    }
                }
            }
            this.func_174815_a((LivingEntity)this, entity);
            this.func_130011_c(entity);
        }
        return flag;
    }

    public void func_70074_a(LivingEntity entityLivingIn) {
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 2));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_213317_d(Vec3d.field_186680_a);
        Direction direction = this.getAttachmentFace();
        BlockPos pos = this.func_180425_c().func_177972_a(direction.func_176734_d());
        if (this.field_70170_p.func_175623_d(pos)) {
            if (direction == Direction.DOWN) {
                this.func_213293_j(0.0, -0.1f, 0.0);
            } else {
                this.func_213293_j(0.0, 0.1f, 0.0);
            }
        }
        if (((Boolean)this.func_184212_Q().func_187225_a(FRIENDLY)).booleanValue() && this.field_70146_Z.nextFloat() < 0.2f && this.field_70146_Z.nextFloat() < 0.1f) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        Item item = player.func_184586_b(hand).func_77973_b();
        if (((Boolean)this.field_70180_af.func_187225_a(FRIENDLY)).booleanValue()) {
            if (item == Items.field_151074_bl && !this.field_70170_p.field_72995_K) {
                ItemStack stack = new ItemStack((IItemProvider)PVJItems.maw_tongue);
                if (this.func_145818_k_()) {
                    stack.func_200302_a(this.func_200201_e());
                }
                ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
                itementity.func_174869_p();
                this.field_70170_p.func_217376_c((Entity)itementity);
                this.func_70106_y();
            }
            if (this.acceptedFoods.contains(item.getRegistryName().toString())) {
                this.func_70691_i(5.0f);
                player.func_184586_b(hand).func_190918_g(1);
                for (int i = 0; i < 5; ++i) {
                    double offset = (double)this.field_70146_Z.nextFloat() * 0.5;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(offset), this.func_226279_cv_(), this.func_226287_g_(offset), 0.0, 0.0, 0.0);
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public static boolean canSpawn(EntityType<MawEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70108_f(Entity entity) {
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }
}

