/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.entities.monster;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import projectvibrantjourneys.common.entities.ai.StareAtGoal;
import projectvibrantjourneys.common.entities.ai.WatcherAttackGoal;

public class WatcherEntity
extends MonsterEntity {
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(WatcherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private LivingEntity targetedEntity;
    private int clientSideAttackTime;

    public WatcherEntity(EntityType<? extends WatcherEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new StareAtGoal((MobEntity)this, PlayerEntity.class, 100.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new WatcherAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    public int getAttackDuration() {
        return 30;
    }

    public void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
        this.clientSideAttackTime = 0;
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
        if (this.hasTargetedEntity() && this.clientSideAttackTime < this.getAttackDuration()) {
            ++this.clientSideAttackTime;
        }
    }

    public float getAttackAnimationScale(float f) {
        return ((float)this.clientSideAttackTime + f) / (float)this.getAttackDuration();
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected float func_213348_b(Pose poseIn, EntitySize size) {
        return size.field_220316_b * 0.4f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.NATURAL) {
            BlockPos spawnPos = this.findSpawnPos(this.func_180425_c());
            this.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
        }
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    private BlockPos findSpawnPos(BlockPos initialPos) {
        int randHeight = 5 + this.field_70146_Z.nextInt(20);
        for (int i = 0; i < randHeight; ++i) {
            if (this.func_130014_f_().func_175623_d(initialPos.func_177981_b(i))) continue;
            return initialPos.func_177981_b(i - 1);
        }
        return initialPos.func_177981_b(randHeight);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }
}

