/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.HugeTreeFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.SpruceFoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.treedecorator.BeehiveTreeDecorator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.registries.ForgeRegistries;
import projectvibrantjourneys.common.world.blockstateproviders.FloatingPlantBlockStateProvider;
import projectvibrantjourneys.common.world.blockstateproviders.RocksBlockStateProvider;
import projectvibrantjourneys.common.world.blockstateproviders.ShortGrassBlockStateProvider;
import projectvibrantjourneys.common.world.placers.GroundcoverPlacer;
import projectvibrantjourneys.core.PVJConfig;
import projectvibrantjourneys.init.PVJBiomes;
import projectvibrantjourneys.init.PVJBlocks;
import projectvibrantjourneys.init.PVJFeatures;

public class FeatureManager {
    public static final TreeFeatureConfig FIR_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.fir_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.fir_leaves.func_176223_P()), (FoliagePlacer)new SpruceFoliagePlacer(4, 2)).func_225569_d_(11).func_227354_b_(5).func_227356_e_(4).func_227357_f_(2).func_227359_h_(2).func_227352_a_().setSapling((IPlantable)PVJBlocks.fir_sapling).func_225568_b_();
    public static final TreeFeatureConfig PINE_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.pine_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.pine_leaves.func_176223_P()), (FoliagePlacer)new SpruceFoliagePlacer(1, 0)).func_225569_d_(6).func_227354_b_(3).func_227356_e_(3).func_227357_f_(2).func_227359_h_(2).func_227352_a_().setSapling((IPlantable)PVJBlocks.pine_sapling).func_225568_b_();
    public static final TreeFeatureConfig PALM_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.palm_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.palm_leaves.func_176223_P()), (FoliagePlacer)new SpruceFoliagePlacer(1, 0)).func_225569_d_(6).func_227354_b_(3).func_227356_e_(3).func_227357_f_(2).func_227359_h_(2).func_227352_a_().setSapling((IPlantable)PVJBlocks.palm_sapling).func_225568_b_();
    public static final TreeFeatureConfig WILLOW_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.willow_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.willow_leaves.func_176223_P()), (FoliagePlacer)new SpruceFoliagePlacer(1, 0)).func_225569_d_(6).func_227354_b_(3).func_227356_e_(3).func_227357_f_(2).func_227359_h_(2).func_227352_a_().setSapling((IPlantable)PVJBlocks.willow_sapling).func_225568_b_();
    public static final TreeFeatureConfig MANGROVE_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.mangrove_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.mangrove_leaves.func_176223_P()), (FoliagePlacer)new SpruceFoliagePlacer(1, 0)).func_225569_d_(6).func_227354_b_(3).func_227356_e_(3).func_227357_f_(2).func_227359_h_(2).func_227352_a_().setSapling((IPlantable)PVJBlocks.mangrove_sapling).func_225568_b_();
    public static final HugeTreeFeatureConfig MEGA_REDWOOD_TREE = new HugeTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.redwood_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.redwood_leaves.func_176223_P())).func_225569_d_(40).func_227283_b_(30).func_227284_c_(17).setSapling((IPlantable)PVJBlocks.redwood_sapling).func_225568_b_();
    public static final TreeFeatureConfig REDWOOD_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.redwood_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.redwood_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(2, 0)).func_225569_d_(10).func_227354_b_(5).func_227355_c_(2).func_227360_i_(3).func_227352_a_().setSapling((IPlantable)PVJBlocks.redwood_sapling).func_225568_b_();
    public static final HugeTreeFeatureConfig BAOBAB_TREE = new HugeTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.baobab_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.baobab_leaves.func_176223_P())).func_225569_d_(20).func_227283_b_(5).setSapling((IPlantable)PVJBlocks.baobab_sapling).func_225568_b_();
    public static final TreeFeatureConfig ASPEN_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.aspen_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.aspen_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(2, 0)).func_225569_d_(11).func_227354_b_(5).func_227356_e_(6).func_227357_f_(2).func_227352_a_().func_227353_a_((List)ImmutableList.of((Object)new BeehiveTreeDecorator(0.03f))).setSapling((IPlantable)PVJBlocks.aspen_sapling).func_225568_b_();
    public static final TreeFeatureConfig RED_MAPLE_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.maple_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.red_maple_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(2, 0)).func_225569_d_(5).func_227354_b_(2).func_227360_i_(3).func_227357_f_(2).func_227352_a_().setSapling((IPlantable)PVJBlocks.red_maple_sapling).func_225568_b_();
    public static final TreeFeatureConfig ORANGE_MAPLE_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.maple_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.orange_maple_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(2, 0)).func_225569_d_(5).func_227354_b_(2).func_227360_i_(3).func_227357_f_(2).func_227352_a_().setSapling((IPlantable)PVJBlocks.orange_maple_sapling).func_225568_b_();
    public static final TreeFeatureConfig PURPLE_MAPLE_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.maple_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.purple_maple_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(2, 0)).func_225569_d_(5).func_227354_b_(2).func_227360_i_(3).func_227357_f_(2).func_227352_a_().setSapling((IPlantable)PVJBlocks.purple_maple_sapling).func_225568_b_();
    public static final TreeFeatureConfig BIG_RED_MAPLE_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.maple_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.red_maple_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(0, 0)).setSapling((IPlantable)PVJBlocks.red_maple_sapling).func_225568_b_();
    public static final TreeFeatureConfig BIG_ORANGE_MAPLE_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.maple_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.orange_maple_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(0, 0)).setSapling((IPlantable)PVJBlocks.orange_maple_sapling).func_225568_b_();
    public static final TreeFeatureConfig BIG_PURPLE_MAPLE_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.maple_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.purple_maple_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(0, 0)).setSapling((IPlantable)PVJBlocks.purple_maple_sapling).func_225568_b_();
    public static final TreeFeatureConfig COTTONWOOD_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.cottonwood_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.cottonwood_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(0, 0)).func_227353_a_((List)ImmutableList.of((Object)new BeehiveTreeDecorator(0.03f))).setSapling((IPlantable)PVJBlocks.purple_maple_sapling).func_225568_b_();
    public static final TreeFeatureConfig JUNIPER_TREE = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.juniper_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.juniper_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(0, 0)).func_225569_d_(7).func_227354_b_(3).func_227352_a_().setSapling((IPlantable)PVJBlocks.juniper_sapling).func_225568_b_();
    public static final BigMushroomFeatureConfig glowcapFeatureConfig = new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.glowcap_block.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196706_do.func_176223_P()), 2);

    public static void init() {
        BlockClusterFeatureConfig oakTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.oak_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig birchTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.birch_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig spruceTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.spruce_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig jungleTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.jungle_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig darkOakTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.dark_oak_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig acaciaTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.acacia_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig firTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.fir_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig pineTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.pine_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig palmTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.palm_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig willowTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.willow_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig mangroveTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.mangrove_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig redwoodTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.redwood_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig baobabTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.baobab_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig aspenTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.aspen_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig redMapleTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.red_maple_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig orangeMapleTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.orange_maple_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig purpleMapleTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.purple_maple_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig cottonwoodTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.cottonwood_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig juniperTwigsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.juniper_twigs.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig oakFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.oak_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig birchFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.birch_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig spruceFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.spruce_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig jungleFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.jungle_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig darkOakFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.dark_oak_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig acaciaFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.acacia_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig firFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.fir_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig pineFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.pine_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig palmFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.palm_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig willowFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.willow_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig mangroveFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.mangrove_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig redwoodFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.redwood_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig baobabFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.baobab_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig aspenFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.aspen_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig redMapleFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.red_maple_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig orangeMapleFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.orange_maple_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig purpleMapleFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.purple_maple_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig cottonwoodFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.cottonwood_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig juniperFallenLeavesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.juniper_fallen_leaves.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig rocksCluster = FeatureManager.makeFeatureConfig(new RocksBlockStateProvider(), new GroundcoverPlacer());
        BlockClusterFeatureConfig netherrackRocksCluster = FeatureManager.createNetherGroundcoverConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.netherrack_rocks.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig sandstoneRocksCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.sandstone_rocks.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig redSandstoneRocksCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.red_sandstone_rocks.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig iceChunks = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.ice_chunks.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig bonesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.bones.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig bonesNetherCluster = FeatureManager.createNetherGroundcoverConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.bones.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig charredBonesNetherCluster = FeatureManager.createNetherGroundcoverConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.charred_bones.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig pineconesCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.pinecones.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig seashellsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.seashells.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig ironNuggetCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.iron_nugget.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig goldNuggetCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.gold_nugget.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig flintCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.flint.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig dungCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.dung.func_176223_P()), new GroundcoverPlacer());
        BlockClusterFeatureConfig seaOatsCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.sea_oats.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer());
        BlockClusterFeatureConfig cattailCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.cattail.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer());
        BlockClusterFeatureConfig smallCactusCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.small_cactus.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer());
        BlockClusterFeatureConfig beachGrassCluster = FeatureManager.makeFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.beach_grass.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer());
        BlockClusterFeatureConfig frogbitCluster = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new FloatingPlantBlockStateProvider(PVJBlocks.frogbit.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(10).func_227322_d_();
        BlockClusterFeatureConfig duckweedCluster = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new FloatingPlantBlockStateProvider(PVJBlocks.duckweed.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(10).func_227322_d_();
        BlockClusterFeatureConfig glowcapCluster = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(PVJBlocks.glowcap.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        BlockClusterFeatureConfig shortGrassCluster = FeatureManager.makeFeatureConfig(new ShortGrassBlockStateProvider(), (BlockPlacer)new SimpleBlockPlacer());
        List oakBiomes = (List)PVJConfig.oakTreesBiomes.get();
        List oakBiomesSparse = (List)PVJConfig.oakTreesSparseBiomes.get();
        List birchBiomes = (List)PVJConfig.birchTreesBiomes.get();
        List birchBiomesSparse = (List)PVJConfig.birchTreesSparseBiomes.get();
        List spruceBiomes = (List)PVJConfig.spruceTreesBiomes.get();
        List spruceBiomesSparse = (List)PVJConfig.spruceTreesSparseBiomes.get();
        List jungleBiomes = (List)PVJConfig.jungleTreesBiomes.get();
        List jungleBiomesSparse = (List)PVJConfig.jungleTreesSparseBiomes.get();
        List darkOakBiomes = (List)PVJConfig.darkOakTreesBiomes.get();
        List darkOakBiomesSparse = (List)PVJConfig.darkOakTreesSparseBiomes.get();
        List acaciaBiomes = (List)PVJConfig.acaciaTreesBiomes.get();
        List acaciaBiomesSparse = (List)PVJConfig.acaciaTreesSparseBiomes.get();
        List firBiomes = (List)PVJConfig.firTreesBiomes.get();
        List firBiomesSparse = (List)PVJConfig.firTreesSparseBiomes.get();
        List pineBiomes = (List)PVJConfig.pineTreesBiomes.get();
        List pineBiomesSparse = (List)PVJConfig.pineTreesSparseBiomes.get();
        List palmBiomes = (List)PVJConfig.palmTreesBiomes.get();
        List palmBiomesSparse = (List)PVJConfig.palmTreesSparseBiomes.get();
        List willowBiomes = (List)PVJConfig.willowTreesBiomes.get();
        List willowBiomesSparse = (List)PVJConfig.willowTreesSparseBiomes.get();
        List mangroveBiomes = (List)PVJConfig.mangroveTreesBiomes.get();
        List mangroveBiomesSparse = (List)PVJConfig.mangroveTreesSparseBiomes.get();
        List redwoodBiomes = (List)PVJConfig.redwoodTreesBiomes.get();
        List redwoodBiomesSparse = (List)PVJConfig.redwoodTreesSparseBiomes.get();
        List baobabBiomes = (List)PVJConfig.baobabTreesBiomes.get();
        List baobabBiomesSparse = (List)PVJConfig.baobabTreesSparseBiomes.get();
        List aspenBiomes = (List)PVJConfig.aspenTreesBiomes.get();
        List aspenBiomesSparse = (List)PVJConfig.aspenTreesSparseBiomes.get();
        List redMapleBiomes = (List)PVJConfig.redMapleTreesBiomes.get();
        List redMapleBiomesSparse = (List)PVJConfig.redMapleTreesSparseBiomes.get();
        List orangeMapleBiomes = (List)PVJConfig.orangeMapleTreesBiomes.get();
        List orangeMapleBiomesSparse = (List)PVJConfig.orangeMapleTreesSparseBiomes.get();
        List purpleMapleBiomes = (List)PVJConfig.purpleMapleTreesBiomes.get();
        List purpleMapleBiomesSparse = (List)PVJConfig.purpleMapleTreesSparseBiomes.get();
        List cottonwoodBiomes = (List)PVJConfig.cottonwoodTreesBiomes.get();
        List cottonwoodBiomesSparse = (List)PVJConfig.cottonwoodTreesSparseBiomes.get();
        List juniperBiomes = (List)PVJConfig.juniperTreesBiomes.get();
        List juniperBiomesSparse = (List)PVJConfig.juniperTreesSparseBiomes.get();
        List rocksBiomes = (List)PVJConfig.rocksBiomes.get();
        List netherrackRocksBiomes = (List)PVJConfig.netherrackRocksBiomes.get();
        List sandstoneBiomes = (List)PVJConfig.sandstoneBiomes.get();
        List redSandstoneBiomes = (List)PVJConfig.redSandstoneBiomes.get();
        List iceChunksBiomes = (List)PVJConfig.iceChunksBiomes.get();
        List bonesBiomes = (List)PVJConfig.bonesBiomes.get();
        List bonesCommonBiomes = (List)PVJConfig.bonesCommonBiomes.get();
        List bonesNetherBiomes = (List)PVJConfig.bonesNetherBiomes.get();
        List pineconesBiomes = (List)PVJConfig.pineconesBiomes.get();
        List seashellsBiomes = (List)PVJConfig.seashellsBiomes.get();
        List bushBiomes = (List)PVJConfig.bushBiomes.get();
        List lilypadBiomes = (List)PVJConfig.lilypadBiomes.get();
        List cobwebBiomes = (List)PVJConfig.cobwebBiomes.get();
        List seagrassBiomes = (List)PVJConfig.seagrassBiomes.get();
        List ironNuggetBiomes = (List)PVJConfig.ironNuggetBiomes.get();
        List goldNuggetBiomes = (List)PVJConfig.goldNuggetBiomes.get();
        List goldNuggetCommonBiomes = (List)PVJConfig.goldNuggetCommonBiomes.get();
        List flintBiomes = (List)PVJConfig.flintBiomes.get();
        List dungBiomes = (List)PVJConfig.dungBiomes.get();
        List seaOatsBiomes = (List)PVJConfig.seaOatsBiomes.get();
        List beachGrassBiomes = (List)PVJConfig.beachGrassBiomes.get();
        List cattailBiomes = (List)PVJConfig.cattailBiomes.get();
        List smallCactusBiomes = (List)PVJConfig.smallCactusBiomes.get();
        List barkMushroomBiomes = (List)PVJConfig.barkMushroomBiomes.get();
        List frogbitBiomes = (List)PVJConfig.frogbitBiomes.get();
        List duckweedBiomes = (List)PVJConfig.duckweedBiomes.get();
        List glowcapBiomes = (List)PVJConfig.glowcapBiomes.get();
        List shortGrassBiomes = (List)PVJConfig.shortGrassBiomes.get();
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (oakBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, oakTwigsCluster, oakFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196617_K.func_176223_P(), PVJFeatures.fallenTreeFeature, 15);
            }
            if (oakBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, oakTwigsCluster, oakFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196617_K.func_176223_P(), PVJFeatures.fallenTreeFeature, 5);
            }
            if (birchBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, birchTwigsCluster, birchFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196619_M.func_176223_P(), PVJFeatures.fallenTreeFeature, 15);
            }
            if (birchBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, birchTwigsCluster, birchFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196619_M.func_176223_P(), PVJFeatures.fallenTreeFeature, 5);
            }
            if (spruceBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, spruceTwigsCluster, spruceFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196618_L.func_176223_P(), PVJFeatures.fallenTreeFeature, 15);
            }
            if (spruceBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, spruceTwigsCluster, spruceFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196618_L.func_176223_P(), PVJFeatures.fallenTreeFeature, 5);
            }
            if (jungleBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, jungleTwigsCluster, jungleFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196620_N.func_176223_P(), PVJFeatures.fallenTreeFeature, 15);
            }
            if (jungleBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, jungleTwigsCluster, jungleFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196620_N.func_176223_P(), PVJFeatures.fallenTreeFeature, 5);
            }
            if (darkOakBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, darkOakTwigsCluster, darkOakFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196623_P.func_176223_P(), PVJFeatures.fallenTreeFeature, 15);
            }
            if (darkOakBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, darkOakTwigsCluster, darkOakFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196623_P.func_176223_P(), PVJFeatures.fallenTreeFeature, 5);
            }
            if (acaciaBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, acaciaTwigsCluster, acaciaFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196621_O.func_176223_P(), PVJFeatures.fallenTreeFeature, 5);
            }
            if (acaciaBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, acaciaTwigsCluster, acaciaFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, Blocks.field_196621_O.func_176223_P(), PVJFeatures.fallenTreeFeature, 5);
            }
            if (firBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, firTwigsCluster, firFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.fir_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 5);
            }
            if (firBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, firTwigsCluster, firFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.fir_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 5);
            }
            if (pineBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, pineTwigsCluster, pineFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.pine_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (pineBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, pineTwigsCluster, pineFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.pine_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 2);
            }
            if (palmBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, palmTwigsCluster, palmFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.palm_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (palmBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, palmTwigsCluster, palmFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.palm_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 2);
            }
            if (willowBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, willowTwigsCluster, willowFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.willow_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (willowBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, willowTwigsCluster, willowFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.willow_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 2);
            }
            if (willowBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, mangroveTwigsCluster, mangroveFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.mangrove_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (mangroveBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, mangroveTwigsCluster, mangroveFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.mangrove_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 2);
            }
            if (redwoodBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, redwoodTwigsCluster, redwoodFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.redwood_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (redwoodBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, redwoodTwigsCluster, redwoodFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.redwood_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 2);
            }
            if (baobabBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, baobabTwigsCluster, baobabFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.baobab_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (baobabBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, baobabTwigsCluster, baobabFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.baobab_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 1);
            }
            if (aspenBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, aspenTwigsCluster, aspenFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.aspen_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (aspenBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, aspenTwigsCluster, aspenFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.aspen_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 1);
            }
            if (redMapleBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, redMapleTwigsCluster, redMapleFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.maple_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (redMapleBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, redMapleTwigsCluster, redMapleFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.maple_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 1);
            }
            if (orangeMapleBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, orangeMapleTwigsCluster, orangeMapleFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.maple_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (orangeMapleBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, orangeMapleTwigsCluster, orangeMapleFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.maple_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 1);
            }
            if (purpleMapleBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, purpleMapleTwigsCluster, purpleMapleFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.maple_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (purpleMapleBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, purpleMapleTwigsCluster, purpleMapleFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.maple_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 1);
            }
            if (cottonwoodBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, cottonwoodTwigsCluster, cottonwoodFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.cottonwood_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (cottonwoodBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, cottonwoodTwigsCluster, cottonwoodFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.cottonwood_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 1);
            }
            if (juniperBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, juniperTwigsCluster, juniperFallenLeavesCluster, 3, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.juniper_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 3);
            }
            if (juniperBiomesSparse.contains(biome.getRegistryName().toString())) {
                FeatureManager.addTwigsLeavesFeature(biome, juniperTwigsCluster, juniperFallenLeavesCluster, 1, false);
                FeatureManager.addFallenTreeFeature(biome, PVJBlocks.juniper_log.func_176223_P(), PVJFeatures.fallenTreeFeature, 1);
            }
            if (rocksBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyFeature(biome, rocksCluster, 2, false);
            }
            if (sandstoneBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyFeature(biome, sandstoneRocksCluster, 2, false);
            }
            if (redSandstoneBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyFeature(biome, redSandstoneRocksCluster, 2, false);
            }
            if (netherrackRocksBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addNetherFeature(biome, netherrackRocksCluster, 0.8f);
            }
            if (iceChunksBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, iceChunks, 1, 0.2f, false);
            }
            if (bonesBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, bonesCluster, 1, 0.05f, false);
            }
            if (bonesCommonBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, bonesCluster, 1, 0.2f, false);
            }
            if (bonesNetherBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addNetherFeature(biome, bonesNetherCluster, 0.4f);
                FeatureManager.addNetherFeature(biome, charredBonesNetherCluster, 0.3f);
            }
            if (pineconesBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, pineconesCluster, 3, 0.5f, false);
            }
            if (seashellsBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.oceanFloorSeashellsFeature.func_225566_b_((IFeatureConfig)new SeaGrassConfig(5, 0.0)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                FeatureManager.addFrequencyChanceFeature(biome, seashellsCluster, 2, 0.3f, false);
            }
            if (ironNuggetBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, ironNuggetCluster, 1, 0.1f, false);
            }
            if (goldNuggetBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, goldNuggetCluster, 1, 0.05f, false);
            }
            if (goldNuggetCommonBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, goldNuggetCluster, 2, 0.2f, false);
            }
            if (flintBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, flintCluster, 1, 0.15f, false);
            }
            if (dungBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, dungCluster, 2, 0.2f, false);
            }
            if (seaOatsBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, seaOatsCluster, 3, 0.8f, false);
            }
            if (beachGrassBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, beachGrassCluster, 3, 0.8f, false);
            }
            if (cattailBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.waterCattailFeature.func_225566_b_((IFeatureConfig)new SeaGrassConfig(8, 0.0)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                FeatureManager.addFrequencyFeature(biome, cattailCluster, 40, false);
            }
            if (smallCactusBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, smallCactusCluster, 2, 0.35f, false);
            }
            if (glowcapBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addChanceFeature(biome, glowcapCluster, 2, false);
            }
            if (shortGrassBiomes.contains(biome.getRegistryName().toString())) {
                FeatureManager.addFrequencyChanceFeature(biome, shortGrassCluster, 10, 0.8f, false);
            }
            if (barkMushroomBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.barkMushroomFeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215019_e.func_227446_a_((IPlacementConfig)new FrequencyConfig(50))));
            }
            if (frogbitBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)frogbitCluster).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
            }
            if (duckweedBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)duckweedCluster).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
            }
            if (lilypadBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226720_H_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
            }
            if (cobwebBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.cobwebFeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215019_e.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
            }
            if (bushBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.bushFeature.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.9f)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(32))));
            }
            if (seagrassBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203234_at.func_225566_b_((IFeatureConfig)new SeaGrassConfig(48, 0.4)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            }
            if (palmBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.palmTree.func_225566_b_((IFeatureConfig)PALM_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.5f, 1))));
            }
            if (palmBiomesSparse.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.palmTree.func_225566_b_((IFeatureConfig)PALM_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
            }
            if (mangroveBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.mangroveTree.func_225566_b_((IFeatureConfig)MANGROVE_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.mangroveRootFeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215019_e.func_227446_a_((IPlacementConfig)new FrequencyConfig(7))));
            }
            if (mangroveBiomesSparse.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.mangroveTree.func_225566_b_((IFeatureConfig)MANGROVE_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.2f, 1))));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.mangroveRootFeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215019_e.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
            }
            if (redwoodBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)PVJFeatures.megaRedwoodTree.func_225566_b_((IFeatureConfig)MEGA_REDWOOD_TREE).func_227227_a_(0.75f), (Object)PVJFeatures.redwoodTree.func_225566_b_((IFeatureConfig)REDWOOD_TREE).func_227227_a_(0.25f)), PVJFeatures.megaRedwoodTree.func_225566_b_((IFeatureConfig)MEGA_REDWOOD_TREE))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(20, 0.3f, 1))));
            }
            if (redwoodBiomesSparse.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)PVJFeatures.megaRedwoodTree.func_225566_b_((IFeatureConfig)MEGA_REDWOOD_TREE).func_227227_a_(0.2f), (Object)PVJFeatures.redwoodTree.func_225566_b_((IFeatureConfig)REDWOOD_TREE).func_227227_a_(0.15f)), PVJFeatures.megaRedwoodTree.func_225566_b_((IFeatureConfig)MEGA_REDWOOD_TREE))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(3, 0.15f, 1))));
            }
            if (baobabBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.baobabTree.func_225566_b_((IFeatureConfig)BAOBAB_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(25, 0.7f, 3))));
            }
            if (baobabBiomesSparse.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.baobabTree.func_225566_b_((IFeatureConfig)BAOBAB_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.02f, 1))));
            }
            if (juniperBiomes.contains(biome.getRegistryName().toString())) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.juniperTree.func_225566_b_((IFeatureConfig)JUNIPER_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.03f, 1))));
            }
            if (!juniperBiomesSparse.contains(biome.getRegistryName().toString())) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.juniperTree.func_225566_b_((IFeatureConfig)JUNIPER_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.01f, 1))));
        }
        PVJBiomes.boreal_forest.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)FIR_TREE).func_227227_a_(0.8f)), PVJFeatures.pineTree.func_225566_b_((IFeatureConfig)PINE_TREE))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        PVJBiomes.snowy_boreal_forest.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)FIR_TREE).func_227227_a_(0.7f)), PVJFeatures.pineTree.func_225566_b_((IFeatureConfig)PINE_TREE))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        PVJBiomes.boreal_plateau.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)FIR_TREE).func_227227_a_(0.15f)), PVJFeatures.pineTree.func_225566_b_((IFeatureConfig)PINE_TREE))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
        PVJBiomes.willow_wetlands.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.willowTree.func_225566_b_((IFeatureConfig)WILLOW_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
        PVJBiomes.aspen_grove.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)PVJFeatures.aspenTree.func_225566_b_((IFeatureConfig)ASPEN_TREE).func_227227_a_(0.3f), (Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)RED_MAPLE_TREE).func_227227_a_(0.15f), (Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)ORANGE_MAPLE_TREE).func_227227_a_(0.15f), (Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)PURPLE_MAPLE_TREE).func_227227_a_(0.15f), (Object)Feature.field_202339_q.func_225566_b_((IFeatureConfig)BIG_RED_MAPLE_TREE).func_227227_a_(0.05f), (Object)Feature.field_202339_q.func_225566_b_((IFeatureConfig)BIG_ORANGE_MAPLE_TREE).func_227227_a_(0.05f), (Object)Feature.field_202339_q.func_225566_b_((IFeatureConfig)BIG_PURPLE_MAPLE_TREE).func_227227_a_(0.05f), (Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227227_a_(0.1f)), Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        PVJBiomes.crimson_thicket.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226809_d_).func_227227_a_(0.05f), (Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226810_e_).func_227227_a_(0.15f), (Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)PURPLE_MAPLE_TREE).func_227227_a_(0.2f), (Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)RED_MAPLE_TREE).func_227227_a_(0.2f), (Object)Feature.field_202339_q.func_225566_b_((IFeatureConfig)RED_MAPLE_TREE).func_227227_a_(0.07f), (Object)Feature.field_202339_q.func_225566_b_((IFeatureConfig)PURPLE_MAPLE_TREE).func_227227_a_(0.07f), (Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)FIR_TREE).func_227227_a_(0.25f)), Feature.field_202301_A.func_225566_b_((IFeatureConfig)FIR_TREE))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(20, 0.1f, 1))));
        PVJBiomes.prairie.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PVJFeatures.cottonwoodTree.func_225566_b_((IFeatureConfig)COTTONWOOD_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.05f, 1))));
        if (((Boolean)PVJConfig.moreGrassInRivers.get()).booleanValue()) {
            DefaultBiomeFeatures.func_222314_K((Biome)Biomes.field_76781_i);
        }
    }

    private static BlockClusterFeatureConfig makeFeatureConfig(BlockStateProvider provider, BlockPlacer placer) {
        return new BlockClusterFeatureConfig.Builder(provider, placer).func_227315_a_(4).func_227322_d_();
    }

    private static BlockClusterFeatureConfig createNetherGroundcoverConfig(BlockStateProvider provider, BlockPlacer placer) {
        return new BlockClusterFeatureConfig.Builder(provider, placer).func_227315_a_(64).func_227317_b_().func_227322_d_();
    }

    private static void addTwigsLeavesFeature(Biome biome, BlockClusterFeatureConfig configTwigs, BlockClusterFeatureConfig configLeaves, int frequency, boolean underground) {
        GenerationStage.Decoration decoration = underground ? GenerationStage.Decoration.UNDERGROUND_DECORATION : GenerationStage.Decoration.VEGETAL_DECORATION;
        biome.func_203611_a(decoration, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)configTwigs).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
        biome.func_203611_a(decoration, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)configLeaves).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    private static void addFallenTreeFeature(Biome biome, BlockState log, Feature<BlockStateFeatureConfig> feature, int frequency) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(log)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    private static void addFrequencyFeature(Biome biome, BlockClusterFeatureConfig config, int frequency, boolean underground) {
        GenerationStage.Decoration decoration = underground ? GenerationStage.Decoration.UNDERGROUND_DECORATION : GenerationStage.Decoration.VEGETAL_DECORATION;
        biome.func_203611_a(decoration, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    private static void addFrequencyChanceFeature(Biome biome, BlockClusterFeatureConfig config, int frequency, float chance, boolean underground) {
        GenerationStage.Decoration decoration = underground ? GenerationStage.Decoration.UNDERGROUND_DECORATION : GenerationStage.Decoration.VEGETAL_DECORATION;
        biome.func_203611_a(decoration, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(frequency, chance))));
    }

    private static void addChanceFeature(Biome biome, BlockClusterFeatureConfig config, int chance, boolean underground) {
        GenerationStage.Decoration decoration = underground ? GenerationStage.Decoration.UNDERGROUND_DECORATION : GenerationStage.Decoration.VEGETAL_DECORATION;
        biome.func_203611_a(decoration, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(chance))));
    }

    private static void addNetherFeature(Biome biome, BlockClusterFeatureConfig configRocks, float chance) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)configRocks).func_227228_a_(Placement.field_215032_r.func_227446_a_((IPlacementConfig)new ChanceRangeConfig(chance, 0, 0, 128))));
    }
}

