/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import projectvibrantjourneys.common.blocks.BarkMushroomBlock;
import projectvibrantjourneys.init.PVJBlocks;

public class FallenTreeFeature
extends Feature<BlockStateFeatureConfig> {
    public FallenTreeFeature(Function<Dynamic<?>, ? extends BlockStateFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BlockStateFeatureConfig config) {
        Direction dir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        int length = 4 + rand.nextInt(3);
        if (!world.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)world, pos.func_177977_b())) {
            return false;
        }
        boolean shouldPlace = true;
        while (shouldPlace) {
            BlockPos checkPos = pos;
            boolean flag = false;
            for (int i = 0; i < length; ++i) {
                checkPos = checkPos.func_177972_a(dir);
                while (world.func_175623_d(checkPos.func_177977_b()) || world.func_180495_p(checkPos.func_177977_b()).func_177230_c() == Blocks.field_150355_j) {
                    checkPos = checkPos.func_177977_b();
                }
                if (this.canReplace(world.func_180495_p(checkPos))) continue;
                if (rand.nextFloat() < 0.3f) {
                    return false;
                }
                flag = true;
            }
            if (flag) {
                dir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                continue;
            }
            shouldPlace = false;
            BlockState log = config.field_227270_a_;
            boolean isBranched = false;
            BlockPos logPos = pos;
            for (int i = 0; i < length; ++i) {
                logPos = logPos.func_177972_a(dir);
                while (world.func_175623_d(logPos.func_177977_b()) || world.func_180495_p(logPos.func_177977_b()).func_177230_c() == Blocks.field_150355_j) {
                    logPos = logPos.func_177977_b();
                }
                this.placeAndDecorate(world, logPos, (BlockState)log.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)dir.func_176740_k()), dir);
                if (isBranched || !world.func_201674_k().nextBoolean()) continue;
                isBranched = true;
                Direction dir2 = world.func_201674_k().nextBoolean() ? dir.func_176735_f() : dir.func_176746_e();
                BlockPos branchPos = logPos.func_177972_a(dir2);
                this.placeAndDecorate(world, branchPos, (BlockState)log.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)dir2.func_176740_k()), dir2);
            }
            return true;
        }
        return false;
    }

    private boolean canReplace(BlockState state) {
        return state.func_177230_c() == Blocks.field_196804_gh || state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150350_a;
    }

    private void placeAndDecorate(IWorld world, BlockPos pos, BlockState state, Direction direction) {
        Direction dir2;
        world.func_180501_a(pos, state, 2);
        Direction direction2 = dir2 = world.func_201674_k().nextBoolean() ? direction.func_176735_f() : direction.func_176746_e();
        if (world.func_201674_k().nextFloat() < 0.4f) {
            BlockState barkShroom = (BlockState)PVJBlocks.bark_mushroom.func_176223_P().func_206870_a((IProperty)BarkMushroomBlock.FACING, (Comparable)dir2);
            if (world.func_175623_d(pos.func_177972_a(dir2))) {
                world.func_180501_a(pos.func_177972_a(dir2), barkShroom, 2);
            }
        }
    }
}

