/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trees;

import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;

public class AspenTreeFeature
extends AbstractSmallTreeFeature<TreeFeatureConfig> {
    public AspenTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, TreeFeatureConfig config) {
        int trunkHeight;
        int i;
        int height = config.field_227371_p_ + rand.nextInt(config.field_227328_b_);
        Optional optional = this.func_227212_a_(world, height, 3, 3, pos, config);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos blockpos = (BlockPos)optional.get();
        this.setDirtAt(world, blockpos.func_177977_b(), blockpos);
        this.func_227213_a_(world, rand, height, blockpos, 0, logs, box, config);
        for (i = trunkHeight = config.field_227330_d_ + rand.nextInt(config.field_227331_f_); i < height - 2; i += 2) {
            for (Direction d : Direction.values()) {
                if (!d.func_176740_k().func_176722_c()) continue;
                int length = 1 + height / i;
                BlockPos branchPos = pos.func_177981_b(i);
                for (int j = 1; j <= length; ++j) {
                    this.func_227217_a_((IWorldWriter)world, branchPos.func_177967_a(d, j), (BlockState)config.field_227368_m_.func_225574_a_(rand, pos).func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)d.func_176740_k()), box);
                    this.placeLeaves(world, rand, branchPos.func_177967_a(d, j), leaves, box, config);
                }
            }
        }
        for (i = trunkHeight; i <= height; ++i) {
            this.placeLeaves(world, rand, pos.func_177981_b(i), leaves, box, config);
        }
        return true;
    }

    public void placeLeaves(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> leaves, MutableBoundingBox box, TreeFeatureConfig config) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) == Math.abs(z) && !rand.nextBoolean()) continue;
                    this.func_227219_b_(world, rand, pos.func_177982_a(x, y, z), leaves, box, (BaseTreeFeatureConfig)config);
                }
            }
        }
    }
}

