/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trees;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.HugeTreeFeatureConfig;
import net.minecraft.world.gen.feature.HugeTreesFeature;

public class BaobabTreeFeature
extends HugeTreesFeature<HugeTreeFeatureConfig> {
    public BaobabTreeFeature(Function<Dynamic<?>, ? extends HugeTreeFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, HugeTreeFeatureConfig config) {
        int height = this.func_227256_a_(rand, config);
        if (!this.hasRoom(world, pos, height, (BaseTreeFeatureConfig)config)) {
            return false;
        }
        this.func_227254_a_(world, rand, pos, height, logs, box, config);
        BlockPos branchStart = pos.func_177981_b(height - 2);
        this.genBranches(world, Direction.NORTH, Direction.WEST, rand, branchStart, logs, leaves, box, config);
        this.genBranches(world, Direction.SOUTH, Direction.WEST, rand, branchStart.func_177968_d(), logs, leaves, box, config);
        this.genBranches(world, Direction.NORTH, Direction.EAST, rand, branchStart.func_177974_f(), logs, leaves, box, config);
        this.genBranches(world, Direction.SOUTH, Direction.EAST, rand, branchStart.func_177968_d().func_177974_f(), logs, leaves, box, config);
        BlockPos innerLayerPos = pos.func_177970_e(2).func_177976_e();
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                BlockPos p;
                int h = 4 + rand.nextInt(3);
                BlockPos tempPos = innerLayerPos.func_177964_d(x).func_177965_g(z).func_177981_b(h);
                for (int i = 0; i < 10 && this.canPlaceRoot(world, p = tempPos.func_177979_c(i)); ++i) {
                    this.func_227216_a_(world, rand, p, logs, box, (BaseTreeFeatureConfig)config);
                }
            }
        }
        this.placeRoot(world, rand, pos.func_177985_f(2), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177985_f(2).func_177968_d(), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177964_d(2), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177964_d(2).func_177974_f(), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177965_g(3), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177965_g(3).func_177968_d(), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177970_e(3), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177970_e(3).func_177974_f(), logs, box, (BaseTreeFeatureConfig)config);
        return true;
    }

    private void genLeafCircle(IWorldGenerationReader world, Random rand, BlockPos pos, int radius, Set<BlockPos> leaves, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        for (int j = 0; j <= 2; ++j) {
            this.func_227255_a_(world, rand, pos.func_177981_b(j), radius + 1 - j, leaves, box, config);
        }
    }

    private boolean canPlaceRoot(IWorldGenerationReader world, BlockPos pos) {
        return !world.func_217375_a(pos, s -> s.func_200132_m());
    }

    private void placeRoot(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        BlockPos p;
        int h = 2 + rand.nextInt(3);
        BlockPos tempPos = pos.func_177981_b(h);
        for (int i = 0; i < 10 && this.canPlaceRoot(world, p = tempPos.func_177979_c(i)); ++i) {
            this.func_227216_a_(world, rand, p, logs, box, config);
        }
    }

    public void genBranches(IWorldGenerationReader world, Direction d1, Direction d2, Random rand, BlockPos branchStart, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, HugeTreeFeatureConfig config) {
        BlockPos temp = branchStart;
        for (int length = 0; length <= 3 + rand.nextInt(4); ++length) {
            temp = temp.func_177972_a(d1);
            if (rand.nextBoolean()) {
                this.func_227216_a_(world, rand, temp, logs, box, (BaseTreeFeatureConfig)config);
                temp = temp.func_177972_a(d2);
            }
            if ((double)rand.nextFloat() > 0.33) {
                temp = temp.func_177984_a();
            }
            this.func_227216_a_(world, rand, temp, logs, box, (BaseTreeFeatureConfig)config);
            if (!rand.nextBoolean()) continue;
            this.func_227216_a_(world, rand, temp.func_177977_b(), logs, box, (BaseTreeFeatureConfig)config);
        }
        this.genLeafCircle(world, rand, temp, 2 + rand.nextInt(4), leaves, box, (BaseTreeFeatureConfig)config);
    }

    protected void func_227254_a_(IWorldGenerationReader world, Random rand, BlockPos pos, int height, Set<BlockPos> logs, MutableBoundingBox box, HugeTreeFeatureConfig config) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i < height - 1; ++i) {
            blockpos$mutable.func_189533_g((Vec3i)pos).func_196234_d(0, i, 0);
            if (BaobabTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutable)) {
                this.func_227216_a_(world, rand, (BlockPos)blockpos$mutable, logs, box, (BaseTreeFeatureConfig)config);
            }
            blockpos$mutable.func_189533_g((Vec3i)pos).func_196234_d(1, i, 0);
            if (BaobabTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutable)) {
                this.func_227216_a_(world, rand, (BlockPos)blockpos$mutable, logs, box, (BaseTreeFeatureConfig)config);
            }
            blockpos$mutable.func_189533_g((Vec3i)pos).func_196234_d(1, i, 1);
            if (BaobabTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutable)) {
                this.func_227216_a_(world, rand, (BlockPos)blockpos$mutable, logs, box, (BaseTreeFeatureConfig)config);
            }
            blockpos$mutable.func_189533_g((Vec3i)pos).func_196234_d(0, i, 1);
            if (!BaobabTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutable)) continue;
            this.func_227216_a_(world, rand, (BlockPos)blockpos$mutable, logs, box, (BaseTreeFeatureConfig)config);
        }
    }
}

