/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trees;

import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import projectvibrantjourneys.init.PVJBlocks;

public class JuniperTreeFeature
extends AbstractSmallTreeFeature<TreeFeatureConfig> {
    public JuniperTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, TreeFeatureConfig config) {
        int height = config.field_227371_p_ + rand.nextInt(config.field_227328_b_);
        Optional optional = this.func_227212_a_(world, height, 3, 3, pos, config);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos blockpos = (BlockPos)optional.get();
        this.setDirtAt(world, blockpos.func_177977_b(), blockpos);
        BlockPos placement = blockpos;
        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        for (int i = 0; i < height; ++i) {
            this.func_227216_a_(world, rand, placement, logs, box, (BaseTreeFeatureConfig)config);
            if (i > height / 2) {
                for (Direction d : Direction.values()) {
                    if ((double)rand.nextFloat() <= 0.15) {
                        this.placeBerries(world, placement.func_177972_a(d), leaves, box);
                        continue;
                    }
                    this.func_227219_b_(world, rand, placement.func_177972_a(d), leaves, box, (BaseTreeFeatureConfig)config);
                }
            }
            if (rand.nextBoolean()) {
                placement = placement.func_177972_a(direction);
                this.func_227216_a_(world, rand, placement, logs, box, (BaseTreeFeatureConfig)config);
                if (i > height / 3) {
                    for (Direction d : Direction.values()) {
                        this.func_227219_b_(world, rand, placement.func_177972_a(d), leaves, box, (BaseTreeFeatureConfig)config);
                    }
                }
            }
            if (rand.nextBoolean()) {
                direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            }
            placement = placement.func_177984_a();
        }
        return true;
    }

    private boolean placeBerries(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> leaves, MutableBoundingBox box) {
        if (!(JuniperTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos) || JuniperTreeFeature.func_214576_j((IWorldGenerationBaseReader)world, (BlockPos)pos) || JuniperTreeFeature.func_214571_e((IWorldGenerationBaseReader)world, (BlockPos)pos))) {
            return false;
        }
        this.func_227217_a_((IWorldWriter)world, pos, PVJBlocks.berried_juniper_leaves.func_176223_P(), box);
        leaves.add(pos.func_185334_h());
        return true;
    }
}

