/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trees;

import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;
import projectvibrantjourneys.common.blocks.GroundcoverBlock;

public class MangroveTreeFeature
extends AbstractSmallTreeFeature<TreeFeatureConfig> {
    public MangroveTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> function) {
        super(function);
    }

    protected boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, TreeFeatureConfig config) {
        int height = 5 + rand.nextInt(3) + rand.nextInt(4);
        Optional<BlockPos> optional = Optional.of(pos);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos blockpos = optional.get();
        this.setDirtAt(world, blockpos.func_177977_b(), blockpos);
        this.func_227213_a_(world, rand, height, pos, 0, logs, box, config);
        return true;
    }

    protected void func_227213_a_(IWorldGenerationReader world, Random rand, int a, BlockPos pos, int c, Set<BlockPos> logs, MutableBoundingBox box, TreeFeatureConfig config) {
        int height = 6 + rand.nextInt(3);
        BlockPos down = pos.func_177977_b();
        boolean isSoil = world.func_217375_a(down, s -> s.func_177230_c() == Blocks.field_150355_j || this.isSoil(s.func_177230_c()));
        if (isSoil && pos.func_177956_o() < world.getMaxHeight() - height - 1) {
            BlockPos posRoot;
            int rootHeight = rand.nextInt(2) + 1;
            BlockPos topBlock = posRoot = pos.func_177981_b(rootHeight - 1);
            for (int i = rootHeight; i <= height; ++i) {
                BlockPos pos1;
                if (i == rootHeight) {
                    pos1 = posRoot.func_177985_f(2);
                    while (this.isReplaceable(world, pos1)) {
                        this.func_227217_a_((IWorldWriter)world, pos1, config.field_227368_m_.func_225574_a_(rand, pos1), box);
                        logs.add(pos1.func_185334_h());
                        pos1 = pos1.func_177977_b();
                    }
                    BlockPos pos2 = posRoot.func_177965_g(2);
                    while (this.isReplaceable(world, pos2)) {
                        this.func_227217_a_((IWorldWriter)world, pos2, config.field_227368_m_.func_225574_a_(rand, pos2), box);
                        logs.add(pos2.func_185334_h());
                        pos2 = pos2.func_177977_b();
                    }
                    BlockPos pos3 = posRoot.func_177964_d(2);
                    while (this.isReplaceable(world, pos3)) {
                        this.func_227217_a_((IWorldWriter)world, pos3, config.field_227368_m_.func_225574_a_(rand, pos3), box);
                        logs.add(pos3.func_185334_h());
                        pos3 = pos3.func_177977_b();
                    }
                    BlockPos pos4 = posRoot.func_177970_e(2);
                    while (this.isReplaceable(world, pos4)) {
                        this.func_227217_a_((IWorldWriter)world, pos4, config.field_227368_m_.func_225574_a_(rand, pos4), box);
                        logs.add(pos4.func_185334_h());
                        pos4 = pos4.func_177977_b();
                    }
                }
                if (i == rootHeight + 1) {
                    pos1 = posRoot.func_177984_a();
                    pos1 = posRoot.func_177984_a().func_177976_e();
                    this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    if (rand.nextInt(3) != 0) {
                        pos1 = posRoot.func_177984_a().func_177976_e().func_177977_b();
                        this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    }
                    if (rand.nextInt(3) != 0) {
                        pos1 = posRoot.func_177984_a().func_177976_e().func_177984_a();
                        this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    }
                    pos1 = posRoot.func_177984_a().func_177974_f();
                    this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    if (rand.nextInt(3) != 0) {
                        pos1 = posRoot.func_177984_a().func_177976_e().func_177977_b();
                        this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    }
                    if (rand.nextInt(3) != 0) {
                        pos1 = posRoot.func_177984_a().func_177976_e().func_177984_a();
                        this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    }
                    pos1 = posRoot.func_177984_a().func_177978_c();
                    this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    if (rand.nextInt(3) != 0) {
                        pos1 = posRoot.func_177984_a().func_177976_e().func_177977_b();
                        this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    }
                    if (rand.nextInt(3) != 0) {
                        pos1 = posRoot.func_177984_a().func_177976_e().func_177984_a();
                        this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    }
                    pos1 = posRoot.func_177984_a().func_177968_d();
                    this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    if (rand.nextInt(3) != 0) {
                        pos1 = posRoot.func_177984_a().func_177976_e().func_177977_b();
                        this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    }
                    if (rand.nextInt(3) != 0) {
                        pos1 = posRoot.func_177984_a().func_177976_e().func_177984_a();
                        this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
                    }
                }
                BlockPos posA = pos.func_177981_b(i);
                this.func_227216_a_(world, rand, posA, logs, box, (BaseTreeFeatureConfig)config);
                topBlock = posA;
            }
            BlockState leaf = config.field_227369_n_.func_225574_a_(rand, pos);
            topBlock = topBlock.func_177982_a(0, 1, 0);
            world.func_180501_a(topBlock, leaf, 2);
            int leafHeight = 3 + rand.nextInt(2);
            for (int i = 0; i < leafHeight; ++i) {
                BlockPos leafPos = topBlock.func_177979_c(i + 1);
                int xOffset = 2;
                int zOffset = 2;
                if (i == 0 || i == leafHeight - 1) {
                    xOffset = 1;
                    zOffset = 1;
                }
                for (int j = -xOffset; j <= xOffset; ++j) {
                    for (int k = -zOffset; k <= zOffset; ++k) {
                        int x = leafPos.func_177958_n() + j;
                        int z = leafPos.func_177952_p() + k;
                        BlockPos newpos = new BlockPos(x, leafPos.func_177956_o(), z);
                        if (Math.abs(j) == Math.abs(k) && rand.nextInt(2) == 0) {
                            world.func_180501_a(newpos, leaf, 2);
                        }
                        world.func_180501_a(newpos, leaf, 2);
                    }
                }
            }
        }
    }

    public Optional<BlockPos> func_227212_a_(IWorldGenerationReader world, int p_227212_2_, int p_227212_3_, int p_227212_4_, BlockPos pos, TreeFeatureConfig config) {
        BlockPos blockpos;
        if (!config.field_227372_q_) {
            int i = world.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos).func_177956_o();
            int j = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o();
            blockpos = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            if (j - i > config.field_227336_k_) {
                return Optional.empty();
            }
        } else {
            blockpos = pos;
        }
        if (blockpos.func_177956_o() >= 1 && blockpos.func_177956_o() + p_227212_2_ + 1 <= world.getMaxHeight()) {
            for (int i1 = 0; i1 <= p_227212_2_ + 1; ++i1) {
                int j1 = config.field_227327_a_.func_225570_a_(p_227212_3_, p_227212_2_, p_227212_4_, i1);
                BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                for (int k = -j1; k <= j1; ++k) {
                    for (int l = -j1; l <= j1; ++l) {
                        if (i1 + blockpos.func_177956_o() >= 0 && i1 + blockpos.func_177956_o() < world.getMaxHeight()) {
                            blockpos$mutable.func_181079_c(k + blockpos.func_177958_n(), i1 + blockpos.func_177956_o(), l + blockpos.func_177952_p());
                            if ((MangroveTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutable) || this.isWater(world, (BlockPos)blockpos$mutable)) && (config.field_227337_l_ || !MangroveTreeFeature.func_227222_d_((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutable))) {
                                continue;
                            }
                            return Optional.empty();
                        }
                        return Optional.empty();
                    }
                }
            }
            return MangroveTreeFeature.isSoilOrFarm((IWorldGenerationBaseReader)world, (BlockPos)blockpos.func_177977_b(), (IPlantable)config.getSapling()) && blockpos.func_177956_o() < world.getMaxHeight() - p_227212_2_ - 1 ? Optional.of(blockpos) : (this.isWater(world, blockpos.func_177977_b()) ? Optional.of(blockpos) : Optional.empty());
        }
        return Optional.empty();
    }

    public boolean isWater(IWorldGenerationReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_177230_c() == Blocks.field_150355_j);
    }

    public boolean isSoil(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150354_m || block == Blocks.field_150346_d;
    }

    public boolean isReplaceable(IWorldGenerationReader world, BlockPos pos) {
        return world.func_217375_a(pos, s -> s.func_177230_c() == Blocks.field_150355_j || s.func_177230_c() == Blocks.field_150350_a || s.func_185904_a().func_76222_j() || s.func_185904_a() == Material.field_203243_f || s.func_177230_c() instanceof LilyPadBlock || s.func_185904_a() == Material.field_151585_k || s.func_177230_c() instanceof GroundcoverBlock);
    }
}

