/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trees;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.HugeTreeFeatureConfig;
import net.minecraft.world.gen.feature.HugeTreesFeature;
import projectvibrantjourneys.init.PVJBlocks;

public class MegaRedwoodTreeFeature
extends HugeTreesFeature<HugeTreeFeatureConfig> {
    public MegaRedwoodTreeFeature(Function<Dynamic<?>, ? extends HugeTreeFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, HugeTreeFeatureConfig config) {
        int height = this.func_227256_a_(rand, config);
        if (!this.hasRoom(world, pos, height, (BaseTreeFeatureConfig)config)) {
            return false;
        }
        boolean isSequoia = rand.nextBoolean();
        this.genCrown(world, rand, pos.func_177958_n(), pos.func_177952_p(), pos.func_177956_o() + height, 0, leaves, box, config);
        if (!isSequoia) {
            for (int j = pos.func_177956_o() + height - 2 - rand.nextInt(4); j > pos.func_177956_o() + height / 2; j -= 2 + rand.nextInt(4)) {
                float f = rand.nextFloat() * ((float)Math.PI * 2);
                int k = pos.func_177958_n() + (int)(0.5f + MathHelper.func_76134_b((float)f) * 4.0f);
                int l = pos.func_177952_p() + (int)(0.5f + MathHelper.func_76126_a((float)f) * 4.0f);
                for (int i1 = 0; i1 < 4; ++i1) {
                    k = pos.func_177958_n() + (int)(1.5f + MathHelper.func_76134_b((float)f) * (float)i1);
                    l = pos.func_177952_p() + (int)(1.5f + MathHelper.func_76126_a((float)f) * (float)i1);
                    BlockPos blockpos = new BlockPos(k, j - 3 + i1 / 2, l);
                    this.func_227216_a_(world, rand, blockpos, logs, box, (BaseTreeFeatureConfig)config);
                }
                int l1 = 1 + rand.nextInt(4);
                int i2 = j - 1;
                for (int j1 = j - l1; j1 <= i2; ++j1) {
                    int k1 = Math.min(-(j1 - i2 - 3), 4);
                    this.func_227257_b_(world, rand, new BlockPos(k, j1, l), k1, leaves, box, (BaseTreeFeatureConfig)config);
                }
            }
        }
        this.func_227254_a_(world, rand, pos, height, logs, box, config);
        BlockPos innerLayerPos = pos.func_177970_e(2).func_177976_e();
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                BlockPos p;
                int h = 4 + rand.nextInt(3);
                BlockPos tempPos = innerLayerPos.func_177964_d(x).func_177965_g(z).func_177981_b(h);
                if (MegaRedwoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)tempPos.func_177984_a()) || MegaRedwoodTreeFeature.func_214576_j((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177984_a()) || MegaRedwoodTreeFeature.func_214571_e((IWorldGenerationBaseReader)world, (BlockPos)tempPos.func_177984_a())) {
                    this.func_227217_a_((IWorldWriter)world, tempPos.func_177984_a(), PVJBlocks.redwood_wood.func_176223_P(), box);
                    logs.add(pos.func_185334_h());
                }
                for (int i = 0; i < 10 && this.canPlaceRoot(world, p = tempPos.func_177979_c(i)); ++i) {
                    this.func_227216_a_(world, rand, p, logs, box, (BaseTreeFeatureConfig)config);
                }
            }
        }
        this.placeRoot(world, rand, pos.func_177985_f(2), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177985_f(2).func_177968_d(), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177964_d(2), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177964_d(2).func_177974_f(), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177965_g(3), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177965_g(3).func_177968_d(), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177970_e(3), logs, box, (BaseTreeFeatureConfig)config);
        this.placeRoot(world, rand, pos.func_177970_e(3).func_177974_f(), logs, box, (BaseTreeFeatureConfig)config);
        return true;
    }

    private void genCrown(IWorldGenerationReader world, Random rand, int posX, int posZ, int posY, int height, Set<BlockPos> leaves, MutableBoundingBox box, HugeTreeFeatureConfig config) {
        int i = rand.nextInt(5) + config.field_227276_b_;
        int j = 0;
        for (int k = posY - i; k <= posY; ++k) {
            int l = posY - k;
            int i1 = height + MathHelper.func_76141_d((float)((float)l / (float)i * 3.5f));
            this.func_227255_a_(world, rand, new BlockPos(posX, k, posZ), i1 + (l > 0 && i1 == j && (k & 1) == 0 ? 1 : 0), leaves, box, (BaseTreeFeatureConfig)config);
            j = i1;
        }
    }

    private boolean canPlaceRoot(IWorldGenerationReader world, BlockPos pos) {
        return !world.func_217375_a(pos, s -> s.func_200132_m());
    }

    private void placeRoot(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        BlockPos p;
        int h = 2 + rand.nextInt(3);
        BlockPos tempPos = pos.func_177981_b(h);
        if (MegaRedwoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)tempPos.func_177984_a()) || MegaRedwoodTreeFeature.func_214576_j((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177984_a()) || MegaRedwoodTreeFeature.func_214571_e((IWorldGenerationBaseReader)world, (BlockPos)tempPos.func_177984_a())) {
            this.func_227217_a_((IWorldWriter)world, tempPos.func_177984_a(), PVJBlocks.redwood_wood.func_176223_P(), box);
            logs.add(pos.func_185334_h());
        }
        for (int i = 0; i < 10 && this.canPlaceRoot(world, p = tempPos.func_177979_c(i)); ++i) {
            this.func_227216_a_(world, rand, p, logs, box, config);
        }
    }
}

