/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trees;

import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import projectvibrantjourneys.init.PVJBlocks;

public class PalmTreeFeature
extends AbstractSmallTreeFeature<TreeFeatureConfig> {
    public PalmTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> function) {
        super(function);
    }

    protected boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, TreeFeatureConfig config) {
        int height = 5 + rand.nextInt(3) + rand.nextInt(4);
        Optional optional = this.func_227212_a_(world, height, 3, 3, pos, config);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos blockpos = (BlockPos)optional.get();
        this.setDirtAt(world, blockpos.func_177977_b(), blockpos);
        this.func_227213_a_(world, rand, height, pos, 0, logs, box, config);
        return true;
    }

    protected void func_227213_a_(IWorldGenerationReader world, Random rand, int a, BlockPos pos, int c, Set<BlockPos> logs, MutableBoundingBox box, TreeFeatureConfig config) {
        int i;
        Direction dir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        BlockPos logPos = pos;
        this.func_227216_a_(world, rand, logPos, logs, box, (BaseTreeFeatureConfig)config);
        for (int i2 = 0; i2 < a - c; ++i2) {
            logPos = logPos.func_177984_a();
            if (rand.nextBoolean()) {
                logPos = logPos.func_177972_a(dir);
                if (rand.nextInt(3) > 0) {
                    this.func_227216_a_(world, rand, logPos.func_177977_b(), logs, box, (BaseTreeFeatureConfig)config);
                }
            }
            this.func_227216_a_(world, rand, logPos, logs, box, (BaseTreeFeatureConfig)config);
        }
        BlockState leaf = config.field_227369_n_.func_225574_a_(rand, logPos);
        world.func_180501_a(logPos.func_177984_a(), leaf, 2);
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                BlockPos leafpos = new BlockPos(logPos.func_177958_n() + xOffset, logPos.func_177956_o() + 1, logPos.func_177952_p() + zOffset);
                if (leafpos.equals((Object)logPos)) continue;
                if (Math.abs(xOffset) == 2 || Math.abs(zOffset) == 2) {
                    if (rand.nextInt(3) != 0 || Math.abs(xOffset) == Math.abs(zOffset)) continue;
                    world.func_180501_a(leafpos, leaf, 2);
                    if (rand.nextInt(7) != 0 || world.func_217375_a(leafpos.func_177977_b(), state -> state.func_177230_c() instanceof LogBlock)) continue;
                    world.func_180501_a(leafpos.func_177977_b(), PVJBlocks.coconut.func_176223_P(), 2);
                    continue;
                }
                world.func_180501_a(leafpos, leaf, 2);
                if (rand.nextInt(7) != 0 || world.func_217375_a(leafpos.func_177977_b(), state -> state.func_177230_c() instanceof LogBlock)) continue;
                world.func_180501_a(leafpos.func_177977_b(), PVJBlocks.coconut.func_176223_P(), 2);
            }
        }
        for (i = 0; i < rand.nextInt(2) + 1; ++i) {
            BlockPos leafpos = new BlockPos(logPos.func_177958_n(), logPos.func_177956_o() + 1 - i, logPos.func_177952_p()).func_177985_f(2 + i);
            world.func_180501_a(leafpos, leaf, 2);
            world.func_180501_a(leafpos.func_177977_b(), leaf, 2);
        }
        for (i = 0; i < rand.nextInt(2) + 1; ++i) {
            BlockPos leafpos = new BlockPos(logPos.func_177958_n(), logPos.func_177956_o() + 1 - i, logPos.func_177952_p()).func_177965_g(2 + i);
            world.func_180501_a(leafpos, leaf, 2);
            world.func_180501_a(leafpos.func_177977_b(), leaf, 2);
        }
        for (i = 0; i < rand.nextInt(2) + 1; ++i) {
            BlockPos leafpos = new BlockPos(logPos.func_177958_n(), logPos.func_177956_o() + 1 - i, logPos.func_177952_p()).func_177964_d(2 + i);
            world.func_180501_a(leafpos, leaf, 2);
            world.func_180501_a(leafpos.func_177977_b(), leaf, 2);
        }
        for (i = 0; i < rand.nextInt(2) + 1; ++i) {
            BlockPos leafpos = new BlockPos(logPos.func_177958_n(), logPos.func_177956_o() + 1 - i, logPos.func_177952_p()).func_177970_e(2 + i);
            world.func_180501_a(leafpos, leaf, 2);
            world.func_180501_a(leafpos.func_177977_b(), leaf, 2);
        }
    }
}

