/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trees;

import com.mojang.datafixers.Dynamic;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import projectvibrantjourneys.init.PVJBlocks;

public class RedwoodTreeFeature
extends AbstractSmallTreeFeature<TreeFeatureConfig> {
    public RedwoodTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, TreeFeatureConfig config) {
        int height = config.field_227371_p_ + rand.nextInt(config.field_227328_b_);
        int j = config.field_227330_d_ >= 0 ? config.field_227330_d_ + rand.nextInt(config.field_227331_f_ + 1) : height - (config.field_227334_i_ + rand.nextInt(config.field_227335_j_ + 1));
        int k = config.field_227327_a_.func_225573_a_(rand, j, height, config);
        Optional optional = this.func_227212_a_(world, height, 3, 3, pos, config);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos blockpos = (BlockPos)optional.get();
        this.setDirtAt(world, blockpos.func_177977_b(), blockpos);
        config.field_227327_a_.func_225571_a_(world, rand, config, height, j, k, blockpos, leaves);
        this.func_227213_a_(world, rand, height, blockpos, 0, logs, box, config);
        Iterator it = Direction.Plane.HORIZONTAL.iterator();
        while (it.hasNext()) {
            this.placeRoot(world, rand, blockpos.func_177972_a((Direction)it.next()), logs, box, (BaseTreeFeatureConfig)config);
        }
        return true;
    }

    private boolean canPlaceRoot(IWorldGenerationReader world, BlockPos pos) {
        return !world.func_217375_a(pos, s -> s.func_200132_m());
    }

    private void placeRoot(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        BlockPos p;
        int h = 1 + rand.nextInt(3);
        BlockPos tempPos = pos.func_177981_b(h);
        if (RedwoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)tempPos.func_177984_a()) || RedwoodTreeFeature.func_214576_j((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177984_a()) || RedwoodTreeFeature.func_214571_e((IWorldGenerationBaseReader)world, (BlockPos)tempPos.func_177984_a())) {
            this.func_227217_a_((IWorldWriter)world, tempPos.func_177984_a(), PVJBlocks.redwood_wood.func_176223_P(), box);
            logs.add(pos.func_185334_h());
        }
        for (int i = 0; i < 10 && this.canPlaceRoot(world, p = tempPos.func_177979_c(i)); ++i) {
            this.func_227216_a_(world, rand, p, logs, box, config);
        }
    }
}

